/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CollectionUtils {
    public static <T> Set<T> toSetFromArray(T[] array) {
        HashSet<T> retVal = null;
        if (array != null) {
            retVal = new HashSet<T>(array.length, 1.0f);
            for (T t : array) {
                retVal.add(t);
            }
        }
        return retVal;
    }

    public static <T> T[] getArrayIntersection(T[] arr1, T[] arr2, boolean matchNull) {
        Object[] retVal = null;
        if (arr1 != null && arr2 != null) {
            HashSet<T> intersectionSet = new HashSet<T>();
            for (T t1 : arr1) {
                for (T t2 : arr2) {
                    if (matchNull) {
                        if (t1 == null) {
                            if (t2 != null) continue;
                            intersectionSet.add(null);
                            continue;
                        }
                        if (!t1.equals(t2)) continue;
                        intersectionSet.add(t1);
                        continue;
                    }
                    if (t1 == null || !t1.equals(t2)) continue;
                    intersectionSet.add(t1);
                }
            }
            if (intersectionSet.size() > 0) {
                retVal = intersectionSet.toArray(new Object[intersectionSet.size()]);
            }
        }
        return retVal;
    }

    public static String toString(Collection collection) {
        String retVal = "null";
        if (collection != null) {
            boolean addComma = false;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (Object o : collection) {
                if (addComma) {
                    sb.append(',');
                }
                sb.append(o);
                addComma = true;
            }
            sb.append(']');
            retVal = sb.toString();
        }
        return retVal;
    }
}

