/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import oracle.core.ojdl.LogMessage;
import oracle.dms.context.ExecutionContext;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.Log;
import oracle.dms.instrument.LogLevel;
import oracle.dms.instrument.LogProperties;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.Refresh;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.SensorIntf;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.ClientObjectHolderImpl;
import oracle.dms.util.ClientObjectKey;
import oracle.dms.util.ClientObjectKeyManager;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.PrependStringBuffer;
import oracle.dms.util.Time;

public abstract class Sensor
implements SensorIntf {
    protected static final String OPS_UNITS = "ops";
    protected static final String MSEC_UNITS = "msecs";
    protected static final String KBYTES_UNITS = "kbytes";
    protected static final String ELEMS_UNITS = "elems";
    protected static final String THREADS_UNITS = "threads";
    protected static final String TIMESTAMP_UNITS = "timestamp";
    protected static final String NULL_UNITS = "";
    private final ClientObjectHolderImpl mClientObjectHolderImpl = new ClientObjectHolderImpl(ClientObjectKeyManager.ClientObjectHolderType.SENSOR);
    private Level _msgLevel = Level.DEBUG;
    private Level _logLevel = Level.OFF;
    private boolean _hasLogLevel = true;
    private static Level _flushLevel = Level.TRACE;
    private String _componentId;
    private String _moduleId;
    private LogProperties _logProperties = null;
    private SensorDescriptor _descptor = null;
    protected volatile long _lastUpdate = 0L;
    private long _resetTime = 0L;
    volatile boolean _alive;
    private Noun _noun;
    protected static final int NAME_LEN = 500;
    protected String _name;
    protected String _description;
    protected String _logMsg;
    Metric[] _metrics = new Metric[10];
    protected Refresh _refresh;
    private final String _path;
    private static ConcurrentHashMap<String, Sensor> _sensorCache = new ConcurrentHashMap();
    private static final String NO_METRICS = "NO_METRICS";
    private static final String FORMAT_ERROR = "SENSOR_FORMAT_ERROR";
    protected long mCreateTime = -1L;

    protected Sensor() {
        this._noun = null;
        this._alive = true;
        this._description = null;
        this._name = "temporary";
        this._hasLogLevel = false;
        this._path = "/temporary";
        this.mCreateTime = Time.currentTimeMillis();
    }

    protected Sensor(Noun parent, String name, String desc) {
        this(true, parent, name, desc);
    }

    Sensor(boolean sanitizeName, Noun parent, String name, String desc) {
        Event evt;
        if (parent == null || name == null || name.trim().length() == 0 || desc == null) {
            throw new InstrumentationException("DMS-50752", "Sensor()", "parent:" + parent + ", name:" + (name == null ? null : "''") + ", desc:" + desc);
        }
        if (!parent.isAlive()) {
            throw new InstrumentationException("DMS-50754", "Sensor()", "Parent " + parent + " is not alive.");
        }
        if (parent.getChild(name) != null) {
            throw new InstrumentationException("DMS-50754", "Sensor()", "Parent " + parent + " already has child of name " + name + ".");
        }
        this._noun = parent;
        this._alive = true;
        this._description = DMSUtil.sanitize(desc, 1023, false, false);
        this._name = sanitizeName ? DMSUtil.sanitize(name, 511, true, true) : name;
        this._path = this.buildPath(this._noun, this._name);
        this._logLevel = parent.getLogLevel();
        this._hasLogLevel = false;
        NounDescriptor ndesc = parent.getDescriptor();
        if (ndesc != null) {
            this._descptor = ndesc.getSensorDescriptor(this._name);
            if (this._descptor == null) {
                String type = this.getClass().getName();
                int index = type.lastIndexOf(46);
                if (index != -1) {
                    type = type.substring(index + 1);
                }
                this._descptor = new SensorDescriptor(this._name, this._description, type);
                ndesc.addSensorDescriptor(this._descptor);
            }
        }
        if ((evt = StatisticsProducer._sensorCreate) != null) {
            evt.occurred(new Object[]{this});
        }
        this.initLogging();
        this.mCreateTime = Time.currentTimeMillis();
        this._noun.sensorAdded(this);
    }

    protected static Noun createParent(String pathname) {
        if (pathname == null || pathname.length() == 0) {
            throw new InstrumentationException("DMS-50752", "Sensor.createParent()", "pathname:" + (pathname == null ? null : "''"));
        }
        String parentName = DMSUtil.getParentFromPath(pathname);
        if (parentName.length() > 0) {
            return Noun.create(parentName, NULL_UNITS);
        }
        return Noun.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        EventSourceType sourceType;
        Noun parent = this.getParent();
        if (parent == null) {
            return;
        }
        Noun noun = parent;
        synchronized (noun) {
            Sensor sensor = this;
            synchronized (sensor) {
                if (!this._alive) {
                    return;
                }
                this.cleanupCache();
                Event evt = StatisticsProducer._sensorDestroy;
                if (evt != null) {
                    evt.occurred(new Object[]{this});
                }
                this._noun.sensorDestroyed(this);
                this.removeRefresh();
                for (int i = this._metrics.length - 1; i >= 0; --i) {
                    if (this._metrics[i] == null) continue;
                    this._metrics[i].destroy();
                }
                this._alive = false;
            }
        }
        EventReportingManager eMgr = EventSystem.getEventReportingManager();
        if (eMgr != null && this._noun.getDescriptor() != null && this._noun.getDescriptor().getEventable(EventActionType.DELETE) && (sourceType = this.getSourceType()) != null) {
            eMgr.reportEvent(this, sourceType, EventActionType.DELETE, this.mCreateTime, null, null);
        }
    }

    public String getDescription() {
        return this._description;
    }

    EventSourceType getSourceType() {
        return null;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String toString() {
        return this._path;
    }

    private String buildPath(Noun noun, String sensorName) {
        String retVal = "/".equals(noun.toString()) ? "/" + sensorName : noun.toString() + "/" + sensorName;
        return retVal;
    }

    public Noun getParent() {
        return this._noun;
    }

    @Override
    public NounIntf getParentNoun() {
        return this._noun;
    }

    public abstract Object getValue(Metric var1);

    private int derivToIndex(int derivation) {
        int retval = -1;
        switch (derivation) {
            case 4: {
                retval = 2;
                break;
            }
            case 8: {
                retval = 3;
                break;
            }
            case 2: {
                retval = 1;
                break;
            }
            case 16: {
                retval = 4;
                break;
            }
            case 32: {
                retval = 5;
                break;
            }
            case 64: {
                retval = 6;
                break;
            }
            case 128: {
                retval = 7;
                break;
            }
            case 1: {
                retval = 0;
            }
        }
        return retval;
    }

    @Override
    public Object getValue(int derivation) {
        if (!this._alive) {
            return new ErrorObject(DMSNLSupport.getString(NO_METRICS));
        }
        int dex = this.derivToIndex(derivation);
        if (dex == -1) {
            return null;
        }
        if (this._metrics[dex] == null) {
            return null;
        }
        return this.getValue(this._metrics[dex]);
    }

    public Object getValue() {
        if (!this._alive) {
            return new ErrorObject(DMSNLSupport.getString(NO_METRICS));
        }
        for (int i = 0; i < 10; ++i) {
            if (this._metrics[i] == null) continue;
            return this.getValue(this._metrics[i]);
        }
        return new ErrorObject(DMSNLSupport.getString(NO_METRICS));
    }

    @Override
    public Refresh getRefresh() {
        return this._refresh;
    }

    @Override
    public void setRefresh(Refresh r) {
        this._refresh = r;
    }

    @Override
    public void removeRefresh() {
        this._refresh = null;
    }

    @Override
    public abstract void deriveMetric(int var1);

    @Override
    public abstract void reset();

    public static Sensor get(String pathname) {
        int nextDelim;
        if (pathname == null || pathname.length() <= 1) {
            return null;
        }
        Sensor s = Sensor.lookupCache(pathname);
        if (s != null) {
            return s;
        }
        char delim = pathname.charAt(0);
        String leaf = DMSUtil.getLeafFromPath(pathname);
        if (leaf == null) {
            return null;
        }
        String sanitizedLeaf = DMSUtil.sanitize(leaf, 500, true, true);
        String parentPath = DMSUtil.getParentFromPath(pathname);
        if (parentPath == null) {
            return null;
        }
        String sanitizedParent = DMSUtil.sanitize(parentPath, 500, false, false);
        String sanitizedPathname = sanitizedParent + delim + sanitizedLeaf;
        Noun n = Noun.getRoot();
        int index = 1;
        do {
            String name;
            if ((nextDelim = sanitizedPathname.indexOf(delim, index)) == index) {
                return null;
            }
            if (nextDelim < 0) {
                name = sanitizedPathname.substring(index);
                s = n.getSensor(name);
                if (s != null) {
                    s.addToCache(pathname);
                    if (!pathname.equals(sanitizedPathname)) {
                        s.addToCache(sanitizedPathname);
                    }
                }
                return s;
            }
            name = sanitizedPathname.substring(index, nextDelim);
            if ((n = n.getChild(name)) != null) continue;
            return null;
        } while ((index = nextDelim + 1) < sanitizedPathname.length());
        return null;
    }

    @Override
    public synchronized long getResetTime() {
        return this._resetTime;
    }

    synchronized void setResetTime(long timeStamp) {
        if (this._resetTime < timeStamp) {
            this._resetTime = timeStamp;
        }
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public synchronized long getUpdateTime() {
        return this._lastUpdate;
    }

    void setUpdateTime() {
        long timeStamp = Time.currentTimeMillis();
        this.setUpdateTime(timeStamp);
    }

    synchronized void setUpdateTime(long timeStamp) {
        if (this._lastUpdate < timeStamp) {
            this._lastUpdate = timeStamp;
        }
    }

    protected static final Sensor lookupCache(String pathname) {
        return _sensorCache.get(pathname);
    }

    protected void addToCache(String pathname) {
        if (!this._alive) {
            return;
        }
        _sensorCache.put(pathname, this);
    }

    private void cleanupCache() {
        _sensorCache.clear();
    }

    public synchronized void getMetrics(Vector<Metric> holder) {
        if (!this._alive || holder == null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (this._metrics[i] == null) continue;
            holder.addElement(this._metrics[i]);
        }
    }

    public synchronized Metric getMetric(String name) {
        if (!this._alive || name == null) {
            return null;
        }
        for (int i = 0; i < 10; ++i) {
            if (this._metrics[i] == null || !this._metrics[i].getName().equals(name)) continue;
            return this._metrics[i];
        }
        return null;
    }

    @Override
    public Metric getMetric(int derivation) {
        if (!this._alive) {
            return null;
        }
        int dex = this.derivToIndex(derivation);
        if (dex == -1) {
            return null;
        }
        return this._metrics[dex];
    }

    public SensorDescriptor getDescriptor() {
        return this._descptor;
    }

    public synchronized void configureLogging(String mesg, Level level) {
        if (!this._alive) {
            return;
        }
        if (mesg != null) {
            this._logMsg = mesg;
        }
        this._msgLevel = level;
    }

    @Deprecated
    public void configureLogging(String mesg, LogLevel level) {
        this.configureLogging(mesg, (Level)level);
    }

    private String formatMessage(String evtMsg, Object[] inserts) {
        try {
            DMSUtil.cleanFormatArgs(inserts);
            return MessageFormat.format(evtMsg, inserts);
        }
        catch (Exception e) {
            return DMSNLSupport.getMessage(FORMAT_ERROR, new Object[]{this.getClass().getName(), evtMsg, this._description});
        }
    }

    @Override
    public void setLogLevel(Level level) {
        if (!this._alive) {
            return;
        }
        if (level == null) {
            this._hasLogLevel = false;
            this._logLevel = this.getParent().getLogLevel();
        } else {
            this._hasLogLevel = true;
            this._logLevel = level;
        }
    }

    @Override
    @Deprecated
    public void setLogLevel(LogLevel level) {
        this.setLogLevel((Level)level);
    }

    protected void notifyLogLevel(Level level) {
        if (!this._hasLogLevel) {
            this._logLevel = level;
        }
    }

    public static void setLogLevel(String path, Level level) {
        Sensor s = Sensor.get(path);
        if (s != null) {
            s.setLogLevel(level);
        }
    }

    @Deprecated
    public static void setLogLevel(String path, LogLevel level) {
        Sensor.setLogLevel(path, (Level)level);
    }

    @Override
    public Level getLogLevel() {
        return this._logLevel;
    }

    public static Level getLogLevel(String path) {
        Sensor s = Sensor.get(path);
        if (s != null) {
            return s.getLogLevel();
        }
        return null;
    }

    @Override
    public boolean isLoggable() {
        return this._msgLevel.isLessThanOrEqual(this._logLevel) && this._msgLevel != Level.OFF && Log.isLoggingEnabled();
    }

    @Override
    public boolean isLoggable(Level level) {
        Level msgLevel = level != null ? level : this._msgLevel;
        return msgLevel.isLessThanOrEqual(this._logLevel) && msgLevel != Level.OFF && Log.isLoggingEnabled();
    }

    public boolean isGonnaLog() {
        return this.isLoggable();
    }

    @Deprecated
    public boolean isGonnaLog(LogLevel level) {
        return this.isLoggable((Level)level);
    }

    protected void logActivation(String msg) {
        String mesg = this._logMsg != null ? this._logMsg : msg;
        this.logActivation(this._msgLevel, mesg, null, null);
    }

    protected void logActivation(String msg, Object[] inserts) {
        String mesg = this._logMsg != null ? this._logMsg : msg;
        mesg = this.formatMessage(mesg, inserts);
        this.logActivation(this._msgLevel, mesg, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logActivation(Level msgLevel, String msg, Throwable thr, Properties props) {
        String msgGroup;
        Sensor sensor = this;
        synchronized (sensor) {
            if (this._moduleId == null) {
                this.initComponentAndModule();
                Noun parent = this.getParent();
                if (this._logProperties == null) {
                    this._logProperties = new LogProperties();
                    this._logProperties.setLogProperty("OrganizationId", parent.getLogProperty("OrganizationId"));
                    this._logProperties.setLogProperty("HostingClientId", parent.getLogProperty("HostingClientId"));
                    this._logProperties.setLogProperty("UserId", parent.getLogProperty("HostingClientId"));
                    this._logProperties.setLogProperty("MessageId", parent.getLogProperty("MessageId"));
                }
            }
        }
        Level level = msgLevel != null ? msgLevel : this._msgLevel;
        String msgText = msg;
        String orgId = this._logProperties.getLogProperty("OrganizationId", props);
        String msgId = this._logProperties.getLogProperty("MessageId", props);
        String hclId = this._logProperties.getLogProperty("HostingClientId", props);
        String usrId = this._logProperties.getLogProperty("UserId", props);
        String supplDetail = this._logProperties.getLogProperty("SupplDet", props);
        if (supplDetail == null && thr != null) {
            supplDetail = Sensor.getStackTrace(thr);
        }
        if (msgText == null) {
            msgText = this._logProperties.getLogProperty("MessageTxt", this._logMsg);
        }
        if ((msgGroup = this.getParent().getType()) == "n/a") {
            msgGroup = null;
        }
        ExecutionContext ectx = ExecutionContext.get();
        LogMessage.InstanceId ecid = new LogMessage.InstanceId(ectx.getECID(), 0);
        LogMessage logMsg = new LogMessage(orgId, this._componentId, msgId, hclId, level.getMessageType(), msgGroup, level.getArbLevel(), this._moduleId, null, usrId, null, null, ecid, null, msgText, null, null, supplDetail);
        this._noun.log(logMsg, level.getValue() < _flushLevel.getValue());
    }

    @Override
    public void setLoggingProperties(Properties properties) {
        String msgTxt;
        Level msgLevel;
        if (!this._alive || properties == null) {
            return;
        }
        String strLevel = properties.getProperty("Level");
        if (strLevel != null && (msgLevel = Level.getLevel(strLevel)) != null) {
            this._msgLevel = msgLevel;
        }
        if ((msgTxt = properties.getProperty("MessageTxt")) != null) {
            this._logMsg = msgTxt;
        }
        if (this._logProperties == null) {
            this._logProperties = new LogProperties(properties);
        } else {
            this._logProperties.setLogProperties(properties);
        }
    }

    private void initLogging() {
        Noun parent = this.getParent();
        this._msgLevel = Level.getLevel(parent.getLogProperty("Level"));
        if (this._msgLevel == null) {
            this._msgLevel = Level.DEBUG;
        }
        this._hasLogLevel = false;
        this._logLevel = parent.getLogLevel();
        if (DMSProperties.hasSensorProperties()) {
            String strLev;
            HashMap<String, String> prop;
            String name = this.toString();
            int i = name.indexOf(47);
            if (i > 0) {
                name = name.substring(i);
            }
            if ((prop = DMSProperties.getSensorProperties(name)) != null && (strLev = (String)prop.get("loglevel")) != null) {
                this.setLogLevel(Level.getLevel(strLev));
            }
        }
    }

    private void initComponentAndModule() {
        PrependStringBuffer buf = new PrependStringBuffer(50, this.getName());
        Noun n3 = null;
        Noun n2 = this.getParent();
        for (Noun n1 = n2.getParent(); n1 != null; n1 = n1.getParent()) {
            if (n3 != null) {
                buf.prepend('/');
                buf.prepend(n3.getName());
            }
            n3 = n2;
            n2 = n1;
        }
        if (n3 != null) {
            this._componentId = n3.getName();
            this._moduleId = buf.toString();
        } else {
            this._componentId = this.getName();
            this._moduleId = null;
        }
    }

    private static String getStackTrace(Throwable thr) {
        if (thr != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            thr.printStackTrace(pw);
            return sw.toString();
        }
        return null;
    }

    boolean isAlive() {
        return this._alive;
    }

    static void shutdown() {
        if (DMSConsole.s_logger.isLoggable(java.util.logging.Level.FINE)) {
            DMSConsole.s_logger.log(java.util.logging.Level.FINE, "Sensor class is being shutdown {0}\n{1}", new String[]{Long.toString(System.currentTimeMillis()), ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
        _sensorCache.clear();
        _flushLevel = Level.TRACE;
    }

    public long getCreateTime() {
        return this.mCreateTime;
    }

    public ActivationParameter[] getActivationParametersFromEvent(oracle.dms.event.Event event) {
        return null;
    }

    public Object setClientObject(ClientObjectKey key, Object value) {
        return this.mClientObjectHolderImpl.setClientObject(key, value);
    }

    public Object getClientObject(ClientObjectKey key) {
        return this.mClientObjectHolderImpl.getClientObject(key);
    }
}

