/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jmx;

import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.dms.jmx.JmxUtil;
import oracle.dms.util.DMSNLSupport;

class MetricMBeanInfo
extends ModelMBeanInfoSupport {
    private Map<String, ModelMBeanAttributeInfo> m_attributeInfos = Collections.synchronizedMap(new HashMap());
    private String m_descriptionKey;
    private static final String ATTR = "attribute";
    private static final String OPER = "operation";
    private static final String NOTF = "notification";
    private static final String CONS = "constructor";
    private static final String ALL = "all";
    private static final long serialVersionUID = -1227726986558L;

    MetricMBeanInfo(String className, String descriptionKey, List<ModelMBeanAttributeInfo> attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications, Descriptor mbeandescriptor) {
        super(className, descriptionKey, attributes == null ? null : attributes.toArray(new ModelMBeanAttributeInfo[0]), constructors, operations, notifications, mbeandescriptor);
        if (descriptionKey == null) {
            throw new IllegalArgumentException("descriptionKey=" + descriptionKey);
        }
        this.m_descriptionKey = descriptionKey;
        if (attributes != null) {
            for (ModelMBeanAttributeInfo attributeInfo : attributes) {
                this.m_attributeInfos.put(attributeInfo.getName(), attributeInfo);
            }
        }
    }

    public void shutdown() {
        this.m_attributeInfos.clear();
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public String getDescription() {
        Locale locale = JmxUtil.getClientLocale();
        return DMSNLSupport.getString(this.m_descriptionKey, "", locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Descriptor[] getDescriptors(String inDescriptorType) throws MBeanException, RuntimeOperationsException {
        if (inDescriptorType == null || inDescriptorType.length() == 0) {
            inDescriptorType = ALL;
        }
        Map<String, ModelMBeanAttributeInfo> map = this.m_attributeInfos;
        synchronized (map) {
            if (ATTR.equalsIgnoreCase(inDescriptorType)) {
                Descriptor[] retList = new Descriptor[this.m_attributeInfos.size()];
                int i = 0;
                for (ModelMBeanAttributeInfo infos : this.m_attributeInfos.values()) {
                    retList[i++] = infos.getDescriptor();
                }
                return retList;
            }
            if (ALL.equalsIgnoreCase(inDescriptorType)) {
                Descriptor[] modelMBeanNotifications;
                Descriptor[] modelMBeanConstructors;
                int numDescriptor = this.m_attributeInfos.size();
                Descriptor[] modelMBeanOperations = super.getDescriptors(OPER);
                if (modelMBeanOperations != null) {
                    numDescriptor += modelMBeanOperations.length;
                }
                if ((modelMBeanConstructors = super.getDescriptors(CONS)) != null) {
                    numDescriptor += modelMBeanConstructors.length;
                }
                if ((modelMBeanNotifications = super.getDescriptors(NOTF)) != null) {
                    numDescriptor += modelMBeanNotifications.length;
                }
                Descriptor[] retList = new Descriptor[numDescriptor];
                int num = 0;
                for (ModelMBeanAttributeInfo infos : this.m_attributeInfos.values()) {
                    retList[num++] = infos.getDescriptor();
                }
                if (modelMBeanOperations != null && modelMBeanOperations.length > 0) {
                    System.arraycopy(modelMBeanOperations, 0, retList, num, modelMBeanOperations.length);
                    num += modelMBeanOperations.length;
                }
                if (modelMBeanConstructors != null && modelMBeanConstructors.length > 0) {
                    System.arraycopy(modelMBeanConstructors, 0, retList, num, modelMBeanConstructors.length);
                    num += modelMBeanConstructors.length;
                }
                if (modelMBeanNotifications != null && modelMBeanNotifications.length > 0) {
                    System.arraycopy(modelMBeanNotifications, 0, retList, num, modelMBeanNotifications.length);
                    num += modelMBeanNotifications.length;
                }
                return retList;
            }
            return super.getDescriptors(inDescriptorType);
        }
    }

    @Override
    public void setDescriptor(Descriptor inDescriptor, String inDescriptorType) throws MBeanException, RuntimeOperationsException {
        String excMsg = "Exception occurred trying to set the descriptors of the MBean";
        if (inDescriptor == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Null Descriptor");
            throw new RuntimeOperationsException(iae, "Exception occurred trying to set the descriptors of the MBean");
        }
        if ((inDescriptorType == null || "".equals(inDescriptorType)) && (inDescriptorType = (String)inDescriptor.getFieldValue("descriptorType")) == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Descriptor type is invalid");
            throw new RuntimeOperationsException(iae, "Exception occurred trying to set the descriptors of the MBean");
        }
        String inDescriptorName = (String)inDescriptor.getFieldValue("name");
        if (ATTR.equalsIgnoreCase(inDescriptorType)) {
            ModelMBeanAttributeInfo attrInfo = this.m_attributeInfos.get(inDescriptorName);
            if (attrInfo == null) {
                IllegalArgumentException iae = new IllegalArgumentException("Descriptor name is invalid: type=" + inDescriptorType + "; name=" + inDescriptorName);
                throw new RuntimeOperationsException(iae, "Exception occurred trying to set the descriptors of the MBean");
            }
            attrInfo.setDescriptor(inDescriptor);
        } else {
            super.setDescriptor(inDescriptor, inDescriptorType);
        }
    }

    @Override
    public ModelMBeanAttributeInfo getAttribute(String inName) throws RuntimeOperationsException {
        if (inName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute Name is null"), "Exception occurred trying to get the ModelMBeanAttributeInfo of the MBean");
        }
        return this.m_attributeInfos.get(inName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanAttributeInfo[] getAttributes() {
        Map<String, ModelMBeanAttributeInfo> map = this.m_attributeInfos;
        synchronized (map) {
            MBeanAttributeInfo[] ret = new ModelMBeanAttributeInfo[this.m_attributeInfos.size()];
            this.m_attributeInfos.values().toArray(ret);
            return ret;
        }
    }

    void setAttribute(ModelMBeanAttributeInfo attrInfo) throws RuntimeOperationsException {
        if (attrInfo == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeInfo is null"), "Exception occurred trying to set the ModelMBeanAttributeInfo of the MBean");
        }
        String attrName = attrInfo.getName();
        if (attrName == null) {
            IllegalArgumentException iae = new IllegalArgumentException("ModelMBeanAttributeInfo name is invalid");
            throw new RuntimeOperationsException(iae);
        }
        this.m_attributeInfos.put(attrName, attrInfo);
    }

    void removeAttribute(String attrName) {
        if (attrName == null) {
            IllegalArgumentException iae = new IllegalArgumentException("ModelMBeanAttributeInfo name is invalid");
            throw new RuntimeOperationsException(iae);
        }
        this.m_attributeInfos.remove(attrName);
    }

    private Object writeReplace() throws ObjectStreamException {
        ModelMBeanAttributeInfo[] attrs = new ModelMBeanAttributeInfo[this.m_attributeInfos.size()];
        this.m_attributeInfos.values().toArray(attrs);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(this.getClassName(), this.getDescription(), attrs, (ModelMBeanConstructorInfo[])this.getConstructors(), (ModelMBeanOperationInfo[])this.getOperations(), (ModelMBeanNotificationInfo[])this.getNotifications(), this.getDescriptor());
        return info;
    }
}

