/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.ext.soa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.ContextParameterFactory;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.DMSCtxParamDescriptor;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.internal.WrapUtils;
import oracle.dms.ext.soa.MessageBundle;

public final class SOADMSCtxParamDescriptors {
    public static final String ContextParameterDescriptorResourcePrefix = "DMSContextParameterDescriptor_";
    public static ContextParameterDescriptor ExternalBlackBoxComponents;
    public static final int EXTERNAL_COMPONENTS_DMS_VALUE_MAX_LENGTH = 256;

    public static synchronized void init() {
        ContextParameterFactory factory = DMSContextManager.getContextParameterFactory();
        ExternalBlackBoxComponents = factory.createDescriptor("oracle.dms.ext.soa.ExternalBlackBoxComponents", MessageBundle.class, ContextParameterDescriptorResourcePrefix, 256, 0, true, ContextParameterDescriptor.Scope.LOCAL_CONTEXT_FAMILY_PLUS_CHILDREN_AND_DB, null, Integer.MAX_VALUE);
    }

    public static void addExternalBlackBoxComponent(ExternalComponent ec) {
        SOADMSCtxParamDescriptors.addExternalBlackBoxComponent(ec, null);
    }

    public static void addExternalBlackBoxComponent(ExternalComponent ec, Map<String, String> props) {
        SOADMSCtxParamDescriptors.addExternalBlackBoxComponent(ec.toString(), props);
    }

    public static void addExternalBlackBoxComponent(String externalComponentName) {
        SOADMSCtxParamDescriptors.addExternalBlackBoxComponent(externalComponentName, null);
    }

    public static void addExternalBlackBoxComponent(String externalComponentName, Map<String, String> props) {
        ExecutionContext ctx = ExecutionContext.get();
        String dmsExternalComps = ctx.getValue(ExternalBlackBoxComponents);
        ExternalComponentInstance newInstance = new ExternalComponentInstance(externalComponentName, props);
        String newDmsExternalComps = newInstance.add(dmsExternalComps);
        ctx.setValue(ExternalBlackBoxComponents, newDmsExternalComps);
    }

    @Deprecated
    public static List<ExternalComponent> getExternalBlackBoxComponents() {
        List<ExternalComponentInstance> instances = SOADMSCtxParamDescriptors.getExternalBlackBoxComponentInstances();
        ArrayList<ExternalComponent> externalComponents = new ArrayList<ExternalComponent>();
        for (ExternalComponentInstance instance : instances) {
            ExternalComponent ec = ExternalComponent.toExternalComponent(instance.getComponentType());
            if (ec == null) continue;
            externalComponents.add(ec);
        }
        return externalComponents;
    }

    public static List<ExternalComponentInstance> getExternalBlackBoxComponentInstances() {
        ExecutionContext ctx = ExecutionContext.get();
        String dmsExternalComps = ctx.getValue(ExternalBlackBoxComponents);
        List<ExternalComponentInstance> externalComponents = ExternalComponentInstance.extractFromDMSString(dmsExternalComps);
        return externalComponents;
    }

    public static void unsetExternalBlackBoxComponents() {
        ExecutionContext ctx = ExecutionContext.get();
        ctx.setValue(ExternalBlackBoxComponents, null);
    }

    public static String getFlowId() {
        ExecutionContext ctx = ExecutionContext.get();
        String flowIdValue = ctx.getValue(DMSCtxParamDescriptor.FlowId);
        if (flowIdValue == null) {
            flowIdValue = WrapUtils.createECID();
            ctx.setValue(DMSCtxParamDescriptor.FlowId, flowIdValue);
        }
        return flowIdValue;
    }

    public static boolean isFlowIdSet() {
        String flowId;
        boolean retVal = false;
        ExecutionContext ctx = DMSContextManager.getActiveContext();
        if (ctx != null && (flowId = ctx.getValue(DMSCtxParamDescriptor.FlowId)) != null) {
            retVal = true;
        }
        return retVal;
    }

    public static enum ExternalComponent implements Serializable
    {
        OSB("OSB"),
        B2B("B2B"),
        MFT("MFT"),
        OEP("OEP"),
        ODI("ODI"),
        ADF("ADF"),
        OAG("OAG"),
        ESS("ESS");

        public static final ExternalComponent[] allExternalComponents;
        public static final String COMPONENT_SEPARATOR = "|";
        public static final String PROPERTIES_BEGIN_SEPARATOR = "[";
        public static final String PROPERTIES_END_SEPARATOR = "]";
        public static final String PROPERTIES_SEPARATOR = ";";
        public static final String PROPERTY_VALUE_SEPARATOR = ",";
        private String externalComponentType_;

        private ExternalComponent(String externalComponent) {
            this.externalComponentType_ = externalComponent;
        }

        public String toString() {
            return this.externalComponentType_;
        }

        private static ExternalComponent toExternalComponent(String externalComponent) {
            for (ExternalComponent ec : allExternalComponents) {
                if (!ec.toString().equals(externalComponent)) continue;
                return ec;
            }
            return null;
        }

        static {
            allExternalComponents = new ExternalComponent[]{OSB, B2B, MFT, OEP, ODI, ADF, OAG, ESS};
        }
    }

    public static class ExternalComponentInstance {
        private String componentType = null;
        private Map<String, String> properties = null;

        ExternalComponentInstance(ExternalComponent externalComponentType) {
            this.componentType = externalComponentType.toString();
        }

        ExternalComponentInstance(ExternalComponent externalComponentType, Map<String, String> props) {
            this.componentType = externalComponentType.toString();
            this.properties = props;
        }

        ExternalComponentInstance(String externalComponentName) {
            this.componentType = externalComponentName;
        }

        ExternalComponentInstance(String externalComponentName, Map<String, String> props) {
            this.componentType = externalComponentName;
            this.properties = props;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public String getComponentType() {
            return this.componentType;
        }

        String add(String dmsExternalComponents) {
            List<ExternalComponentInstance> instances;
            if (dmsExternalComponents != null) {
                instances = ExternalComponentInstance.extractFromDMSString(dmsExternalComponents);
                ExternalComponentInstance lastInstance = instances.get(instances.size() - 1);
                if (this.componentType.equals(lastInstance.componentType)) {
                    if (this.properties == null || this.properties.size() == 0) {
                        return dmsExternalComponents;
                    }
                    if (lastInstance.properties == null || lastInstance.properties.size() == 0) {
                        instances.remove(lastInstance);
                    }
                }
            } else {
                instances = new ArrayList<ExternalComponentInstance>();
            }
            instances.add(this);
            StringBuffer allInstances = new StringBuffer();
            boolean addComponentSeparator = false;
            String lastValue = "";
            for (ExternalComponentInstance instance : instances) {
                if (addComponentSeparator) {
                    allInstances.append("|");
                }
                allInstances.append(instance.toString());
                if (allInstances.length() > 256) {
                    return lastValue;
                }
                lastValue = allInstances.toString();
                addComponentSeparator = true;
            }
            return allInstances.toString();
        }

        static List<ExternalComponentInstance> extractFromDMSString(String dmsExternalComponents) {
            ArrayList<ExternalComponentInstance> externalComps = new ArrayList<ExternalComponentInstance>();
            if (dmsExternalComponents != null) {
                StringTokenizer st = new StringTokenizer(dmsExternalComponents, "|");
                while (st.hasMoreElements()) {
                    externalComps.add(ExternalComponentInstance.toExternalComponentInstance((String)st.nextElement()));
                }
            }
            return externalComps;
        }

        static ExternalComponentInstance toExternalComponentInstance(String stringRepresentation) {
            int beginProperties = stringRepresentation.indexOf("[");
            String componentName = stringRepresentation.substring(0, beginProperties);
            HashMap<String, String> properties = null;
            int endProperties = stringRepresentation.indexOf("]");
            if (endProperties > beginProperties + 1) {
                properties = new HashMap<String, String>();
                String propertiesStringRepresentation = stringRepresentation.substring(beginProperties + 1, endProperties);
                StringTokenizer st = new StringTokenizer(propertiesStringRepresentation, ";");
                while (st.hasMoreElements()) {
                    String propertyKeyValue = (String)st.nextElement();
                    String propertyKey = propertyKeyValue.substring(0, propertyKeyValue.indexOf(","));
                    String propertyValue = propertyKeyValue.substring(propertyKeyValue.indexOf(",") + 1, propertyKeyValue.length());
                    properties.put(propertyKey, propertyValue);
                }
            }
            return new ExternalComponentInstance(componentName, properties);
        }

        public String toString() {
            StringBuffer thisInstance = new StringBuffer();
            thisInstance.append(this.componentType);
            thisInstance.append("[");
            if (this.properties != null) {
                boolean addPropertiesSeparator = false;
                for (Map.Entry<String, String> property : this.properties.entrySet()) {
                    if (addPropertiesSeparator) {
                        thisInstance.append(";");
                    }
                    thisInstance.append(property.getKey());
                    thisInstance.append(",");
                    thisInstance.append(property.getValue());
                    addPropertiesSeparator = true;
                }
            }
            thisInstance.append("]");
            return thisInstance.toString();
        }
    }
}

