/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.was;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.dms.ReadableValueHolder;
import oracle.security.jps.util.SubjectUtil;

public class WASUserValueHolder
implements ReadableValueHolder<String> {
    private static Logger s_logger = Logger.getLogger("oracle.dms.context", "oracle.dms.context.ContextResourceBundle");

    public WASUserValueHolder() throws Exception {
        Class.forName("oracle.security.jps.util.SubjectUtil");
    }

    @Override
    public String getValue() {
        String retVal = null;
        try {
            retVal = SubjectUtil.getUserName((Subject)this.getCurrentSubject());
        }
        catch (Throwable t) {
            retVal = null;
        }
        return retVal;
    }

    public Subject getCurrentSubject() {
        Subject subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return Subject.getSubject(AccessController.getContext());
            }
        });
        if (subject == null) {
            subject = SubjectUtil.getCurrentSubject();
            if (s_logger.isLoggable(Level.FINER)) {
                s_logger.finer("unable to get Subject using JAAS API; using JPS security got: " + subject);
            }
        } else if (s_logger.isLoggable(Level.FINER)) {
            s_logger.finer("using the JAAS API got Subject: " + subject);
        }
        return subject;
    }
}

