/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.dms.table.RowSupport;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.Table;
import oracle.dms.table.TableGroup;
import oracle.dms.table.TableGroupProvider;
import oracle.dms.table.TableSupport;
import oracle.dms.util.QueryOptions;

public abstract class TableSource
implements TableGroupProvider {
    protected static final TableSupport[] EMPTY_TABLES = new TableSupport[0];
    protected static final TableSupport[][] EMPTY_TABLE_ARRAY = new TableSupport[0][];
    protected static final String[] ZERO_TABLE_NAMES = new String[0];
    protected static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");

    protected TableSource() {
    }

    public abstract String[] getTableNames(QueryOptions var1);

    public abstract void getTableNames(Collection<String> var1, QueryOptions var2);

    public abstract int tableCount(QueryOptions var1);

    public Table getTable(String name, QueryOptions options) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Table[][] tables = this.getTables(new String[][]{{name}}, new QueryOptions[]{options});
        if (tables == null || tables.length == 0 || tables[0].length == 0) {
            return null;
        }
        return tables[0][0];
    }

    public abstract boolean containsTable(String var1, QueryOptions var2);

    public Table[] getTables(String[] names, QueryOptions options) {
        if (names == null || names.length == 0) {
            names = this.getTableNames(options);
        }
        if (names == null || names.length == 0) {
            return EMPTY_TABLES;
        }
        Table[][] tables = this.getTables(new String[][]{names}, new QueryOptions[]{options});
        return tables == null || tables.length == 0 ? EMPTY_TABLES : tables[0];
    }

    public Table[][] getTables(String[][] tableNames, QueryOptions[] options) {
        if (tableNames == null) {
            throw new IllegalArgumentException("tableNames=null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options=null");
        }
        if (tableNames.length != options.length) {
            throw new IllegalArgumentException("must be same length: tableNames=" + tableNames.length + " options=" + options.length);
        }
        HashMap<String, Table> cache = null;
        if (tableNames.length > 1) {
            cache = new HashMap<String, Table>();
        }
        Table[][] tables = new TableSupport[tableNames.length][];
        for (int i = 0; i < tableNames.length; ++i) {
            if (options[i] == null) {
                options[i] = new QueryOptions();
            }
            if (tableNames[i] == null || tableNames[i].length == 0) {
                tableNames[i] = this.getTableNames(options[i]);
            }
            if (tableNames[i] == null || tableNames[i].length == 0) {
                tables[i] = EMPTY_TABLES;
                continue;
            }
            tables[i] = new TableSupport[tableNames[i].length];
            for (int j = 0; j < tableNames[i].length; ++j) {
                TableSupport table = null;
                if (cache != null) {
                    table = (TableSupport)cache.get(tableNames[i][j]);
                }
                if (table != null) {
                    TableSupport newTable;
                    boolean hasRows = table.hasRows();
                    boolean hasSchema = table.hasSchema();
                    if (!hasRows && options[i].includeRows()) {
                        newTable = (TableSupport)this.getTable(tableNames[i][j], new QueryOptions(QueryOptions.QueryType.ROWS));
                        table.updateNoRows(newTable, false, false);
                        RowSupport[] rows = newTable.getRows();
                        table.setRows(rows);
                    } else if (!hasSchema && options[i].includeSchema()) {
                        newTable = (TableSupport)this.getTable(tableNames[i][j], new QueryOptions(QueryOptions.QueryType.SCHEMA));
                        SchemaSupport schema = (SchemaSupport)newTable.getSchema();
                        schema.setTable(table);
                        table.setSchema(schema);
                        table.updateNoRows(newTable, false, false);
                    }
                    tables[i][j] = table;
                    continue;
                }
                tables[i][j] = (TableSupport)this.getTable(tableNames[i][j], options[i]);
                if (cache == null || tables[i][j] == null || !((TableSupport)tables[i][j]).isCacheable()) continue;
                cache.put(tableNames[i][j], tables[i][j]);
            }
        }
        if (cache != null) {
            cache.clear();
        }
        return tables;
    }

    @Override
    public TableGroup getTableGroup(String[][] tableNames, QueryOptions[] options) {
        return new TableGroup((TableSupport[][])this.getTables(tableNames, options));
    }
}

