/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import oracle.dms.http.Request;
import oracle.dms.reporter.BranchTreeletNode;
import oracle.dms.reporter.LeafTreeletNode;
import oracle.dms.reporter.TreeletReporter;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;

public class PdmlReporter
extends TreeletReporter {
    public PdmlReporter(Request request) {
        super(request);
        this.m_treeletOptions.setFormat("pdml");
    }

    @Override
    void startWalkTree(PrintWriter out) {
        out.print("<statistics>\n");
    }

    @Override
    void endWalkTree(PrintWriter out) {
        out.print("</statistics>\n");
    }

    @Override
    void printHeading(PrintWriter out) {
        if (!"true".equalsIgnoreCase(this.m_request.getParameter("nodoctype"))) {
            out.print("<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE pdml>\n");
        }
        out.print("<pdml version='");
        out.print("11.0");
        out.print("' id='");
        out.print(this.m_id);
        out.print("' host='");
        out.print(DMSUtil.getLocalHostname());
        out.print("' name='");
        out.print(this.m_name);
        out.print("' timestamp='");
        long tstamp = Time.currentTimeMillis();
        out.print(tstamp);
        out.print("'>\n");
    }

    @Override
    void printEnding(PrintWriter out) {
        out.print("</pdml>\n");
    }

    @Override
    void startPrintBranchNode(BranchTreeletNode node, PrintWriter out) {
        node.startPrintNode(this.m_treeletOptions, out);
    }

    @Override
    void printLeafNode(LeafTreeletNode node, PrintWriter out) {
        node.printNode(this.m_treeletOptions, out);
    }

    @Override
    void endPrintBranchNode(BranchTreeletNode node, PrintWriter out) {
        node.endPrintNode(this.m_treeletOptions, out);
    }
}

