/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import oracle.dms.reporter.LeafTreeletNode;
import oracle.dms.reporter.TreeletNode;
import oracle.dms.reporter.TreeletOptions;

public abstract class BranchTreeletNode<T>
extends TreeletNode<T> {
    private HashMap<String, BranchTreeletNode<T>> m_branches = new HashMap();
    private HashMap<String, LeafTreeletNode> m_leaves = new HashMap();

    protected BranchTreeletNode(T root) {
        super(root);
    }

    protected BranchTreeletNode(String name, BranchTreeletNode<T> parent, T mappedNode) {
        super(name, parent, mappedNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clear() {
        super.clear();
        HashMap<String, TreeletNode> hashMap = this.m_branches;
        synchronized (hashMap) {
            for (BranchTreeletNode<T> branchTreeletNode : this.m_branches.values()) {
                branchTreeletNode.clear();
            }
            this.m_branches.clear();
        }
        hashMap = this.m_leaves;
        synchronized (hashMap) {
            for (LeafTreeletNode leafTreeletNode : this.m_leaves.values()) {
                leafTreeletNode.clear();
            }
            this.m_leaves.clear();
        }
    }

    public Collection<LeafTreeletNode> getLeaves(boolean isOrdered) {
        if (isOrdered) {
            TreeSet<LeafTreeletNode> set = new TreeSet<LeafTreeletNode>(this.m_leaves.values());
            return set;
        }
        return this.m_leaves.values();
    }

    public Collection<BranchTreeletNode<T>> getBranches(boolean isOrdered) {
        if (isOrdered) {
            TreeSet<BranchTreeletNode<T>> set = new TreeSet<BranchTreeletNode<T>>(this.m_branches.values());
            return set;
        }
        return this.m_branches.values();
    }

    public void addBranch(String name, BranchTreeletNode<T> child) {
        if (name == null || child == null) {
            return;
        }
        this.m_branches.put(name, child);
    }

    public void addLeaf(String name, LeafTreeletNode child) {
        if (name == null || child == null) {
            return;
        }
        this.m_leaves.put(name, child);
    }

    public LeafTreeletNode findLeaf(String name) {
        if (name == null) {
            return null;
        }
        return this.m_leaves.get(name);
    }

    public BranchTreeletNode findBranch(String name) {
        if (name == null) {
            return null;
        }
        return this.m_branches.get(name);
    }

    public abstract String getTable();

    protected abstract void startPrintNode(TreeletOptions var1, PrintWriter var2);

    protected abstract void endPrintNode(TreeletOptions var1, PrintWriter var2);
}

