/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal.wls;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.dms.context.DMSCtxParamDescriptor;
import oracle.dms.context.RID;
import oracle.dms.context.internal.AbstractExecutionContext;
import oracle.dms.context.internal.ActivationException;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.ParameterValueListener;
import oracle.dms.context.internal.wls.WLSContextFamily;
import oracle.dms.context.internal.wls.WLSContextManager;
import oracle.dms.context.internal.wls.WLSDiagParamDescriptor;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.util.Time;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextHelper;
import weblogic.diagnostics.integration.DiagnosticIntegrationManager;
import weblogic.workarea.WorkContextMap;

public class WLSExecutionContext
extends AbstractExecutionContext<WLSContextManager, WLSContextFamily, WLSExecutionContext>
implements DomainExecutionContext<WLSExecutionContext> {
    private boolean mIsActive = false;
    private byte[] mWLSContext = null;
    private long mOrderIndex = Long.MIN_VALUE;
    private long mThreadId = Long.MIN_VALUE;

    WLSExecutionContext(WLSContextManager mgr, WLSContextFamily family, RID rid, boolean inheritable) {
        super(mgr, family, rid);
        this.mInheritable = inheritable;
    }

    WLSExecutionContext(WLSContextManager mgr, WLSExecutionContext parentCtx) {
        super(mgr, parentCtx);
        this.mInheritable = true;
    }

    long[] getThreadDetails() {
        return new long[]{this.mThreadId, this.mOrderIndex};
    }

    void setThreadDetails(long threadId, long orderIndex) {
        this.mThreadId = threadId;
        this.mOrderIndex = orderIndex;
    }

    protected WLSExecutionContext createContextNotUsedX(WLSContextManager mgr, WLSContextFamily family, RID rid) {
        return new WLSExecutionContext(mgr, family, rid, true);
    }

    @Override
    protected WLSExecutionContext createChildContext(WLSContextManager mgr, WLSExecutionContext parentContext) {
        return new WLSExecutionContext(mgr, parentContext);
    }

    @Override
    public void activate(boolean oldContextKnown, WLSExecutionContext oldContext) throws ActivationException {
        this.activate(null, true, true, true);
    }

    @Override
    public void activate() throws ActivationException {
        this.activate(null, true, true, true);
    }

    void activate(WorkContextMap wcMap, boolean updateDiagnosticContext, boolean updatePrimaryWorkContextMapEntry, boolean updatePrivateThreadReference) throws ActivationException {
        DiagnosticIntegrationManager dcim;
        ((WLSContextManager)this.mContextManager).associateWithThread(wcMap, this, updatePrimaryWorkContextMapEntry, updatePrivateThreadReference);
        this.mActivationTime = Time.currentTimeMillis();
        if (updateDiagnosticContext && (dcim = ((WLSContextManager)this.mContextManager).getDiagnosticIntegrationManager()) != null) {
            if (this.mWLSContext != null) {
                try {
                    dcim.setContext(this.mWLSContext);
                }
                catch (IOException ioe) {
                    this.sLogger.log(Level.WARNING, "Failed to set(WLDF) Context using a previously stored WLDF context value of size " + this.mWLSContext.length, ioe);
                }
                this.mWLSContext = null;
            } else {
                dcim.setContextId(this.getECID(), this.getRIDasString());
                for (WLSDiagParamDescriptor wldp : WLSDiagParamDescriptor.values()) {
                    String value = null;
                    DMSCtxParamDescriptor dmsp = wldp.getDMSCtxParamDescriptor();
                    if (dmsp.getScope().isSharedInFamily()) {
                        value = this.setGlobalValue(dmsp.getName(), null);
                        this.setLocalValue(null, dmsp.getName());
                    } else {
                        value = this.setLocalValue(dmsp.getName(), null);
                        this.setGlobalValue(null, dmsp.getName());
                    }
                    if (value == null) continue;
                    dcim.setSecondaryIdFromEC(wldp.getSecondaryId(), value);
                }
            }
        }
        this.mIsActive = true;
        EventReportingManager eMgr = EventSystem.getEventReportingManager();
        if (eMgr != null) {
            eMgr.reportEvent(this.getAsMutableExecutionContext(), EventSourceType.EXECUTION_CONTEXT, EventActionType.START, this.mActivationTime, this.getAsMutableExecutionContext(), null);
        }
    }

    public void disassociateWithThread(boolean clearDiagnosticContext) {
        DiagnosticIntegrationManager dcim;
        if (clearDiagnosticContext && (dcim = ((WLSContextManager)this.mContextManager).getDiagnosticIntegrationManager()) != null) {
            try {
                dcim.setContext((byte[])null);
            }
            catch (IOException ioe) {
                this.sLogger.log(Level.WARNING, "Failed to set(WLDF)Context to null.", ioe);
            }
        }
        ((WLSContextManager)this.mContextManager).disassociateFromThread(null, this);
        this.mIsActive = false;
    }

    @Override
    protected void disassociateWithThread() {
        this.disassociateWithThread(true);
    }

    @Override
    protected void suspend2() {
        DiagnosticIntegrationManager dcim = ((WLSContextManager)this.mContextManager).getDiagnosticIntegrationManager();
        if (dcim != null) {
            try {
                this.mWLSContext = dcim.getContext();
            }
            catch (IOException ioe) {
                this.sLogger.log(Level.WARNING, "Failed to get(WLDF)Context with the intention of storing it for resumption anon.", ioe);
            }
            try {
                dcim.setContext((byte[])null);
            }
            catch (IOException ioe) {
                this.sLogger.log(Level.WARNING, "Failed to set(WLDF)Context to null.", ioe);
            }
        }
        ((WLSContextManager)this.mContextManager).disassociateFromThread(null, this);
    }

    @Override
    public boolean isActive() {
        return this.mIsActive;
    }

    @Override
    public void setInheritable(boolean inheritable) {
        super.setInheritable(inheritable);
        ((WLSContextManager)this.mContextManager).updateWorkContextMap(this);
    }

    @Override
    public void setValueAccordingToDescriptor(ContextParameterDescriptorInternal descriptor, String value) {
        WLSDiagParamDescriptor wlsDesc = WLSDiagParamDescriptor.findWLSDiagParamDescriptor(descriptor);
        if (wlsDesc != null) {
            DiagnosticIntegrationManager dcim = ((WLSContextManager)this.mContextManager).getDiagnosticIntegrationManager();
            if (dcim != null) {
                dcim.setSecondaryIdFromEC(wlsDesc.getSecondaryId(), value);
            }
        } else {
            super.setValueAccordingToDescriptor(descriptor, value);
        }
    }

    @Override
    public Map<String, String> getAllValues(boolean calledFromContextsThread) {
        Map<String, String> retVal = super.getAllValues(calledFromContextsThread);
        for (WLSDiagParamDescriptor wlpd : WLSDiagParamDescriptor.values()) {
            String value = null;
            value = DiagnosticContextHelper.getSecondaryId((DiagnosticContext.SecondaryId)wlpd.getSecondaryId());
            if (value != null) {
                retVal.put(wlpd.getDMSCtxParamDescriptor().getName(), value);
                continue;
            }
            retVal.remove(wlpd.getDMSCtxParamDescriptor().getName());
        }
        return retVal;
    }

    @Override
    public Map<String, String> getPropagateMap() {
        HashMap<String, String> retVal = new HashMap<String, String>(this.mCtxGlobalMap);
        if (this.mIsActive) {
            for (WLSDiagParamDescriptor wlpd : WLSDiagParamDescriptor.values()) {
                String value = DiagnosticContextHelper.getSecondaryId((DiagnosticContext.SecondaryId)wlpd.getSecondaryId());
                if (value == null) {
                    retVal.remove(wlpd.getDMSCtxParamDescriptor().getName());
                    continue;
                }
                retVal.put(wlpd.getDMSCtxParamDescriptor().getName(), value);
            }
        }
        return retVal;
    }

    Map<String, String> getGlobalMap() {
        return this.mCtxGlobalMap;
    }

    @Override
    public String getValueAccordingToDescriptor(ContextParameterDescriptorInternal descriptor, boolean calledFromContextsThread) {
        String retVal = null;
        WLSDiagParamDescriptor wlsDesc = WLSDiagParamDescriptor.findWLSDiagParamDescriptor(descriptor);
        if (wlsDesc != null) {
            if (calledFromContextsThread) {
                retVal = DiagnosticContextHelper.getSecondaryId((DiagnosticContext.SecondaryId)wlsDesc.getSecondaryId());
            }
        } else {
            retVal = super.getValueAccordingToDescriptor(descriptor, calledFromContextsThread);
        }
        return retVal;
    }

    @Override
    @Deprecated
    public String getPrettyInstanceStateSummary(Level level) {
        StringBuilder sb = new StringBuilder();
        sb.append("WLSExecutionContext instance: ").append(this.getIDasString());
        if (level.intValue() <= Level.FINE.intValue()) {
            sb.append("\n        mThreadId: ").append(this.mThreadId);
            sb.append("\n      mOrderIndex: ").append(this.mOrderIndex);
            sb.append("\n       mSuspended: ").append(this.mSuspended);
            sb.append("\n  mActivationTime: ").append(this.mActivationTime);
            sb.append("\n   mCtxContentMap: ").append(this.mCtxContentMap == null ? "null" : Integer.toString(this.mCtxContentMap.size()));
            if (level.intValue() <= Level.FINER.intValue() && this.mCtxContentMap != null) {
                for (Map.Entry entry : this.mCtxContentMap.entrySet()) {
                    sb.append("\n                 : ").append(entry.getKey()).append(" -> ").append(entry.getValue());
                }
            }
            sb.append("\n     mCtxGlobalMap: ").append(this.mCtxGlobalMap == null ? "null" : Integer.toString(this.mCtxGlobalMap.size()));
            if (level.intValue() <= Level.FINER.intValue() && this.mCtxGlobalMap != null) {
                for (Map.Entry entry : this.mCtxGlobalMap.entrySet()) {
                    sb.append("\n                 : ").append(entry.getKey()).append(" -> ").append(entry.getValue());
                }
            }
            sb.append("\n     mCtxLocalMap: ").append(this.mCtxLocalMap == null ? "null" : Integer.toString(this.mCtxLocalMap.size()));
            if (level.intValue() <= Level.FINER.intValue() && this.mCtxLocalMap != null) {
                for (Map.Entry entry : this.mCtxLocalMap.entrySet()) {
                    sb.append("\n                 : ").append(entry.getKey()).append(" -> ").append(entry.getValue());
                }
            }
            sb.append("\n     mInheritable: ").append(this.mInheritable);
            sb.append("\n       mListeners: ").append(this.mValueListeners == null ? "null" : Integer.toString(this.mValueListeners.size()));
            if (level.intValue() <= Level.FINER.intValue() && this.mValueListeners != null) {
                for (ParameterValueListener lsnr : this.mValueListeners) {
                    sb.append("\n                  ").append(lsnr.getClass().getName()).append(" -> ").append(lsnr.toString());
                }
            }
            sb.append("\n family:" + ((WLSContextFamily)this.mContextFamily).getPrettyInstanceStateSummary(level));
            sb.append("\n");
        }
        return sb.toString();
    }
}

