/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.context.ContextContent;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.DMSCtxParamDescriptor;
import oracle.dms.context.ExecutionContextComponents;
import oracle.dms.context.ExecutionContextListener;
import oracle.dms.context.ExecutionContextStub;
import oracle.dms.context.RID;
import oracle.dms.context.WrapOptions;
import oracle.dms.context.WrappedContextDecoder;
import oracle.dms.context.internal.ActivationException;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.WrapUtils;

public class ExecutionContext {
    protected DomainExecutionContext mDomainContext = null;
    public static final String KEY = "ECID-Context";
    public static final String HTTP_HEADER_ECID = "X-ORACLE-DMS-ECID";
    @Deprecated
    public static final String URI = "URI";
    public static final int RAW = 0;
    public static final int XML = 0;
    public static final String ECID = "ECID";
    public static final String CLIENTID = "client_identifier";
    @Deprecated
    public static final long RID_FACTOR = 512L;
    public static final String LOCALE = "ctxLocale";
    public static final int KEEP = -1;
    public static final int TOSS = 0;
    public static final int EXPIRE = -2;
    public static final Character SEP_ID = Character.valueOf(',');
    @Deprecated
    public static final long ROOT = 0L;

    public static ExecutionContext get(boolean inheritable) {
        return DMSContextManager.getContext(inheritable);
    }

    @Deprecated
    public static ExecutionContext getActiveContext(long threadId) {
        return DMSContextManager.getContext(threadId);
    }

    public long getActivationTime() {
        return this.mDomainContext.getActivationTime();
    }

    public static ExecutionContext get() {
        return DMSContextManager.getContext(true);
    }

    public static ExecutionContext get(Object key) {
        return DMSContextManager.activateStashedContext(key);
    }

    public static boolean resume(Object key) {
        return DMSContextManager.resumeSuspendedContext(key);
    }

    public static void stash(Object key) {
        DMSContextManager.stash(key);
    }

    public static boolean removeStashedContext(Object key) {
        boolean retVal = DMSContextManager.removeStashedContext(key);
        return retVal;
    }

    public static String extractECID(String ecidStr) {
        if (!DMSContextManager.isEnabled()) {
            return "";
        }
        if (ecidStr != null && !ecidStr.equals("")) {
            int idx = ecidStr.indexOf(44);
            if (idx > 0) {
                return ecidStr.substring(0, idx - 1);
            }
            return ecidStr;
        }
        return null;
    }

    public static boolean unwrap(String wrap) {
        boolean retVal = DMSContextManager.unwrap(wrap, false);
        return retVal;
    }

    public static boolean unwrapChildContext(String wrap) {
        boolean retVal = DMSContextManager.unwrap(wrap, true);
        return retVal;
    }

    public static String wrapContext() {
        if (!DMSContextManager.isEnabled()) {
            return "";
        }
        ExecutionContext ctx = ExecutionContext.get();
        if (ctx != null) {
            return ctx.wrap();
        }
        return null;
    }

    public static void deactivateContext() {
        ExecutionContext ctx = DMSContextManager.getActiveContext();
        if (ctx != null) {
            ctx.deactivate(true);
        }
    }

    public static String generateNewWrappedContext() {
        return WrapUtils.generateNewWrappedContext();
    }

    public static String getChildWrappedContext(String wrapped) {
        return WrapUtils.getChildWrappedContext(wrapped);
    }

    public static ExecutionContext pushChild() {
        if (!DMSContextManager.isEnabled()) {
            return ExecutionContextStub.getTheStub(ExecutionContextStub.StubType.DISABLED);
        }
        ExecutionContext retVal = null;
        ExecutionContext parent = DMSContextManager.getActiveContext();
        if (parent != null) {
            DomainExecutionContext parentDctx = parent.getDomainExecutionContext();
            if (parentDctx != null) {
                DomainExecutionContext dctx = null;
                dctx = parentDctx.createChild();
                try {
                    dctx.activate(true, parentDctx);
                    dctx.setPusher(parentDctx);
                    retVal = dctx.getAsMutableExecutionContext();
                }
                catch (ActivationException e) {
                    DMSContextManager.getLogger().log(Level.WARNING, "DMS-57014", e);
                }
            } else {
                IllegalStateException illegalStateException = new IllegalStateException("ExecutionContext found with no DomainExecutionContext.");
            }
        }
        if (retVal == null) {
            retVal = ExecutionContext.get();
        }
        return retVal;
    }

    public static ExecutionContext pushNewContext() {
        if (!DMSContextManager.isEnabled()) {
            return ExecutionContextStub.getTheStub(ExecutionContextStub.StubType.DISABLED);
        }
        ExecutionContext pusher = DMSContextManager.getActiveContext();
        if (pusher != null) {
            pusher.deactivate(true);
        }
        ExecutionContext ctx = ExecutionContext.get();
        DomainExecutionContext dctx = ctx.getDomainExecutionContext();
        if (pusher != null) {
            dctx.setPusher(pusher.getDomainExecutionContext());
        }
        return ctx;
    }

    public static void pop() {
        DomainExecutionContext dctx;
        DomainExecutionContext pusher;
        if (!DMSContextManager.isEnabled()) {
            return;
        }
        ExecutionContext ctx = DMSContextManager.getActiveContext();
        if (ctx != null && (pusher = (dctx = ctx.getDomainExecutionContext()).getPusher()) != null) {
            try {
                pusher.activate(true, (DomainExecutionContext)dctx);
            }
            catch (ActivationException e) {
                DMSContextManager.getLogger().log(Level.WARNING, "DMS-57014", e);
            }
        }
    }

    @Deprecated
    public ExecutionContext(DomainExecutionContext domainContext) {
        this.mDomainContext = domainContext;
    }

    @Deprecated
    public DomainExecutionContext getDomainExecutionContext() {
        return this.mDomainContext;
    }

    public ExecutionContext createChild() {
        DomainExecutionContext dctx = this.mDomainContext.createChild();
        ExecutionContext ctx = dctx.getAsMutableExecutionContext();
        return ctx;
    }

    @Deprecated
    public ExecutionContext getParent() {
        ExecutionContext retVal = null;
        Object dctx = this.mDomainContext.getParent();
        if (dctx != null) {
            retVal = dctx.getAsImmutableExecutionContext();
        }
        return retVal;
    }

    @Deprecated
    public int getKidCount() {
        return this.mDomainContext.getRID().getKidCount();
    }

    public boolean isInheritable() {
        return this.mDomainContext.isInheritable();
    }

    public void setInheritable(boolean inheritable) {
        this.mDomainContext.setInheritable(inheritable);
    }

    public void suspend(Object key) {
        if (!DMSContextManager.isEnabled()) {
            return;
        }
        this.mDomainContext.suspend(key);
    }

    public String getECID() {
        return this.mDomainContext.getECID();
    }

    public String toString() {
        return this.mDomainContext.toString();
    }

    public String getIDasString() {
        return this.mDomainContext.getIDasString();
    }

    public String getRIDasString() {
        return this.mDomainContext.getRIDasString();
    }

    public String limitedWrap() {
        return this.mDomainContext.wrap(WrapOptions.LIMIT_WRAP_OPTIONS);
    }

    public String wrap() {
        return this.mDomainContext.wrap(WrapOptions.DEFAULT_WRAP_OPTIONS);
    }

    public String wrap(WrapOptions wrapOptions) {
        return this.mDomainContext.wrap(wrapOptions);
    }

    @Deprecated
    public long getParentRID() {
        return -1L;
    }

    public RID getRID() {
        return this.mDomainContext.getRID();
    }

    @Deprecated
    public long[] getChildren() {
        return this.mDomainContext.getChildren();
    }

    public boolean isActive() {
        return this.mDomainContext.isActive();
    }

    public boolean isSuspended() {
        return this.mDomainContext.isSuspended();
    }

    public void deactivate() {
        this.mDomainContext.deactivate(true);
    }

    void deactivate(boolean disassociateWithThread) {
        this.mDomainContext.deactivate(disassociateWithThread);
    }

    public void activate() {
        try {
            this.mDomainContext.activate();
        }
        catch (ActivationException e) {
            DMSContextManager.getLogger().log(Level.WARNING, "DMS-57014", e);
        }
    }

    public static ExecutionContext activate(ExecutionContextComponents context) {
        ExecutionContext retVal = null;
        DomainContextManager dcm = DMSContextManager.getDomainContextManager();
        if (dcm != null) {
            try {
                Object dctx = dcm.activateContextComponents(context);
                retVal = dctx.getAsMutableExecutionContext();
            }
            catch (ActivationException e) {
                DMSContextManager.getLogger().log(Level.WARNING, "DMS-57014", e);
            }
        }
        return retVal;
    }

    public void setGlobalValue(String paramName, String value) {
        DomainContextManager dcm;
        if (paramName != null && (dcm = DMSContextManager.getDomainContextManager()) != null) {
            ContextParameterDescriptorInternal desc = dcm.findContextParameterDescriptor(paramName);
            if (desc != null) {
                if (desc.isValid()) {
                    this.mDomainContext.setValueAccordingToDescriptor(desc, value);
                }
            } else {
                dcm.isValueLegal(null, paramName, value);
                this.mDomainContext.setGlobalValue(paramName, value);
            }
        }
    }

    public void setLocalValue(String paramName, String value) {
        DomainContextManager dcm;
        if (paramName != null && (dcm = DMSContextManager.getDomainContextManager()) != null) {
            ContextParameterDescriptorInternal desc = dcm.findContextParameterDescriptor(paramName);
            if (desc != null) {
                if (desc.isValid()) {
                    this.mDomainContext.setValueAccordingToDescriptor(desc, value);
                }
            } else {
                dcm.isValueLegal(null, paramName, value);
                this.mDomainContext.setLocalValue(paramName, value);
            }
        }
    }

    public void setValue(String parameterName, String value) {
        this.setGlobalValue(parameterName, value);
    }

    public void setValue(ContextParameterDescriptor desc, String value) {
        if (desc != null) {
            ContextParameterDescriptorInternal descriptor = (ContextParameterDescriptorInternal)desc;
            DomainContextManager dcm = DMSContextManager.getDomainContextManager();
            if (dcm != null && descriptor.isValid()) {
                if (descriptor.getValueSet() != null && !descriptor.getValueSet().contains(value)) {
                    throw new IllegalArgumentException("Value '" + value + "' is not a legal value for context parameter " + descriptor.getName());
                }
                dcm.isValueLegal(descriptor, null, value);
                this.mDomainContext.setValueAccordingToDescriptor(descriptor, value);
            }
        }
    }

    public String getValue(ContextParameterDescriptor desc) {
        ContextParameterDescriptorInternal descriptor;
        String retVal = null;
        if (desc != null && (descriptor = (ContextParameterDescriptorInternal)desc).isValid()) {
            retVal = this.mDomainContext.getValueAccordingToDescriptor(descriptor, true);
        }
        return retVal;
    }

    @Deprecated
    public boolean isTraceTriggered() {
        return this.mDomainContext.isTraceTriggered();
    }

    public void setLogLevel(Level level) {
        this.mDomainContext.setLogLevel(level);
    }

    public Level getLogLevel() {
        return this.mDomainContext.getLogLevel();
    }

    @Deprecated
    public HashSet<String> getLogKeys() {
        Set<String> sourceSet = this.mDomainContext.getParameterNames(DomainContextManager.ParameterAttribute.LOGGABLE);
        HashSet<String> retVal = new HashSet<String>(sourceSet);
        return retVal;
    }

    public Set<String> getLogKeySet() {
        Set<String> sourceSet = this.mDomainContext.getParameterNames(DomainContextManager.ParameterAttribute.LOGGABLE);
        Set<String> retVal = Collections.unmodifiableSet(sourceSet);
        return retVal;
    }

    @Deprecated
    public Set<String> getPropagateKeys() {
        Set<String> modifiableSet = this.mDomainContext.getParameterNames(DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP);
        Set<String> retVal = Collections.unmodifiableSet(modifiableSet);
        return retVal;
    }

    public String getValue(String parameterName) {
        DomainContextManager dcm;
        String retVal = null;
        if (parameterName != null && (dcm = DMSContextManager.getDomainContextManager()) != null) {
            ContextParameterDescriptorInternal desc = dcm.findContextParameterDescriptor(parameterName);
            if (desc != null) {
                if (desc.isValid()) {
                    retVal = this.mDomainContext.getValueAccordingToDescriptor(desc, true);
                }
            } else {
                retVal = this.mDomainContext.getLocalValue(parameterName);
                if (retVal == null) {
                    retVal = this.mDomainContext.getGlobalValue(parameterName);
                }
            }
        }
        return retVal;
    }

    public String getGlobalValue(String parameterName) {
        DomainContextManager dcm;
        String retVal = null;
        if (parameterName != null && (dcm = DMSContextManager.getDomainContextManager()) != null) {
            ContextParameterDescriptorInternal desc = dcm.findContextParameterDescriptor(parameterName);
            if (desc != null) {
                if (desc.isValid()) {
                    retVal = this.mDomainContext.getValueAccordingToDescriptor(desc, true);
                }
            } else {
                retVal = this.mDomainContext.getGlobalValue(parameterName);
            }
        }
        return retVal;
    }

    public String getLocalValue(String parameterName) {
        DomainContextManager dcm;
        String retVal = null;
        if (parameterName != null && (dcm = DMSContextManager.getDomainContextManager()) != null) {
            ContextParameterDescriptorInternal desc = dcm.findContextParameterDescriptor(parameterName);
            if (desc != null) {
                if (desc.isValid()) {
                    retVal = this.mDomainContext.getValueAccordingToDescriptor(desc, true);
                }
            } else {
                retVal = this.mDomainContext.getLocalValue(parameterName);
            }
        }
        return retVal;
    }

    public Map<String, String> getAllValues() {
        return this.mDomainContext.getAllValues(true);
    }

    public void setContent(String key, ContextContent content) {
        this.mDomainContext.setContent(key, content);
    }

    public ContextContent getContent(String key) {
        return this.mDomainContext.getContent(key);
    }

    @Deprecated
    public String dump(int format) {
        return this.mDomainContext.getPrettyInstanceStateSummary(Level.FINE);
    }

    @Deprecated
    public void registerListener(ExecutionContextListener lsnr) {
        this.mDomainContext.registerListener(new ExecutionContextListener.ListenerAdapter(lsnr));
    }

    @Deprecated
    public void deregisterListener(ExecutionContextListener lsnr) {
        this.mDomainContext.deregisterListener(new ExecutionContextListener.ListenerAdapter(lsnr));
    }

    @Deprecated
    public void setUpdateSqlText(boolean set) {
        this.mDomainContext.setUpdateSqlText(set);
    }

    @Deprecated
    public boolean isRoot() {
        return this.mDomainContext.isRoot();
    }

    @Deprecated
    public void setURI(Object allegedHttpServletRequest) {
        if (allegedHttpServletRequest instanceof HttpServletRequest) {
            String uri;
            StringBuffer uriBuf;
            HttpServletRequest request = (HttpServletRequest)allegedHttpServletRequest;
            if (request != null && (uriBuf = request.getRequestURL()) != null && (uri = uriBuf.toString()) != null && !uri.trim().isEmpty()) {
                this.setValue(DMSCtxParamDescriptor.RequestURI, uriBuf.toString());
            }
        } else {
            throw new IllegalArgumentException("Argument must be an instance of javax.servlet.http.HttpServletRequest");
        }
    }

    public void applyValuesFromEncodedContextString(String s) {
        if (s != null) {
            WrappedContextDecoder wcd = DMSContextManager.getWrappedContextDecoder(s);
            ExecutionContextComponents ecc = wcd.getExecutionContextComponents();
            if (ecc.getGlobalMap() != null) {
                for (Map.Entry<String, String> entry : ecc.getGlobalMap().entrySet()) {
                    this.setGlobalValue(entry.getKey(), entry.getValue());
                }
            }
            if (ecc.getLocalMap() != null) {
                for (Map.Entry<String, String> entry : ecc.getLocalMap().entrySet()) {
                    this.setLocalValue(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Deprecated
    public String getPrettyInstanceStateSummary(Level level) {
        return this.mDomainContext.getPrettyInstanceStateSummary(level);
    }

    @Deprecated
    static String getPrettyClassStateSummary(Level level) {
        return "ExecutionContext Class";
    }
}

