/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.dfw.impl.incident.DumpAction;
import oracle.dfw.impl.incident.LogWrapper;
import oracle.dfw.impl.incident.Rule;
import oracle.dfw.impl.incident.RuleActions;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.InvalidRulesException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

class DiagnosticRules {
    private ArrayList<LogCondition> m_logConditions;
    private ArrayList<Rule> m_rules;
    private RuleActions m_defaultActions;
    private Exception m_errorParsing;
    private static DocumentBuilderFactory SCHEMA_FACTORY = DocumentBuilderFactory.newInstance();
    private static final String LOG_CONDITIONS = "logDetectionConditions";
    private static final String LOG_CONDITION = "condition";
    private static final String SCHEMA_FILE = "/oracle/dfw/incident/diagnostic_rules.xsd";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    private DiagnosticRules() throws InvalidRulesException {
        if (SCHEMA_FACTORY == null) {
            throw new InvalidRulesException("DFW-40106", SCHEMA_FILE);
        }
    }

    static DiagnosticRules createRules(Reader rules) throws InvalidRulesException {
        DiagnosticRules diagRules = new DiagnosticRules();
        try {
            diagRules.parseRules(rules);
        }
        catch (Exception e) {
            if (e instanceof InvalidRulesException) {
                throw (InvalidRulesException)e;
            }
            throw new InvalidRulesException("DFW-40107", e);
        }
        return diagRules;
    }

    private void parseRules(Reader rules) throws Exception {
        NodeList conditionsList;
        NodeList logConditions;
        NodeList procRules;
        this.m_errorParsing = null;
        final DocumentBuilder parser = SCHEMA_FACTORY.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
            }

            @Override
            public void error(SAXParseException exception) {
                DiagnosticRules.this.m_errorParsing = exception;
            }

            @Override
            public void fatalError(SAXParseException exception) {
                DiagnosticRules.this.m_errorParsing = exception;
            }
        });
        final InputSource source = new InputSource(rules);
        Document document = null;
        try {
            document = AccessController.doPrivileged(new PrivilegedExceptionAction<Document>(){

                @Override
                public Document run() throws Exception {
                    return parser.parse(source);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        if (this.m_errorParsing != null) {
            throw this.m_errorParsing;
        }
        if (document == null) {
            throw new InvalidRulesException("DFW-40108");
        }
        Element diagnosticRules = document.getDocumentElement();
        if (diagnosticRules == null) {
            throw new InvalidRulesException("DFW-40108");
        }
        NodeList defaultActionsList = diagnosticRules.getElementsByTagName("defaultActions");
        if (defaultActionsList != null && defaultActionsList.getLength() > 0) {
            Element defaultAction = (Element)defaultActionsList.item(0);
            this.m_defaultActions = new RuleActions();
            DiagnosticRules.updateRuleActions(defaultAction, this.m_defaultActions);
        }
        if ((procRules = diagnosticRules.getElementsByTagName("processingRules")) != null && procRules.getLength() > 0) {
            NodeList rulesList = ((Element)procRules.item(0)).getElementsByTagName("rule");
            int len = 0;
            if (rulesList != null && (len = rulesList.getLength()) > 0) {
                this.m_rules = new ArrayList();
                for (int i = 0; i < len; ++i) {
                    this.m_rules.add(new Rule((Element)rulesList.item(i)));
                }
            }
        }
        if ((logConditions = diagnosticRules.getElementsByTagName(LOG_CONDITIONS)) != null && logConditions.getLength() > 0 && (conditionsList = ((Element)logConditions.item(0)).getElementsByTagName(LOG_CONDITION)) != null && conditionsList.getLength() > 0) {
            int len = conditionsList.getLength();
            this.m_logConditions = new ArrayList();
            for (int i = 0; i < len; ++i) {
                Element conditionElement = (Element)conditionsList.item(i);
                this.m_logConditions.add(new LogCondition(conditionElement));
            }
        }
    }

    static void updateRuleActions(Element ruleActionNode, RuleActions actions) {
        NodeList dumpActionList = ruleActionNode.getElementsByTagName("dumpAction");
        if (dumpActionList != null && dumpActionList.getLength() > 0) {
            int len = dumpActionList.getLength();
            for (int i = 0; i < len; ++i) {
                Element dumpAction = (Element)dumpActionList.item(i);
                DumpAction dump = new DumpAction(dumpAction.getAttribute("name"), Boolean.valueOf(dumpAction.getAttribute("runSynchronously")));
                DiagnosticRules.updateDumpArguments(dumpAction.getElementsByTagName("argument"), dump);
                actions.addDumpAction(dump);
            }
        }
    }

    private static void updateDumpArguments(NodeList arguments, DumpAction dump) {
        int len = arguments.getLength();
        for (int i = 0; i < len; ++i) {
            Element arg = (Element)arguments.item(i);
            String name = arg.getAttribute("name");
            String value = arg.getAttribute("value");
            String type = arg.getAttribute("valueType");
            boolean required = Boolean.valueOf(arg.getAttribute("mandatory"));
            if (type == null || type.equalsIgnoreCase("Literal")) {
                dump.addLiteralBasedArgument(name, value);
                continue;
            }
            if (type.equalsIgnoreCase("Fact")) {
                dump.addFactBasedArgument(name, value, required);
                continue;
            }
            if (!type.equalsIgnoreCase("Context")) continue;
            dump.addContextBasedArgument(name, value, required);
        }
    }

    RuleActions getDefaultActions() {
        return this.m_defaultActions;
    }

    boolean evaluateLogConditions(LogWrapper log) {
        if (this.m_logConditions != null) {
            for (LogCondition condition : this.m_logConditions) {
                if (!condition.evaluate(log)) continue;
                return true;
            }
        }
        return false;
    }

    RuleActions evaluateRules(IncidentFacts facts) {
        if (this.m_rules == null) {
            return null;
        }
        RuleActions actions = new RuleActions();
        for (Rule rule : this.m_rules) {
            rule.evaluate(facts, actions);
        }
        return actions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_logConditions != null) {
            sb.append("Log Conditions:\n");
            for (LogCondition condition : this.m_logConditions) {
                sb.append("   - ");
                condition.describe(sb);
                sb.append("\n");
            }
            sb.append("\n");
        }
        if (this.m_rules != null) {
            sb.append("Rules:\n");
            for (Rule rule : this.m_rules) {
                sb.append("   - ");
                rule.describe(sb, "     ");
                sb.append("\n");
            }
            sb.append("\n");
        }
        if (this.m_defaultActions != null) {
            sb.append("Default Actions:\n");
            for (DumpAction action : this.m_defaultActions.getDumpActions()) {
                sb.append("   - Dump Action: ");
                sb.append(action.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    static {
        SCHEMA_FACTORY.setNamespaceAware(true);
        SCHEMA_FACTORY.setValidating(true);
        SCHEMA_FACTORY.setAttribute(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
        URL defaultSchema = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return DiagnosticRules.class.getResource(DiagnosticRules.SCHEMA_FILE);
            }
        });
        if (defaultSchema != null) {
            SCHEMA_FACTORY.setAttribute(JAXP_SCHEMA_SOURCE, defaultSchema.toString());
        } else {
            SCHEMA_FACTORY = null;
        }
    }

    private static class LogCondition {
        private int m_severity = -1;
        private String m_messageId;
        private String m_component;
        private String m_module;
        private static final String INCIDENT_ERROR_SEVERITY = "INCIDENT_ERROR";
        private static final String ERROR_SEVERITY = "ERROR";
        private static final String MESSAGE_SEVERITY = "messageSeverity";
        private static final String MESSAGE_ID = "messageId";
        private static final String MESSAGE_COMPONENT = "component";
        private static final String MESSAGE_MODULE = "module";

        LogCondition(Element conditionElement) {
            this.m_messageId = this.setNullIfEmpty(conditionElement.getAttribute(MESSAGE_ID));
            this.m_component = this.setNullIfEmpty(conditionElement.getAttribute(MESSAGE_COMPONENT));
            this.m_module = this.setNullIfEmpty(conditionElement.getAttribute(MESSAGE_MODULE));
            String severity = this.setNullIfEmpty(conditionElement.getAttribute(MESSAGE_SEVERITY));
            if (severity != null) {
                if (severity.equals(INCIDENT_ERROR_SEVERITY)) {
                    this.m_severity = ODLLevel.INCIDENT_ERROR.intValue();
                } else if (severity.equals(ERROR_SEVERITY)) {
                    this.m_severity = ODLLevel.ERROR.intValue();
                }
            }
        }

        private String setNullIfEmpty(String value) {
            if (value != null && value.length() == 0) {
                value = null;
            }
            return value;
        }

        boolean evaluate(LogWrapper log) {
            if (this.m_severity != -1 && this.m_severity != log.getLogRecord().getLevel().intValue()) {
                return false;
            }
            LogMessage msg = log.getLogMessage();
            if (this.m_messageId != null && !this.m_messageId.equals(msg.getMessageId())) {
                return false;
            }
            if (this.m_component != null && !this.m_component.equals(msg.getComponentId())) {
                return false;
            }
            return this.m_module == null || this.m_module.equals(msg.getModuleId());
        }

        public void describe(StringBuilder sb) {
            sb.append("Condition:");
            if (this.m_severity != -1) {
                sb.append(" ");
                sb.append(MESSAGE_SEVERITY);
                sb.append("=");
                sb.append(this.m_severity);
            }
            if (this.m_messageId != null) {
                sb.append(" ");
                sb.append(MESSAGE_ID);
                sb.append("=");
                sb.append(this.m_messageId);
            }
            if (this.m_component != null) {
                sb.append(" ");
                sb.append(MESSAGE_COMPONENT);
                sb.append("=");
                sb.append(this.m_component);
            }
            if (this.m_module != null) {
                sb.append(" ");
                sb.append(MESSAGE_MODULE);
                sb.append("=");
                sb.append(this.m_module);
            }
        }
    }
}

