/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.ReadableValueHolder;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.ContextResourceBundle;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportFactory;
import oracle.dms.was.WASUserValueHolder;
import oracle.dms.wls.WLSUserValueHolder;

public enum DMSCtxParamDescriptor implements ContextParameterDescriptorInternal
{
    RequestClassId("RCID", 128, false, 0, ContextParameterDescriptor.Scope.LOCAL_CONTEXT_FAMILY_PLUS_CHILDREN_AND_DB, null),
    FlowId("FlowId", 128, true, 0, ContextParameterDescriptor.Scope.LOCAL_CONTEXT_FAMILY_PLUS_CHILDREN_AND_DB, null),
    DBOperation("DBOP", 128, true, 0, ContextParameterDescriptor.Scope.SINGLE_CONTEXT_PLUS_DB, null),
    DiagnosticHttpSessionId("DSID", 128, false, 1, ContextParameterDescriptor.Scope.SINGLE_CONTEXT_ONLY, null),
    ServletURI("ServletURI", 128, false, 1, null, ServletURIValueHolder.class),
    ServletUsername("ServletUsername", 128, false, 1, null, ServletRemoteUserValueHolder.class),
    SubjectUsername("SubjectUsername", 128, false, 1, null, UserValueHolder.class),
    RequestURI("URI", 128, true, 0, ContextParameterDescriptor.Scope.SINGLE_CONTEXT_ONLY, null),
    DBAction("Action", 32, true, 0, ContextParameterDescriptor.Scope.SINGLE_CONTEXT_PLUS_DB, null),
    DBModule("Module", 48, true, 0, ContextParameterDescriptor.Scope.SINGLE_CONTEXT_PLUS_DB, null),
    DBClientId("client_identifier", 64, true, 0, ContextParameterDescriptor.Scope.LOCAL_CONTEXT_FAMILY_PLUS_DB, null);

    private final String mParamName;
    private final int mMaxLength;
    private final boolean mIsUpdateable;
    private final boolean mIsValid;
    private final int mECIDCardinality;
    private final ContextParameterDescriptor.Scope mScope;
    private final ContextParameterDescriptorInternal.DMSCtxValueHolder mValueHolder;
    private static final String DESCR_RESOURCE_PREFIX = "ctxParamDesc_";
    private static final String LABEL_RESOURCE_PREFIX = "ctxParamLabel_";
    private static Map<String, DMSCtxParamDescriptor> sNameToDescriptorMap;
    private static List<DMSCtxParamDescriptor> sParamsWithRemoteThreadSafeValueHolderList;
    private static List<DMSCtxParamDescriptor> sParamsWithValueHolderList;

    private DMSCtxParamDescriptor(String paramName, int maxLength, boolean isUpdateable, int ecidCardinatliy, ContextParameterDescriptor.Scope scope, Class<? extends ContextParameterDescriptorInternal.DMSCtxValueHolder> valueHolderClass) {
        this.mParamName = paramName;
        this.mMaxLength = maxLength;
        this.mIsUpdateable = isUpdateable;
        this.mECIDCardinality = ecidCardinatliy;
        this.mScope = valueHolderClass != null ? ContextParameterDescriptor.Scope.SINGLE_CONTEXT_ONLY : scope;
        boolean isValid = true;
        ContextParameterDescriptorInternal.DMSCtxValueHolder valueHolder = null;
        if (valueHolderClass != null) {
            isValid = false;
            try {
                valueHolder = valueHolderClass.newInstance();
                isValid = true;
            }
            catch (Exception e) {
                DMSContextManager.getLogger().log(Level.FINE, "Could not create value holder instance for " + paramName, e);
            }
        }
        this.mValueHolder = valueHolder;
        this.mIsValid = isValid;
    }

    @Override
    public String getName() {
        return this.mParamName;
    }

    @Override
    public String getLabel(Locale locale) {
        String retVal = null;
        try {
            ResourceBundle rb = ResourceBundle.getBundle(ContextResourceBundle.class.getName(), locale);
            retVal = rb.getString(LABEL_RESOURCE_PREFIX + this.mParamName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public String getDescription(Locale locale) {
        String retVal = null;
        try {
            ResourceBundle rb = ResourceBundle.getBundle(ContextResourceBundle.class.getName(), locale);
            retVal = rb.getString(DESCR_RESOURCE_PREFIX + this.mParamName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public int getMaxValueLength() {
        return this.mMaxLength;
    }

    @Override
    public boolean isUpdateable() {
        return this.mIsUpdateable;
    }

    @Override
    public int getECIDCardinality() {
        return this.mECIDCardinality;
    }

    @Override
    public ContextParameterDescriptor.Scope getScope() {
        return this.mScope;
    }

    @Override
    public Set<String> getValueSet() {
        return null;
    }

    @Override
    public int getValueSetSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isValid() {
        return this.mIsValid;
    }

    @Override
    public ContextParameterDescriptorInternal.DMSCtxValueHolder getValueHolder() {
        return this.mValueHolder;
    }

    @Override
    public String getValueDescription(String value, Locale l) {
        return null;
    }

    public static DMSCtxParamDescriptor findDescriptor(String parameterName) {
        DMSCtxParamDescriptor retVal = null;
        retVal = sNameToDescriptorMap.get(parameterName);
        return retVal;
    }

    public static Collection<DMSCtxParamDescriptor> getAllRemoteThreadSafeValueHolderDescriptors() {
        return sParamsWithRemoteThreadSafeValueHolderList;
    }

    public static Collection<DMSCtxParamDescriptor> getAllValueHolderDescriptors() {
        return sParamsWithValueHolderList;
    }

    static {
        HashMap<String, DMSCtxParamDescriptor> nameToDescriptorMap = new HashMap<String, DMSCtxParamDescriptor>(10);
        ArrayList<DMSCtxParamDescriptor> paramsWithThreadSafeValueHolderList = new ArrayList<DMSCtxParamDescriptor>(2);
        ArrayList<DMSCtxParamDescriptor> paramsWithValueHolderList = new ArrayList<DMSCtxParamDescriptor>(3);
        for (DMSCtxParamDescriptor d : DMSCtxParamDescriptor.values()) {
            nameToDescriptorMap.put(d.mParamName, d);
            if (d.getValueHolder() == null) continue;
            paramsWithValueHolderList.add(d);
            if (!d.getValueHolder().getClass().isAnnotationPresent(ContextParameterDescriptorInternal.RemoteThreadSafeValueHolder.class)) continue;
            paramsWithThreadSafeValueHolderList.add(d);
        }
        sNameToDescriptorMap = Collections.unmodifiableMap(nameToDescriptorMap);
        sParamsWithRemoteThreadSafeValueHolderList = Collections.unmodifiableList(paramsWithThreadSafeValueHolderList);
        sParamsWithValueHolderList = Collections.unmodifiableList(paramsWithValueHolderList);
    }

    static class UserValueHolder
    implements ContextParameterDescriptorInternal.DMSCtxValueHolder {
        private ReadableValueHolder<String> mInternalValueHolder = null;

        public UserValueHolder() {
            PlatformSupport platformSupport = PlatformSupportFactory.getPlatformSupport();
            Platform platform = platformSupport.getPlatform();
            try {
                switch (platform) {
                    case Default: {
                        break;
                    }
                    case WebLogic: 
                    case WebLogicAS: {
                        this.mInternalValueHolder = new WLSUserValueHolder();
                        break;
                    }
                    case WebSphere: 
                    case WebSphereAS: 
                    case WebSphereND: {
                        this.mInternalValueHolder = new WASUserValueHolder();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public String getValue(DomainExecutionContext ctx) {
            String retVal = null;
            if (this.mInternalValueHolder != null) {
                retVal = this.mInternalValueHolder.getValue();
            }
            return retVal;
        }
    }

    static class ServletRemoteUserValueHolder
    implements ContextParameterDescriptorInternal.DMSCtxValueHolder {
        public ServletRemoteUserValueHolder() throws Exception {
            Class.forName("javax.servlet.http.HttpServletRequest");
        }

        @Override
        public String getValue(DomainExecutionContext ctx) {
            String retVal = null;
            HttpServletRequest request = (HttpServletRequest)ctx.getCachedObject(DomainExecutionContext.ObjectCacheKey.HTTP_REQUEST);
            if (request != null) {
                retVal = request.getRemoteUser();
            }
            return retVal;
        }
    }

    @ContextParameterDescriptorInternal.RemoteThreadSafeValueHolder
    static class ServletURIValueHolder
    implements ContextParameterDescriptorInternal.DMSCtxValueHolder {
        public ServletURIValueHolder() throws Exception {
            Class.forName("javax.servlet.http.HttpServletRequest");
        }

        @Override
        public String getValue(DomainExecutionContext ctx) {
            String retVal = null;
            HttpServletRequest request = (HttpServletRequest)ctx.getCachedObject(DomainExecutionContext.ObjectCacheKey.HTTP_REQUEST);
            if (request != null) {
                retVal = request.getRequestURI();
            }
            return retVal;
        }
    }
}

