/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jmx;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class ContextParameterDescriptor {
    private String mName;
    private String mDescription;
    private Set<String> mValueSet;
    private Map<String, String> mValueDescriptionsMap;
    private static final ArrayType VALUE_SET_CT;
    private static final TabularType VALUE_DESCRIPTION_MAP_CT;
    private static final CompositeType VALUE_DESCRIPTION_TUPLE_CT;
    private static final OpenType[] VALUE_DESCRIPTION_TUPLE_CT_ITEM_TYPES;
    private static final String[] VALUE_DESCRIPTION_TUPLE_CT_ITEM_NAMES;
    private static final String[] VALUE_DESCRIPTION_TUPLE_CT_ITEM_DESCRIPTIONS;
    private static final CompositeType DESCRIPTOR_CT;
    private static final OpenType[] DESCRIPTOR_CT_ITEM_TYPES;
    private static final String[] DESCRIPTOR_CT_ITEM_NAMES;
    private static final String[] DESCRIPTOR_CT_ITEM_DESCRIPTIONS;

    @ConstructorProperties(value={"name", "description", "valueSet", "valueDescriptionsMap"})
    public ContextParameterDescriptor(String name, String description, Set<String> valueSet, Map<String, String> valueDescriptionsMap) {
        this.mName = name;
        this.mDescription = description;
        this.mValueSet = valueSet;
        this.mValueDescriptionsMap = valueDescriptionsMap;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public Map<String, String> getValueDescriptionsMap() {
        return this.mValueDescriptionsMap;
    }

    public Set<String> getValueSet() {
        Set<String> retVal = this.mValueSet;
        if (retVal == null && this.mValueDescriptionsMap != null) {
            retVal = this.mValueDescriptionsMap.keySet();
        }
        return retVal;
    }

    public static CompositeType toCompositeType() {
        return DESCRIPTOR_CT;
    }

    public CompositeData toCompositeData(CompositeType ct) {
        CompositeDataSupport retVal = null;
        if (DESCRIPTOR_CT != null) {
            try {
                HashMap<String, Object> allData = new HashMap<String, Object>();
                allData.put(DESCRIPTOR_CT_ITEM_NAMES[0], this.mName);
                allData.put(DESCRIPTOR_CT_ITEM_NAMES[1], this.mDescription);
                if (this.mValueSet == null) {
                    allData.put(DESCRIPTOR_CT_ITEM_NAMES[2], null);
                } else {
                    allData.put(DESCRIPTOR_CT_ITEM_NAMES[2], this.mValueSet.toArray(new String[this.mValueSet.size()]));
                }
                if (this.mValueDescriptionsMap == null) {
                    allData.put(DESCRIPTOR_CT_ITEM_NAMES[3], null);
                } else {
                    TabularDataSupport descriptionMapAsTD = new TabularDataSupport(VALUE_DESCRIPTION_MAP_CT, this.mValueDescriptionsMap.size(), 0.5f);
                    for (Map.Entry<String, String> entry : this.mValueDescriptionsMap.entrySet()) {
                        CompositeDataSupport entryAsCD = new CompositeDataSupport(VALUE_DESCRIPTION_TUPLE_CT, VALUE_DESCRIPTION_TUPLE_CT_ITEM_NAMES, new String[]{entry.getKey(), entry.getValue()});
                        descriptionMapAsTD.put(entryAsCD);
                    }
                    allData.put(DESCRIPTOR_CT_ITEM_NAMES[3], descriptionMapAsTD);
                }
                retVal = new CompositeDataSupport(DESCRIPTOR_CT, allData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public static ContextParameterDescriptor from(CompositeData cd) {
        TabularData value2descriptionMapAsTD;
        String name = (String)cd.get(DESCRIPTOR_CT_ITEM_NAMES[0]);
        String description = (String)cd.get(DESCRIPTOR_CT_ITEM_NAMES[1]);
        HashSet<String> valueNamesSet = new HashSet<String>();
        String[] valueNamesArray = (String[])cd.get(DESCRIPTOR_CT_ITEM_NAMES[2]);
        if (valueNamesArray != null) {
            for (String valueName : valueNamesArray) {
                valueNamesSet.add(valueName);
            }
        }
        HashMap<String, String> value2descriptionMap = new HashMap<String, String>((value2descriptionMapAsTD = (TabularData)cd.get(DESCRIPTOR_CT_ITEM_NAMES[3])) == null ? 1 : value2descriptionMapAsTD.size());
        if (value2descriptionMapAsTD != null) {
            for (CompositeData value2descriptionTupleAsCD : value2descriptionMapAsTD.values()) {
                String valueName = (String)value2descriptionTupleAsCD.get(VALUE_DESCRIPTION_TUPLE_CT_ITEM_NAMES[0]);
                String valueDescription = (String)value2descriptionTupleAsCD.get(VALUE_DESCRIPTION_TUPLE_CT_ITEM_NAMES[1]);
                value2descriptionMap.put(valueName, valueDescription);
            }
        }
        ContextParameterDescriptor retVal = new ContextParameterDescriptor(name, description, valueNamesSet, value2descriptionMap);
        return retVal;
    }

    static {
        VALUE_DESCRIPTION_TUPLE_CT_ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
        VALUE_DESCRIPTION_TUPLE_CT_ITEM_NAMES = new String[]{"contextParameterValue", "contextParameterValueDescription"};
        VALUE_DESCRIPTION_TUPLE_CT_ITEM_DESCRIPTIONS = new String[]{"One of the possible values of an execution context parameter.", "The description of the value."};
        DESCRIPTOR_CT_ITEM_NAMES = new String[]{"contextParameterName", "contextParameterDescription", "contextParameterValueSet", "contextParameterValueDescriptionsMap"};
        DESCRIPTOR_CT_ITEM_DESCRIPTIONS = new String[]{"The name of the execution context parameter.", "The description of the execution context parameter.", "The possible values of instances of the parameter (if known).", "Descriptions of the possible values of instances of the parameter (if known)."};
        CompositeType descriptorCT = null;
        ArrayType<String[]> valueSetCT = null;
        CompositeType valueDescriptionTupleCT = null;
        TabularType valueDescriptionMapCT = null;
        OpenType[] descriptorCTItemTypes = null;
        try {
            valueDescriptionTupleCT = new CompositeType("DMSContextParameterValueAndValueDescriptionTuple", "Tuple composed of one possible value of a DMSContextParameter and its description.", VALUE_DESCRIPTION_TUPLE_CT_ITEM_NAMES, VALUE_DESCRIPTION_TUPLE_CT_ITEM_DESCRIPTIONS, VALUE_DESCRIPTION_TUPLE_CT_ITEM_TYPES);
            valueDescriptionMapCT = new TabularType("DMSContextParameterValueToValueDescriptionMap", "The value set, if known, of a DMS ContextParameterDescriptor", valueDescriptionTupleCT, new String[]{VALUE_DESCRIPTION_TUPLE_CT_ITEM_NAMES[0]});
            valueSetCT = ArrayType.getArrayType(SimpleType.STRING);
            descriptorCTItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, valueSetCT, valueDescriptionMapCT};
            descriptorCT = new CompositeType("DMSContextParameterDescriptor", "Read-only metadata describing a DMS context parameter.", DESCRIPTOR_CT_ITEM_NAMES, DESCRIPTOR_CT_ITEM_DESCRIPTIONS, descriptorCTItemTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (valueDescriptionTupleCT != null && valueDescriptionMapCT != null && valueSetCT != null && descriptorCT != null) {
            DESCRIPTOR_CT = descriptorCT;
            DESCRIPTOR_CT_ITEM_TYPES = descriptorCTItemTypes;
            VALUE_SET_CT = valueSetCT;
            VALUE_DESCRIPTION_TUPLE_CT = valueDescriptionTupleCT;
            VALUE_DESCRIPTION_MAP_CT = valueDescriptionMapCT;
        } else {
            DESCRIPTOR_CT = null;
            DESCRIPTOR_CT_ITEM_TYPES = null;
            VALUE_SET_CT = null;
            VALUE_DESCRIPTION_TUPLE_CT = null;
            VALUE_DESCRIPTION_MAP_CT = null;
        }
    }
}

