/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.common;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class AccessCheck {
    AccessCheck() {
    }

    static boolean exists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    static boolean mkdirs(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.mkdirs();
            }
        });
    }

    static String getAbsolutePath(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return file.getAbsolutePath();
            }
        });
    }

    static File createTempFile(final String prefix, final String suffix, final File directory) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    return File.createTempFile(prefix, suffix, directory);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    static boolean createNewFile(final File file) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException {
                    return file.createNewFile();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    static File[] listFiles(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles();
            }
        });
    }

    static File[] listFiles(final File file, final FileFilter filter) {
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles(filter);
            }
        });
    }

    static boolean isDirectory(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory();
            }
        });
    }

    static boolean delete(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.delete();
            }
        });
    }

    static void deleteOnExit(final File file) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                file.deleteOnExit();
                return null;
            }
        });
    }

    static boolean renameTo(final File file, final File toFile) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.renameTo(toFile);
            }
        });
    }

    static FileWriter createFileWriter(final File file) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileWriter>(){

                @Override
                public FileWriter run() throws IOException {
                    return new FileWriter(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    static FileReader createFileReader(final File file) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileReader>(){

                @Override
                public FileReader run() throws IOException {
                    return new FileReader(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    static long lastModified(final File file) throws IOException {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.lastModified();
            }
        });
    }

    static long length(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.length();
            }
        });
    }
}

