/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.sampling;

import java.util.Map;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.config.DumpSampleInfo;
import oracle.dfw.sampling.DumpSampling;

public class DumpSamplingEventListener
implements DiagnosticsListener {
    DumpSamplingEventListener() {
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        DiagnosticsConfiguration config;
        if (event instanceof DiagnosticsConfigurationChangedEvent && (config = ((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration()) != null) {
            boolean currentState = DumpSampling.isEnabled();
            if (currentState && !config.isDumpSamplingEnabled()) {
                DumpSampling.removeAllInstances();
                DumpSampling.setEnable(false);
            } else if (!currentState && config.isDumpSamplingEnabled()) {
                DumpSampling.recreateAllInstances(config);
                DumpSampling.setEnable(true);
            } else if (currentState) {
                Map<String, DumpSampleInfo> updateMap = config.getDumpSamples();
                for (Map.Entry<String, DumpSampleInfo> e : updateMap.entrySet()) {
                    if (DumpSampling.contains(e.getKey())) continue;
                    DumpSampling.createInstance(e.getValue());
                }
                for (String name : DumpSampling.getNameSet()) {
                    if (updateMap.containsKey(name)) continue;
                    DumpSampling.removeInstance(name);
                }
            }
            DumpSampling.setIdleWhenHealthy(config.isDumpSamplingIdleWhenHealthy());
            DumpSampling.setMinmumHealthyPeriod(config.getDumpSamplingMinimumHealthyPeriodInMillis());
        }
    }
}

