/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.config;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import oracle.dms.config.Config;
import oracle.dms.config.ConfigChangeListener;
import oracle.dms.config.ConfigChild;
import oracle.dms.config.DMSConfigurationException;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;
import oracle.dms.util.XmlUtil;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectorConfig
implements ConfigChild {
    private TreeMap<Integer, Integer> m_prefetch = new TreeMap();
    private int m_discoverIntervalSeconds = 180;
    private int m_cacheMaxSizeMBytes = Integer.MAX_VALUE;
    private TreeMap<Integer, Set<String>> m_archiving = new TreeMap();
    HashMap<ObjectName, Set<String>> m_excludeAttributeMap = new HashMap();
    HashSet<String> m_excludeJavaProperties = new HashSet();
    private int m_defaultIntervalSeconds = Integer.MAX_VALUE;
    private boolean m_isMBeanRegListenerEnabled = true;
    private boolean m_isRuntime;
    private boolean m_updatedConfig;
    private File m_metricRepositoryDir = null;
    private int m_timeoutSeconds = 180;
    private int m_maxQueueSizePerServer = 4;
    private Set<ConfigChangeListener> m_listeners = Collections.synchronizedSet(new LinkedHashSet());
    private volatile boolean m_shutdown = false;
    private static final String ARCHIVE = "archive";
    private static final String ATTRIBUTE = "attribute";
    private static final String CACHE = "cache";
    private static final String COLLECTOR_CONFIGURATION = "collectorConfiguration";
    private static final String DISCOVER = "discover";
    private static final String EXCLUDE_JAVA_PROPERTY = "excludeJavaSystemProperty";
    private static final String EXCLUDE_MBEAN_ATTRIBUTE = "excludeMBeanAtrribute";
    private static final String IS_DEFAULT = "isDefault";
    private static final String MAXSIZE_PER_SERVER = "maxSizePerServer";
    private static final String MBEAN_REG_LISTENER = "mbeanRegistrationListener";
    private static final String NAME = "name";
    private static final String OBJECT_NAME = "objectName";
    private static final String PREFETCH = "prefetch";
    private static final String QUEUE = "queue";
    private static final String REMOVE_CYCLE = "removeCycle";
    private static final String TABLE = "table";
    private static final String TIMEOUT_SECONDS = "timeoutSeconds";
    private static final int DEFAULT_DISCOVERY = 180;
    private static final int DEFAULT_TIMEOUT = 180;
    private static final int DEFAULT_MAX_QUEUE = 4;
    private static final String CLASS_NAME = CollectorConfig.class.getName();
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");

    public boolean isShutdown() {
        return this.m_shutdown;
    }

    public synchronized void shutdown() {
        if (this.m_shutdown) {
            return;
        }
        this.m_shutdown = true;
        this.m_listeners.clear();
        this.m_prefetch.clear();
        for (Set<String> set : this.m_archiving.values()) {
            set.clear();
        }
        this.m_archiving.clear();
        for (Set<String> set : this.m_excludeAttributeMap.values()) {
            set.clear();
        }
        this.m_excludeAttributeMap.clear();
        this.m_excludeJavaProperties.clear();
    }

    public void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        if (this.m_shutdown) {
            return;
        }
        if (configChangeListener != null) {
            this.m_listeners.add(configChangeListener);
        }
    }

    public void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        if (configChangeListener != null) {
            this.m_listeners.remove(configChangeListener);
        }
    }

    public void setMetricRepositoryDirectory(File metricRepositoryDir) {
        if (metricRepositoryDir == null) {
            throw new IllegalArgumentException("metricRepositoryDir=null");
        }
        this.m_metricRepositoryDir = metricRepositoryDir;
        this.m_updatedConfig = true;
    }

    public File getMetricRepositoryDirectory() {
        return this.m_metricRepositoryDir;
    }

    public synchronized SortedMap<Integer, Integer> getPrefetch() {
        return (SortedMap)this.m_prefetch.clone();
    }

    public synchronized void addPrefetch(int interval, int removalCycle) {
        if (interval < 1 || removalCycle < 1) {
            return;
        }
        this.m_prefetch.put(interval, removalCycle);
    }

    public synchronized int getDefaultPrefetchIntervalSeconds() {
        if (this.m_prefetch.size() > 0) {
            if (this.m_prefetch.containsKey(this.m_defaultIntervalSeconds)) {
                return this.m_defaultIntervalSeconds;
            }
            return this.m_prefetch.keySet().iterator().next();
        }
        return this.m_defaultIntervalSeconds;
    }

    public synchronized boolean setDefaultPrefetchIntervalSeconds(int defaultIntervalSeconds) {
        if (!this.m_prefetch.containsKey(defaultIntervalSeconds)) {
            return false;
        }
        this.m_defaultIntervalSeconds = defaultIntervalSeconds;
        this.m_updatedConfig = true;
        return true;
    }

    public synchronized int getDiscoverIntervalSeconds() {
        return this.m_discoverIntervalSeconds;
    }

    public synchronized void setDiscoverIntervalSeconds(int discoverIntervalSeconds) {
        if (discoverIntervalSeconds < 1) {
            return;
        }
        this.m_discoverIntervalSeconds = discoverIntervalSeconds;
        this.m_updatedConfig = true;
    }

    public synchronized int getTimeoutSeconds() {
        return this.m_timeoutSeconds;
    }

    public synchronized void setTimeoutSeconds(int timeoutSeconds) {
        if (timeoutSeconds < 1) {
            return;
        }
        this.m_timeoutSeconds = timeoutSeconds;
        this.m_updatedConfig = true;
    }

    public synchronized int getMaxQueueSizePerServer() {
        return this.m_maxQueueSizePerServer;
    }

    public synchronized void setMaxQueueSizePerServer(int maxQueueSizePerServer) {
        if (maxQueueSizePerServer < 1) {
            return;
        }
        this.m_maxQueueSizePerServer = maxQueueSizePerServer;
        this.m_updatedConfig = true;
    }

    public synchronized int getCacheMaxSizeMBytes() {
        return this.m_cacheMaxSizeMBytes;
    }

    public synchronized void setCacheMaxSizeMBytes(int cacheMaxSizeMBytes) {
        if (cacheMaxSizeMBytes < 1) {
            return;
        }
        this.m_cacheMaxSizeMBytes = cacheMaxSizeMBytes;
        this.m_updatedConfig = true;
    }

    public synchronized void addArchivedTables(int interval, Collection<String> tables) {
        if (tables == null || tables.size() == 0 || interval < 1) {
            return;
        }
        Set<String> tableSet = this.m_archiving.get(interval);
        if (tableSet == null) {
            tableSet = new HashSet<String>();
            this.m_archiving.put(interval, tableSet);
        }
        for (String table : tables) {
            if (table == null || table.trim().length() == 0) continue;
            tableSet.add(table);
        }
    }

    public synchronized void removeArchivedTables(int interval, Collection<String> tables) {
        if (tables == null || tables.size() == 0 || interval < 1) {
            return;
        }
        Set<String> tableSet = this.m_archiving.get(interval);
        if (tableSet != null) {
            tableSet.removeAll(tables);
        }
    }

    public synchronized String[] getArchivedTables(int interval) {
        Set<String> tableSet = this.m_archiving.get(interval);
        if (tableSet == null) {
            return null;
        }
        String[] ret = new String[tableSet.size()];
        tableSet.toArray(ret);
        return ret;
    }

    public synchronized int[] getArchivingIntervals() {
        Set<Integer> intervals = this.m_archiving.keySet();
        int[] ret = new int[intervals.size()];
        int i = 0;
        for (Integer interval : intervals) {
            ret[i++] = interval;
        }
        return ret;
    }

    public synchronized Map<ObjectName, Set<String>> getExcludeAttributeMap() {
        return (Map)this.m_excludeAttributeMap.clone();
    }

    public synchronized Set<String> getExcludeJavaProperties() {
        return (Set)this.m_excludeJavaProperties.clone();
    }

    public boolean isMBeanRegListenerEnabled() {
        return this.m_isMBeanRegListenerEnabled;
    }

    public void setMBeanRegListenerEnabled(boolean isMBeanRegListenerEnabled) {
        this.m_isMBeanRegListenerEnabled = isMBeanRegListenerEnabled;
        this.m_updatedConfig = true;
    }

    @Override
    public synchronized void parseConfigDocument(Element xdms) throws DMSConfigurationException {
        if (xdms == null) {
            throw new IllegalArgumentException("xdms=null");
        }
        if (this.m_shutdown) {
            return;
        }
        try {
            this._getPrefetch(xdms);
            this._getDiscover(xdms);
            this._getQueue(xdms);
            this._getCacheMaxSize(xdms);
            this._getArchivedTables(xdms);
            this._getMBeanRegistrationListener(xdms);
            this._getExcludedMBeanAttribute(xdms);
            this._getExcludedJavaProperty(xdms);
        }
        catch (NumberFormatException e) {
            String mesg = DMSUtil.errorMessage("50727", new Object[0]);
            throw new DMSConfigurationException(mesg, e);
        }
    }

    private void _getPrefetch(Element metricConfig) throws NumberFormatException {
        String METHOD_NAME = "_getPrefetch";
        NodeList prefetchList = metricConfig.getElementsByTagName(PREFETCH);
        int length = prefetchList == null ? 0 : prefetchList.getLength();
        boolean hasDefaultInterval = false;
        int defaultInterval = Integer.MAX_VALUE;
        TreeMap<Integer, Integer> prefetchMap = new TreeMap<Integer, Integer>();
        for (int i = length - 1; i >= 0; --i) {
            Node child = prefetchList.item(i);
            if (!(child instanceof Element)) continue;
            Element prefetch = (Element)child;
            int interval = XmlUtil.getAttributeInt(prefetch, "intervalSeconds");
            if (interval < 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.logp(Level.INFO, this.getClass().getName(), "_getPrefetch", "DMS-50955", Integer.toString(interval));
                continue;
            }
            int removeCycle = XmlUtil.getAttributeInt(prefetch, REMOVE_CYCLE);
            if (removeCycle < 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.logp(Level.INFO, this.getClass().getName(), "_getPrefetch", "DMS-50956", Integer.toString(removeCycle));
                continue;
            }
            prefetchMap.put(interval, removeCycle);
            boolean isDefault = XmlUtil.getAttributeBoolean(prefetch, IS_DEFAULT);
            if (!isDefault) continue;
            hasDefaultInterval = true;
            if (interval >= defaultInterval) continue;
            defaultInterval = interval;
        }
        this.m_prefetch = prefetchMap;
        this.m_defaultIntervalSeconds = !hasDefaultInterval && prefetchMap.size() > 0 ? (Integer)prefetchMap.keySet().iterator().next() : defaultInterval;
    }

    private void _getDiscover(Element metricConfig) throws NumberFormatException {
        String METHOD_NAME = "_getDiscover";
        NodeList discoverList = metricConfig.getElementsByTagName(DISCOVER);
        int length = discoverList == null ? 0 : discoverList.getLength();
        int discoverInterval = 180;
        for (int i = length - 1; i >= 0; --i) {
            Node child = discoverList.item(i);
            if (!(child instanceof Element)) continue;
            Element discover = (Element)child;
            int interval = XmlUtil.getAttributeInt(discover, "intervalSeconds");
            if (interval < 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.logp(Level.INFO, this.getClass().getName(), "_getDiscover", "DMS-50955", Integer.toString(interval));
                continue;
            }
            discoverInterval = interval;
            break;
        }
        this.m_discoverIntervalSeconds = discoverInterval;
    }

    private void _getQueue(Element metricConfig) throws NumberFormatException {
        String METHOD_NAME = "_getQueue";
        NodeList queueList = metricConfig.getElementsByTagName(QUEUE);
        int length = queueList == null ? 0 : queueList.getLength();
        int timeoutSeconds = 180;
        int maxQueueSizePerServer = 4;
        for (int i = length - 1; i >= 0; --i) {
            Node child = queueList.item(i);
            if (!(child instanceof Element)) continue;
            Element queue = (Element)child;
            int timeout = XmlUtil.getAttributeInt(queue, TIMEOUT_SECONDS);
            if (timeout < 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.logp(Level.INFO, this.getClass().getName(), "_getQueue", "DMS-50958", Integer.toString(timeout));
                continue;
            }
            timeoutSeconds = timeout;
            int maxSize = XmlUtil.getAttributeInt(queue, MAXSIZE_PER_SERVER);
            if (maxSize < 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.logp(Level.INFO, this.getClass().getName(), "_getQueue", "DMS-50959", Integer.toString(maxSize));
                continue;
            }
            maxQueueSizePerServer = maxSize;
            break;
        }
        this.m_timeoutSeconds = timeoutSeconds;
        this.m_maxQueueSizePerServer = maxQueueSizePerServer;
    }

    private void _getCacheMaxSize(Element metricConfig) throws NumberFormatException {
        String METHOD_NAME = "_getCacheMaxSize";
        NodeList cacheSizeList = metricConfig.getElementsByTagName(CACHE);
        int length = cacheSizeList == null ? 0 : cacheSizeList.getLength();
        int cacheMaxSize = Integer.MAX_VALUE;
        for (int i = length - 1; i >= 0; --i) {
            Node child = cacheSizeList.item(i);
            if (!(child instanceof Element)) continue;
            Element cacheSize = (Element)child;
            int maxSizeMByte = XmlUtil.getAttributeInt(cacheSize, "maxSizeMBytes");
            if (maxSizeMByte < 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.logp(Level.INFO, this.getClass().getName(), "_getCacheMaxSize", "DMS-50954", Integer.toString(maxSizeMByte));
                continue;
            }
            cacheMaxSize = maxSizeMByte;
            break;
        }
        this.m_cacheMaxSizeMBytes = cacheMaxSize;
    }

    private void _getArchivedTables(Element metricConfig) throws NumberFormatException {
        String METHOD_NAME = "_getArchivedTables";
        NodeList archiveList = metricConfig.getElementsByTagName(ARCHIVE);
        int length = archiveList == null ? 0 : archiveList.getLength();
        TreeMap archiving = new TreeMap();
        for (int i = length - 1; i >= 0; --i) {
            Node child = archiveList.item(i);
            if (!(child instanceof Element)) continue;
            Element archive = (Element)child;
            int interval = XmlUtil.getAttributeInt(archive, "intervalSeconds");
            if (interval < 1) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.logp(Level.INFO, this.getClass().getName(), "_getArchivedTables", "DMS-50955", Integer.toString(interval));
                continue;
            }
            NodeList tableList = archive.getElementsByTagName(TABLE);
            if (tableList == null || tableList.getLength() == 0) continue;
            HashSet<String> tableSet = new HashSet<String>();
            for (int j = tableList.getLength() - 1; j >= 0; --j) {
                Element table;
                String name;
                Node gchild = tableList.item(j);
                if (!(gchild instanceof Element) || (name = (table = (Element)gchild).getAttribute(NAME)) == null || name.trim().length() <= 0) continue;
                tableSet.add(name);
            }
            if (tableSet.size() <= 0) continue;
            archiving.put(interval, tableSet);
        }
        this.m_archiving = archiving;
    }

    private void _getMBeanRegistrationListener(Element metricConfig) {
        NodeList mbeanRegListenerList = metricConfig.getElementsByTagName(MBEAN_REG_LISTENER);
        int length = mbeanRegListenerList == null ? 0 : mbeanRegListenerList.getLength();
        for (int i = length - 1; i >= 0; --i) {
            Node child = mbeanRegListenerList.item(i);
            if (!(child instanceof Element)) continue;
            Element mbeanRegListener = (Element)child;
            this.m_isMBeanRegListenerEnabled = XmlUtil.getAttributeBoolean(mbeanRegListener, "enabled");
            break;
        }
    }

    private void _getExcludedMBeanAttribute(Element metricConfig) {
        NodeList excludeAttributeList = metricConfig.getElementsByTagName(EXCLUDE_MBEAN_ATTRIBUTE);
        int length = excludeAttributeList == null ? 0 : excludeAttributeList.getLength();
        HashMap excludeAttributeMap = new HashMap();
        for (int i = length - 1; i >= 0; --i) {
            Set storedAttributeSet;
            String objNameString;
            Element excludeAttribute;
            NodeList attributeList;
            Node child = excludeAttributeList.item(i);
            if (!(child instanceof Element) || (attributeList = (excludeAttribute = (Element)child).getElementsByTagName(ATTRIBUTE)) == null || attributeList.getLength() == 0) continue;
            HashSet<String> attributeSet = new HashSet<String>();
            for (int j = attributeList.getLength() - 1; j >= 0; --j) {
                Element attribute;
                String name;
                Node achild = attributeList.item(j);
                if (!(achild instanceof Element) || (name = (attribute = (Element)achild).getAttribute(NAME)) == null || name.trim().length() <= 0) continue;
                attributeSet.add(name);
            }
            if (attributeSet.size() == 0) continue;
            Element objectName = XmlUtil.getChildByName(excludeAttribute, OBJECT_NAME);
            ObjectName objName = null;
            if (objectName != null && (objNameString = XmlUtil.getText(objectName)) != null && objNameString.length() > 0) {
                try {
                    objName = new ObjectName(objNameString);
                }
                catch (MalformedObjectNameException e) {
                    objName = ObjectName.WILDCARD;
                }
            }
            if (objName == null) {
                objName = ObjectName.WILDCARD;
            }
            if ((storedAttributeSet = (Set)excludeAttributeMap.get(objName)) == null) {
                excludeAttributeMap.put(objName, attributeSet);
                continue;
            }
            storedAttributeSet.addAll(attributeSet);
        }
        this.m_excludeAttributeMap = excludeAttributeMap;
    }

    private void _getExcludedJavaProperty(Element metricConfig) {
        NodeList excludePropertyList = metricConfig.getElementsByTagName(EXCLUDE_JAVA_PROPERTY);
        HashSet<String> excludeJavaPropertySet = new HashSet<String>();
        int length = excludePropertyList == null ? 0 : excludePropertyList.getLength();
        for (int i = length - 1; i >= 0; --i) {
            Element excludeProperty;
            String name;
            Node child = excludePropertyList.item(i);
            if (!(child instanceof Element) || (name = (excludeProperty = (Element)child).getAttribute(NAME)) == null || name.trim().length() <= 0) continue;
            excludeJavaPropertySet.add(name);
        }
        this.m_excludeJavaProperties = excludeJavaPropertySet;
    }

    @Override
    public synchronized Element buildElement(Document document) throws DMSConfigurationException {
        Element xcollector = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", COLLECTOR_CONFIGURATION);
        this._buildPrefetchElement(document, xcollector);
        Element xdiscover = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", DISCOVER);
        xdiscover.setAttribute("intervalSeconds", Integer.toString(this.m_discoverIntervalSeconds));
        xcollector.appendChild(xdiscover);
        Element xqueue = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", QUEUE);
        xqueue.setAttribute(TIMEOUT_SECONDS, Integer.toString(this.m_timeoutSeconds));
        xqueue.setAttribute(MAXSIZE_PER_SERVER, Integer.toString(this.m_maxQueueSizePerServer));
        xcollector.appendChild(xqueue);
        if (this.m_cacheMaxSizeMBytes < Integer.MAX_VALUE) {
            Element xcache = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", CACHE);
            xcache.setAttribute("maxSizeMBytes", Integer.toString(this.m_cacheMaxSizeMBytes));
            xcollector.appendChild(xcache);
        }
        this._buildArchiveElement(document, xcollector);
        this._buildMBeanRegListenerElement(document, xcollector);
        this._buildExcludeAttributeElement(document, xcollector);
        this._buildExcludeJavaPropertyElement(document, xcollector);
        return xcollector;
    }

    private void _buildPrefetchElement(Document document, Element xcollector) {
        if (this.m_prefetch.size() == 0) {
            return;
        }
        for (Map.Entry<Integer, Integer> entry : this.m_prefetch.entrySet()) {
            Integer interval = entry.getKey();
            Integer removeCycle = entry.getValue();
            Element xprefetch = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", PREFETCH);
            xprefetch.setAttribute("intervalSeconds", Integer.toString(interval));
            xprefetch.setAttribute(REMOVE_CYCLE, Integer.toString(removeCycle));
            if (this.m_defaultIntervalSeconds == interval) {
                xprefetch.setAttribute(IS_DEFAULT, "true");
            }
            xcollector.appendChild(xprefetch);
        }
    }

    private void _buildArchiveElement(Document document, Element xcollector) {
        if (this.m_archiving.size() == 0) {
            return;
        }
        for (Map.Entry<Integer, Set<String>> entry : this.m_archiving.entrySet()) {
            Integer interval = entry.getKey();
            Set<String> tables = entry.getValue();
            if (tables == null || tables.size() == 0) continue;
            Element xarchive = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", ARCHIVE);
            xarchive.setAttribute("intervalSeconds", Integer.toString(interval));
            for (String table : tables) {
                Element xtable = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", TABLE);
                xtable.setAttribute(NAME, table);
                xarchive.appendChild(xtable);
            }
            xcollector.appendChild(xarchive);
        }
    }

    private void _buildExcludeAttributeElement(Document document, Element xcollector) {
        if (this.m_excludeAttributeMap.size() == 0) {
            return;
        }
        for (Map.Entry<ObjectName, Set<String>> entry : this.m_excludeAttributeMap.entrySet()) {
            ObjectName objectName = entry.getKey();
            Set<String> attributes = entry.getValue();
            if (attributes == null || attributes.size() == 0) continue;
            Element xexcludeAttribute = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", EXCLUDE_MBEAN_ATTRIBUTE);
            Element xobjName = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", OBJECT_NAME);
            CDATASection cdobjName = document.createCDATASection(objectName.toString());
            xobjName.appendChild(cdobjName);
            xexcludeAttribute.appendChild(xobjName);
            for (String attribute : attributes) {
                Element xattribute = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", ATTRIBUTE);
                xattribute.setAttribute(NAME, attribute);
                xexcludeAttribute.appendChild(xattribute);
            }
            xcollector.appendChild(xexcludeAttribute);
        }
    }

    private void _buildExcludeJavaPropertyElement(Document document, Element xcollector) {
        if (this.m_excludeJavaProperties.size() == 0) {
            return;
        }
        for (String excludeProperty : this.m_excludeJavaProperties) {
            Element xexcludeProperty = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", EXCLUDE_JAVA_PROPERTY);
            xexcludeProperty.setAttribute(NAME, excludeProperty);
            xcollector.appendChild(xexcludeProperty);
        }
    }

    private void _buildMBeanRegListenerElement(Document document, Element xcollector) {
        if (this.m_isMBeanRegListenerEnabled) {
            return;
        }
        Element xmbeanRegListener = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", MBEAN_REG_LISTENER);
        xmbeanRegListener.setAttribute("enabled", Boolean.toString(this.m_isMBeanRegListenerEnabled));
        xcollector.appendChild(xmbeanRegListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateConfiguration() {
        if (this.m_shutdown || this.m_listeners.size() == 0) {
            return;
        }
        LinkedHashSet<ConfigChangeListener> listeners = new LinkedHashSet<ConfigChangeListener>();
        Set<ConfigChangeListener> set = this.m_listeners;
        synchronized (set) {
            listeners.addAll(this.m_listeners);
        }
        for (ConfigChangeListener listener : listeners) {
            listener.configChanged();
        }
    }

    public void setRuntime(boolean isRuntime) {
        this.m_isRuntime = isRuntime;
    }

    @Override
    public synchronized void sync(Config pendingConfig) throws DMSConfigurationException {
        if (!this.m_isRuntime) {
            this.syncConfig(pendingConfig.getCollectorConfig());
        }
    }

    private synchronized void syncConfig(CollectorConfig updatedConfig) throws EventConfigException {
        String METHOD_NAME = "syncConfig";
        if (LOGGER.isLoggable(Level.FINER)) {
            String msg = "START sync:" + Time.currentTimeMillis();
            LOGGER.logp(Level.FINER, CLASS_NAME, "syncConfig", msg);
        }
        this.m_prefetch = updatedConfig.m_prefetch;
        this.m_discoverIntervalSeconds = updatedConfig.m_discoverIntervalSeconds;
        this.m_maxQueueSizePerServer = updatedConfig.m_maxQueueSizePerServer;
        this.m_timeoutSeconds = updatedConfig.m_timeoutSeconds;
        this.m_cacheMaxSizeMBytes = updatedConfig.m_cacheMaxSizeMBytes;
        this.m_archiving = updatedConfig.m_archiving;
        this.m_defaultIntervalSeconds = updatedConfig.m_defaultIntervalSeconds;
        this.m_metricRepositoryDir = updatedConfig.m_metricRepositoryDir;
        this.m_isMBeanRegListenerEnabled = updatedConfig.m_isMBeanRegListenerEnabled;
    }

    @Override
    public boolean isConfigurationUpdated() {
        return this.m_updatedConfig;
    }

    @Override
    public void setConfigurationUpdated(boolean updated) {
        this.m_updatedConfig = updated;
    }
}

