/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.Map;
import oracle.dms.instrument.ExecutionContext;

@Deprecated
public class ExecutionContextForJDBC {
    public static final int ACTION_INDEX = 0;
    public static final int CLIENTID_INDEX = 1;
    public static final int ECID_INDEX = 2;
    public static final int MODULE_INDEX = 3;
    public static final int STATE_INDEX_MAX = 4;
    private static final int[] s_limits = new int[4];
    private String[] m_cached = null;
    private boolean m_statsSet = false;

    public static String[] getExecutionContextState() {
        String[] retval = null;
        try {
            ExecutionContext ctx = ExecutionContext.get();
            ExecutionContextForJDBC jdbcCtx = ctx.getJdbcCtx();
            if (jdbcCtx != null) {
                retval = jdbcCtx.getExecutionContextState(ctx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private String[] getExecutionContextState(ExecutionContext ctx) {
        if (this.m_cached == null && this.m_statsSet) {
            Map map = ctx.getAttributeMap();
            String ActionStr = (String)map.get("Action");
            String ClientIDStr = (String)map.get("ClientID");
            String UIDStr = (String)map.get("ECID_UID");
            String ModuleStr = (String)map.get("Module");
            this.m_cached = new String[4];
            this.setValue(ActionStr, 0);
            this.setValue(ClientIDStr, 1);
            this.setValue(UIDStr, 2);
            this.setValue(ModuleStr, 3);
        }
        return this.m_cached;
    }

    private void setValue(String value, int idx) {
        if (this.m_cached != null) {
            this.m_cached[idx] = value == null || value.length() <= s_limits[idx] ? value : value.substring(0, s_limits[idx] - 1);
        }
    }

    public static int getECIDSequenceNumber() {
        int retval = 0;
        try {
            ExecutionContext ctx = ExecutionContext.get();
            retval = ctx.getECIDSequenceNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static int getLimit(int idx) {
        if (idx < 0 || idx >= 4) {
            return -1;
        }
        return s_limits[idx];
    }

    void invalidate() {
        this.m_cached = null;
    }

    static {
        ExecutionContextForJDBC.s_limits[0] = 32;
        ExecutionContextForJDBC.s_limits[1] = 64;
        ExecutionContextForJDBC.s_limits[2] = 64;
        ExecutionContextForJDBC.s_limits[3] = 48;
    }
}

