/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.exception;

import java.util.List;
import java.util.Locale;
import oracle.as.management.exception.ASExceptionHelper;

public abstract class ASRuntimeException
extends RuntimeException {
    private ASExceptionHelper m_helper = null;
    private static final long serialVersionUID = -1179256512714L;

    protected ASRuntimeException(String messageID, Throwable cause, String resourceLocation) {
        this(messageID, cause, resourceLocation, null);
    }

    protected ASRuntimeException(String messageID, Throwable cause, String resourceLocation, String ... tokens) {
        super(messageID);
        if (messageID == null || messageID.trim().length() == 0 || resourceLocation == null || resourceLocation.length() == 0) {
            throw new IllegalArgumentException("messageID=" + messageID + " resourceLocation=" + resourceLocation);
        }
        this.m_helper = new ASExceptionHelper(messageID, resourceLocation);
        if (tokens != null && tokens.length > 0) {
            for (int i = 0; i < tokens.length; ++i) {
                this.m_helper.addToken(tokens[i]);
            }
        }
        if (cause != null) {
            this.initCause(cause);
        }
    }

    protected ASRuntimeException(String messageID, String resourceLocation) {
        this(messageID, null, resourceLocation);
    }

    @Override
    public Throwable initCause(Throwable cause) {
        if (cause == null || cause == this) {
            return null;
        }
        if (this.getCause() == null) {
            Throwable furtherCause = this.m_helper.initCauseActionMessage(cause);
            if (furtherCause != null) {
                super.initCause(furtherCause);
            } else {
                super.initCause(cause);
            }
        }
        return this.getCause();
    }

    public void setResourceLocation(String resourceLocation) {
        this.m_helper.setResourceLocation(resourceLocation);
    }

    public String getResourceLocation() {
        return this.m_helper.getResourceLocation();
    }

    public void setLocale(Locale locale) {
        this.m_helper.setLocale(locale);
    }

    public Locale getLocale() {
        return this.m_helper.getLocale();
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_helper.setClassLoader(loader);
    }

    public void addToken(String token) {
        this.m_helper.addToken(token);
    }

    public void replaceToken(int pos, String token) {
        this.m_helper.replaceToken(pos, token);
    }

    public List<String> getTokens() {
        return this.m_helper.getTokens();
    }

    public void addActionToken(String token) {
        this.m_helper.addActionToken(token);
    }

    public String getMessageID() {
        return this.m_helper.getMessageID();
    }

    @Override
    public String getMessage() {
        return this.m_helper.getMessage();
    }

    public String getMessage(Locale locale) {
        return this.m_helper.getMessage(locale);
    }

    ASExceptionHelper getHelper() {
        return this.m_helper;
    }

    public String getCauseMessage() {
        return this.m_helper.getCauseMessage();
    }

    public String getActionMessage() {
        return this.m_helper.getActionMessage();
    }
}

