/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.util.DMSUtil;

public abstract class TreeNode {
    public static final int NAME_LEN = 511;
    public static final int DESC_LEN = 1023;
    protected String _name;
    private String _description;
    protected final String _path;
    protected final Noun _parent;
    protected volatile boolean _alive;

    protected TreeNode(String name, String description) {
        if (name == null || description == null) {
            throw new InstrumentationException("DMS-50752", "TreeNode()", "name:" + name + ", description:" + description);
        }
        this._name = DMSUtil.sanitize(name, 511, false, false);
        this._description = DMSUtil.sanitize(description, 1023, false, false);
        this._parent = null;
        this._path = "/";
        this._alive = true;
    }

    public TreeNode(Noun parent, String name, String description) {
        this(parent, name == null ? null : DMSUtil.sanitize(name, 511, false, false), description == null ? null : DMSUtil.sanitize(description, 1023, false, false), false);
    }

    public TreeNode(Noun parent, String name, String description, boolean sanitize) {
        if (name == null || description == null || parent == null) {
            throw new InstrumentationException("DMS-50752", "TreeNode()", "parent:" + parent + ", name:" + name + ", description:" + description);
        }
        if (sanitize) {
            this._name = DMSUtil.sanitize(name, 511, true, true);
            this._description = DMSUtil.sanitize(description, 1023, false, false);
        } else {
            this._name = name;
            this._description = description;
        }
        this._parent = parent;
        this._path = "/".equals(parent.toString()) ? "/" + this._name : parent.toString() + "/" + this._name;
        this._alive = true;
        State st = StatisticsProducer._nodes_state;
        if (st != null) {
            st.increment(1);
        }
    }

    public Noun getParent() {
        return this._parent;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._path;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean isAlive() {
        return this._alive;
    }

    public void destroy() {
        this._alive = false;
        State st = StatisticsProducer._nodes_state;
        if (st != null) {
            st.increment(-1);
        }
    }

    void setName(String name) {
        this._name = name;
    }
}

