/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import java.lang.ref.WeakReference;
import oracle.dms.instrument.state.Value;

public class AnyValue
extends Value {
    private Object _value = null;
    private double _min = Double.MAX_VALUE;
    private double _max = Double.MIN_VALUE;

    @Override
    public void update(int newval) {
        Integer value = newval;
        double dval = newval;
        this.setNumber(value, dval);
        this._initialized = true;
    }

    @Override
    public void update(double newval) {
        Double value = newval;
        double dval = newval;
        this.setNumber(value, dval);
        this._initialized = true;
    }

    @Override
    public void update(long newval) {
        Long value = newval;
        double dval = newval;
        this.setNumber(value, dval);
        this._initialized = true;
    }

    @Override
    public void update(Object newval) {
        this._value = newval == null ? null : (newval instanceof String ? newval : new WeakReference<Object>(newval));
        this._initialized = true;
    }

    @Override
    public void increment(int inc) {
        if (!this.isInitialized()) {
            return;
        }
        int ival = ((Number)this._value).intValue() + inc;
        double newval = ival;
        Integer value = ival;
        this.setNumber(value, newval);
    }

    @Override
    public void increment(double inc) {
        if (!this.isInitialized()) {
            return;
        }
        double newval = ((Number)this._value).doubleValue() + inc;
        Double value = newval;
        this.setNumber(value, newval);
    }

    @Override
    public void increment(long inc) {
        if (!this.isInitialized()) {
            return;
        }
        long newval = ((Number)this._value).longValue() + inc;
        Long value = newval;
        double dval = newval;
        this.setNumber(value, dval);
    }

    private void setNumber(Number value, double dval) {
        this._value = value;
        if (this.MIN && dval < this._min) {
            this._min = dval;
        }
        if (this.MAX && dval > this._max) {
            this._max = dval;
        }
    }

    @Override
    void initMinMax() {
        if (this._initialized && this._value instanceof Number) {
            double dval = ((Number)this._value).doubleValue();
            if (this.MIN && this._min > dval) {
                this._min = dval;
            }
            if (this.MAX && this._max < dval) {
                this._max = dval;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this._value != null && this._value instanceof Number) {
            if (this.MIN) {
                this._min = ((Number)this._value).doubleValue();
            }
            if (this.MAX) {
                this._max = ((Number)this._value).doubleValue();
            }
        }
    }

    @Override
    public Object getValue() {
        Object retVal = null;
        retVal = this._value instanceof WeakReference ? ((WeakReference)this._value).get() : this._value;
        return retVal;
    }

    @Override
    public byte getType() {
        return 5;
    }

    @Override
    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Double.MAX_VALUE) {
            return this._min;
        }
        return 0.0;
    }

    @Override
    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Double.MIN_VALUE) {
            return this._max;
        }
        return 0.0;
    }

    @Override
    public String toString() {
        String retVal = "";
        if (this._value != null) {
            if (this._value instanceof WeakReference) {
                Object referrant = ((WeakReference)this._value).get();
                if (referrant != null) {
                    retVal = referrant.toString();
                }
            } else {
                retVal = this._value.toString();
            }
        }
        return retVal;
    }

    @Override
    public Object clone() {
        AnyValue retVal = (AnyValue)super.clone();
        if (this._value != null) {
            retVal._value = this.toString();
        }
        return retVal;
    }
}

