/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.internal;

import oracle.dms.clock.Clock;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.internal.SensorCoreData;

public class PhaseSensorCoreData
implements SensorCoreData {
    private static final Double ZERO_DOUBLE = 0.0;
    private static final Integer ZERO_INTEGER = 0;
    private static final Long ZERO_LONG = 0L;
    private int mActivePhasesCurrent;
    private int mActivePhasesMax;
    private int mCompletedPhases;
    private long mDurationTotal;
    private long mDurationMin = Long.MAX_VALUE;
    private long mDurationMax = Long.MIN_VALUE;
    private long mLastUpdateTime;
    private String mBaseString = super.toString();

    PhaseSensorCoreData() {
    }

    public synchronized void start(long timeStamp) {
        this.mLastUpdateTime = timeStamp;
        ++this.mActivePhasesCurrent;
        if (this.mActivePhasesCurrent > this.mActivePhasesMax) {
            this.mActivePhasesMax = this.mActivePhasesCurrent;
        }
    }

    public synchronized void stop(boolean wasStartedAnonymously, long timeStamp, long duration) {
        this.mLastUpdateTime = timeStamp;
        if (!wasStartedAnonymously) {
            --this.mActivePhasesCurrent;
        }
        ++this.mCompletedPhases;
        this.mDurationTotal += duration;
        if (duration < this.mDurationMin) {
            this.mDurationMin = duration;
        }
        if (duration > this.mDurationMax) {
            this.mDurationMax = duration;
        }
    }

    public synchronized String toString() {
        return this.mBaseString + ":[" + "open-current=" + this.mActivePhasesCurrent + ",open-max=" + this.mActivePhasesMax + ",completed=" + this.mCompletedPhases + ",duration-total=" + this.mDurationTotal + ",duration-min=" + this.mDurationMin + ",duration-max=" + this.mDurationMax + "]";
    }

    @Override
    public synchronized String toShortString() {
        return "oC=" + this.mActivePhasesCurrent + ",oMx=" + this.mActivePhasesMax + ",c=" + this.mCompletedPhases + ",dT=" + this.mDurationTotal + ",dMn=" + this.mDurationMin + ",dMx=" + this.mDurationMax;
    }

    @Override
    public synchronized Object[] getValues() {
        Clock clock = DMSConsole.getClock();
        Object[] retVal = new Object[10];
        retVal[6] = this.mActivePhasesCurrent;
        retVal[7] = this.mActivePhasesMax;
        if (this.mCompletedPhases > 0) {
            retVal[1] = this.mCompletedPhases;
            long baseTime = this.mDurationMin;
            long convertedTime = clock.convertTime(baseTime, 1000L);
            retVal[2] = convertedTime;
            baseTime = this.mDurationMax;
            convertedTime = clock.convertTime(baseTime, 1000L);
            retVal[3] = convertedTime;
            baseTime = this.mDurationTotal;
            convertedTime = clock.convertTime(baseTime, 1000L);
            retVal[0] = convertedTime;
            retVal[5] = (double)convertedTime / (double)this.mCompletedPhases;
        } else {
            retVal[1] = ZERO_INTEGER;
            retVal[2] = ZERO_LONG;
            retVal[3] = ZERO_LONG;
            retVal[0] = ZERO_LONG;
            retVal[5] = ZERO_DOUBLE;
        }
        return retVal;
    }

    @Override
    public synchronized void reset() {
        this.mActivePhasesCurrent = 0;
        this.mActivePhasesMax = 0;
        this.mCompletedPhases = 0;
        this.mDurationTotal = 0L;
        this.mDurationMin = Long.MAX_VALUE;
        this.mDurationMax = Long.MIN_VALUE;
    }
}

