/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class DMSFileUtil {
    DMSFileUtil() {
    }

    static boolean mkdir(final File dir) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return dir.mkdir();
            }
        });
    }

    static boolean mkdirs(final File dir) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return dir.mkdirs();
            }
        });
    }

    static boolean isDirectory(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory();
            }
        });
    }

    static boolean exists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    static String[] list(final File dir, final FilenameFilter filter) {
        String[] files = null;
        files = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return dir.list(filter);
            }
        });
        return files;
    }

    static FileOutputStream createFileOutputStream(final File filename, final boolean append) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws IOException {
                    return new FileOutputStream(filename, append);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    static boolean setReadable(final File filename, final boolean readable, final boolean ownerOnly) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return filename.setReadable(readable, ownerOnly);
            }
        });
    }

    static boolean setWritable(final File filename, final boolean writable, final boolean ownerOnly) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return filename.setWritable(writable, ownerOnly);
            }
        });
    }

    static boolean setExecutable(final File filename, final boolean executable, final boolean ownerOnly) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return filename.setExecutable(executable, ownerOnly);
            }
        });
    }
}

