/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal.wls;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.wls.ToWLSBridge;
import oracle.dms.context.internal.wls.WLSContextFamily;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextHelper;
import weblogic.diagnostics.context.DiagnosticContextManager;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PrimitiveContextFactory;
import weblogic.workarea.SerializableWorkContext;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public class ToWLSBridgeImpl
implements ToWLSBridge {
    public ToWLSBridgeImpl() {
        DiagnosticContextManager mgr = DiagnosticContextManager.getDiagnosticContextManager();
        mgr.setEnabled(true);
    }

    @Override
    public void addRefInWorkContextMap(DomainExecutionContext domainContext) {
        block6: {
            if (domainContext != null) {
                try {
                    WorkContextHelper wcHelper = WorkContextHelper.getWorkContextHelper();
                    if (wcHelper == null) break block6;
                    WorkContextMap map = wcHelper.getWorkContextMap();
                    if (map != null) {
                        WLSContextFamily.SerializableImpl serImpl = new WLSContextFamily.SerializableImpl(domainContext);
                        SerializableWorkContext swc = (SerializableWorkContext)PrimitiveContextFactory.createMutable((Serializable)serImpl);
                        map.put("oracle.dms.context.internal.wls.WLSContextFamily", (WorkContext)swc, 334);
                    }
                    try {
                        map.remove("weblogic.diagnostics.DiagnosticContext");
                    }
                    catch (NoWorkContextException nwe) {
                        // empty catch block
                    }
                    String diagContextId = DiagnosticContextHelper.getContextId((String)domainContext.getECID(), (String)domainContext.getRIDasString(), new EnumMap(DiagnosticContext.SecondaryId.class));
                }
                catch (Exception e) {
                    Logger l = Logger.getLogger("oracle.dms.context");
                    l.log(Level.FINE, "Can not use context bridge to WLS.", e);
                }
            }
        }
    }

    @Override
    public void removeRefFromWorkContextMap() {
        try {
            WorkContextMap map;
            WorkContextHelper wcHelper = WorkContextHelper.getWorkContextHelper();
            if (wcHelper != null && (map = wcHelper.getWorkContextMap()) != null) {
                map.remove("oracle.dms.context.internal.wls.WLSContextFamily");
                map.remove("weblogic.diagnostics.DiagnosticContext");
            }
        }
        catch (Exception e) {
            Logger l = Logger.getLogger("oracle.dms.context");
            l.log(Level.FINE, "Can not use context bridge to WLS.", e);
        }
    }

    @Override
    public synchronized void initWorkContextMap() {
        try {
            WorkContextHelper wcHelper = WorkContextHelper.getWorkContextHelper();
            if (wcHelper != null) {
                WorkContextMap map = wcHelper.getWorkContextMap();
                if (map != null) {
                    SerializableWorkContext swc = (SerializableWorkContext)PrimitiveContextFactory.createMutable((Serializable)((Object)"initBridgeContext-dms"));
                    map.put("oracle.dms.context.internal.wls.WLSContextFamily", (WorkContext)swc, 334);
                }
                map.remove("weblogic.diagnostics.DiagnosticContext");
                String string = DiagnosticContextHelper.getContextId((String)"initBridgeContext-wldf", (String)"0", (EnumMap)null);
            }
        }
        catch (Exception e) {
            Logger l = Logger.getLogger("oracle.dms.context");
            l.log(Level.FINE, "Can not use context bridge to WLS.", e);
        }
        this.removeRefFromWorkContextMap();
    }

    @Override
    public String getDiagnosticContextId() {
        String retVal = null;
        try {
            retVal = DiagnosticContextHelper.getContextId();
        }
        catch (Exception e) {
            Logger l = Logger.getLogger("oracle.dms.context");
            l.log(Level.FINE, "Can not use context bridge to get current diagnostic context ID.", e);
        }
        return retVal;
    }
}

