/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.incident.DiagnosticsDataExtractor;
import oracle.dfw.incident.Incident;

public class IncidentDetectionLogFilter
implements Filter,
DiagnosticsListener {
    private volatile boolean m_isLogDetectionEnabled = false;
    private volatile boolean m_isIncidentCreationEnabled = false;
    private Logger m_logger = LoggerFactory.getFrameworkLogger();
    private DiagnosticsDataExtractor m_dde;
    private static final int MIN_LOG_LEVEL = Level.SEVERE.intValue();
    private static final String DFW_LOGGER_NAME = "oracle.dfw";

    public IncidentDetectionLogFilter() {
        try {
            DiagnosticsFramework df = new DiagnosticsFramework();
            this.m_dde = df.getDDE();
            DiagnosticsConfiguration config = df.getConfiguration();
            if (config != null) {
                this.m_isLogDetectionEnabled = config.isLogDetectionEnabled();
                this.m_isIncidentCreationEnabled = config.isIncidentCreationEnabled();
            }
            DiagnosticsEventManager.registerListener(this);
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "DFW-40120", e);
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (this.m_isLogDetectionEnabled && this.m_isIncidentCreationEnabled && this.m_dde != null && record != null && record.getLevel().intValue() >= MIN_LOG_LEVEL && (record.getLoggerName() == null || record.getLoggerName() != null && !record.getLoggerName().startsWith(DFW_LOGGER_NAME))) {
            try {
                Incident inc = this.m_dde.createIncident(record, false);
                if (inc != null && record instanceof ODLLogRecord) {
                    ((ODLLogRecord)record).setErrorInstanceId(inc.getIncidentId());
                }
            }
            catch (Throwable e) {
                this.m_logger.log(Level.WARNING, "DFW-40116", e);
            }
        }
        return true;
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        DiagnosticsConfiguration config;
        if (event instanceof DiagnosticsConfigurationChangedEvent && (config = ((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration()) != null) {
            this.m_isLogDetectionEnabled = config.isLogDetectionEnabled();
            this.m_isIncidentCreationEnabled = config.isIncidentCreationEnabled();
        }
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }
}

