/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.Serializable;
import oracle.dms.http.Request;
import oracle.dms.reporter.Reporter;
import oracle.dms.util.QueryOptions;

public abstract class TableBaseReporter
extends Reporter {
    protected QueryOptions m_options;

    protected TableBaseReporter(Request request) {
        super(request);
        this.setQueryOptions();
    }

    public QueryOptions getQueryOptions() {
        return this.m_options;
    }

    @Override
    public void clear() {
        this.m_options.close();
    }

    protected void setQueryOptions() {
        String[] nullVariables;
        String[] variableNames;
        String historicalTime;
        String[] valueRefreshStrings;
        if (this.m_request.includeDescription() || this.m_request.includeUnits()) {
            this.m_options = this.m_request.includeValues() ? new QueryOptions(QueryOptions.QueryType.ALL) : new QueryOptions(QueryOptions.QueryType.SCHEMA);
            this.m_options.includeDescriptions(this.m_request.includeDescription());
        } else {
            this.m_options = new QueryOptions(QueryOptions.QueryType.ROWS);
        }
        if (this.m_request.getTables() != null) {
            this.m_options.setIncludeParamScopedMetricTables(true);
        }
        if ((valueRefreshStrings = this.m_request.getParameterValues("valuerefresh")) != null && valueRefreshStrings.length > 0) {
            this._setRefreshTime(valueRefreshStrings);
        }
        int interval = 0;
        String intervalString = this.m_request.getParameter("interval");
        if (intervalString != null) {
            intervalString = intervalString.trim();
            try {
                interval = Integer.parseInt(intervalString);
                if (interval >= 1000) {
                    this.m_options.setInterval(interval);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String cacheString = this.m_request.getParameter("cache");
        try {
            this.m_options.setUseCache(cacheString);
        }
        catch (IllegalArgumentException e) {
            this.m_options.setUseCache("true");
        }
        String preFetchString = this.m_request.getParameter("prefetch");
        if ("false".equalsIgnoreCase(preFetchString)) {
            this.m_options.setPrefetching(false);
        }
        if ((historicalTime = this.m_request.getParameter("historical")) != null && (historicalTime = historicalTime.trim()).length() > 0) {
            this._setHistoricTime(historicalTime);
        }
        if ((variableNames = this.m_request.getParameterValues("variable")) != null && variableNames.length > 0) {
            for (String variableName : variableNames) {
                String value;
                if (variableName == null || variableName.trim().length() == 0 || (value = this.m_request.getParameter("var_" + variableName)) == null) continue;
                this.m_options.setValue(variableName, (Serializable)((Object)value));
            }
        }
        if ((nullVariables = this.m_request.getParameterValues("variablenull")) != null && nullVariables.length > 0) {
            for (String nullVariable : nullVariables) {
                if (nullVariable == null || nullVariable.trim().length() == 0) continue;
                this.m_options.setValue(nullVariable, null);
            }
        }
    }

    private void _setRefreshTime(String[] refreshStrings) {
        for (String refreshString : refreshStrings) {
            long refreshTime;
            int index;
            if (refreshString == null || refreshString.trim().length() == 0 || (index = refreshString.indexOf(58)) <= 0) continue;
            String table = refreshString.substring(index + 1);
            String refresh = refreshString.substring(0, index);
            try {
                refreshTime = Long.parseLong(refresh.trim());
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (refreshTime <= 0L || table.trim().length() == 0) continue;
            this.m_options.setValueRefreshTime(table, refreshTime);
        }
    }

    private void _setHistoricTime(String historicString) {
        long endTime;
        long startTime;
        String[] times = historicString.split(":");
        if (times == null || times.length != 2) {
            return;
        }
        try {
            startTime = Long.parseLong(times[0].trim());
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            endTime = Long.parseLong(times[1].trim());
        }
        catch (NumberFormatException e) {
            return;
        }
        this.m_options.setHistoricalTime(startTime, endTime);
    }
}

