/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.TopoNodeIDInfo;

public class QueryOptions
implements Cloneable,
Serializable {
    public static final long NO_TIME_STAMP = 0L;
    public static final int DEFAULT_TIMEOUT = 30000;
    public static final String QUERY_TYPE = "oracle.dms.jmx.querytype";
    public static final String QUERY_TIMEOUT = "oracle.dms.jmx.timeout";
    public static final String QUERY_INTERVAL = "oracle.dms.jmx.interval";
    public static final String USE_CACHE = "oracle.dms.jmx.usecache";
    public static final String PRE_FETCH = "oracle.dms.jmx.prefetch";
    public static final String AGGREGATE_SERVERS = "oracle.dms.jmx.aggregateservers";
    public static final String FROM_COMMAND = "oracle.dms.jmx.command";
    public static final String TABLE_CLASS = "oracle.dms.jmx.tableclass";
    private QueryType m_queryType = QueryType.ROWS;
    private long m_startTime = Long.MAX_VALUE;
    private long m_endTime = Long.MAX_VALUE;
    private HashMap<String, Long> m_valueRefreshTimes = new HashMap();
    private HashMap<String, Serializable> m_variables = new HashMap();
    private HashSet<String> m_serverIds = new HashSet();
    private int m_interval = 0;
    private UseCache m_useCache = UseCache.CACHE_COPY;
    private int m_timeout = 30000;
    private long m_timestamp = 0L;
    private boolean m_isPrefetch = true;
    private transient TopoNodeIDInfo m_topologyInfo = null;
    private boolean m_isArchiving = false;
    private boolean m_isRefreshingCache = false;
    private boolean m_aggregateServers = false;
    private CacheableRow m_cacheableRow = CacheableRow.ALL;
    private boolean m_isCommand = false;
    private boolean m_includeConfigMBeans = true;
    private boolean m_includeDescriptions = false;
    private boolean m_includeParamScopedMetricTables = false;
    private static final long serialVersionUID = -1232660830343L;

    public QueryOptions() {
    }

    public QueryOptions(QueryType queryType) {
        if (queryType == null) {
            throw new IllegalArgumentException("queryType=" + (Object)((Object)queryType));
        }
        this.m_queryType = queryType;
    }

    public boolean includeSchema() {
        return this.m_queryType.includeSchema();
    }

    public boolean includeRows() {
        return this.m_queryType.includeRows();
    }

    public void setQueryType(QueryType queryType) {
        if (queryType != null) {
            this.m_queryType = queryType;
        }
    }

    public QueryType getQueryType() {
        return this.m_queryType;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void setHistoricalTime(long startTime, long endTime) {
        if (QueryOptions.isValidHistoricTime(startTime, endTime)) {
            this.m_startTime = startTime;
            this.m_endTime = endTime;
        }
    }

    public long getEndTime() {
        return this.m_endTime;
    }

    public static boolean isValidHistoricTime(long startTime, long endTime) {
        return startTime != Long.MAX_VALUE && endTime != 0L && startTime >= 0L && startTime <= endTime;
    }

    public boolean hasValidHistoricTime() {
        return QueryOptions.isValidHistoricTime(this.m_startTime, this.m_endTime);
    }

    public void setValueRefreshTime(String table, long valueRefreshTime) {
        if (table == null || table.trim().length() == 0 || valueRefreshTime <= 0L) {
            return;
        }
        this.m_valueRefreshTimes.put(table, valueRefreshTime);
    }

    public long valueRefreshTime(String table) {
        if (table == null || table.trim().length() == 0) {
            return 0L;
        }
        Long timestamp = this.m_valueRefreshTimes.get(table);
        return timestamp == null ? 0L : timestamp;
    }

    public Serializable getValue(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        return this.m_variables.get(name);
    }

    public Map<String, ? extends Serializable> getValues() {
        return this.m_variables;
    }

    public void setValue(String name, Serializable value) {
        if (name != null && name.trim().length() > 0) {
            this.m_variables.put(name, value);
        }
    }

    public void setValues(Map<String, ? extends Serializable> values) {
        if (values != null && values.size() > 0) {
            this.m_variables.putAll(values);
        }
    }

    public int getInterval() {
        return this.m_interval;
    }

    public void setInterval(int interval) {
        if (interval >= 1000) {
            this.m_interval = interval;
        }
    }

    public UseCache useCache() {
        return this.m_useCache;
    }

    public void setUseCache(UseCache useCache) {
        if (useCache != null) {
            this.m_useCache = useCache;
        }
    }

    public void setUseCache(String cacheString) throws IllegalArgumentException {
        UseCache usecache = UseCache._getUseCache(cacheString);
        this.setUseCache(usecache);
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout >= 1000) {
            this.m_timeout = timeout;
        }
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public void setTimestamp(long timestamp) {
        if (timestamp >= 1000L) {
            this.m_timestamp = timestamp;
        }
    }

    public void setPrefetching(boolean prefetch) {
        this.m_isPrefetch = prefetch;
    }

    public boolean isPrefetching() {
        return this.m_isPrefetch;
    }

    public Set<String> getServerNames() {
        return this.m_serverIds;
    }

    public void addServerNames(Set<String> serverIds) {
        if (serverIds == null || serverIds.size() == 0) {
            return;
        }
        for (String serverId : serverIds) {
            if (serverId == null || serverId.trim().length() == 0) continue;
            this.m_serverIds.add(serverId);
        }
    }

    public void addServerNames(String[] serverIds) {
        if (serverIds == null || serverIds.length == 0) {
            return;
        }
        for (String serverId : serverIds) {
            if (serverId == null || serverId.trim().length() == 0) continue;
            this.m_serverIds.add(serverId);
        }
    }

    public void removeServerNames() {
        this.m_serverIds.clear();
    }

    public void addServerName(String serverId) {
        if (serverId == null || serverId.trim().length() == 0) {
            return;
        }
        this.m_serverIds.add(serverId);
    }

    public void setTopologyInfo(TopoNodeIDInfo topoInfo) {
        if (topoInfo != null) {
            this.m_topologyInfo = topoInfo;
        }
    }

    public TopoNodeIDInfo getTopologyInfo() {
        return this.m_topologyInfo;
    }

    public void setArchiving(boolean archiving) {
        this.m_isArchiving = archiving;
    }

    public boolean isArchiving() {
        return this.m_isArchiving;
    }

    public boolean isRefreshingCache() {
        return this.m_isRefreshingCache;
    }

    public void setRefreshingCache(boolean isRefreshingCache) {
        this.m_isRefreshingCache = isRefreshingCache;
    }

    public void setCacheableRow(CacheableRow cacheableRow) {
        if (cacheableRow != null) {
            this.m_cacheableRow = cacheableRow;
        }
    }

    public CacheableRow getCacheableRow() {
        return this.m_cacheableRow;
    }

    public boolean isAggregateServers() {
        return this.m_aggregateServers;
    }

    public void setAggregateServers(boolean aggregateServers) {
        this.m_aggregateServers = aggregateServers;
    }

    public boolean isCommand() {
        return this.m_isCommand;
    }

    public void setCommand(boolean command) {
        this.m_isCommand = command;
    }

    public boolean isIncludeParamScopedMetricTables() {
        return this.m_includeParamScopedMetricTables;
    }

    public void setIncludeParamScopedMetricTables(boolean value) {
        this.m_includeParamScopedMetricTables = value;
    }

    public boolean includeConfigMBeans() {
        return this.m_includeConfigMBeans;
    }

    public void includeConfigMBeans(boolean includeConfigMBeans) {
        this.m_includeConfigMBeans = includeConfigMBeans;
    }

    public boolean includeDescriptions() {
        return this.m_includeDescriptions;
    }

    public void includeDescriptions(boolean includeDescriptions) {
        this.m_includeDescriptions = includeDescriptions;
    }

    public static QueryOptions createQueryOptions(Map<String, Serializable> values, Map<String, String> properties) throws IllegalArgumentException {
        QueryOptions options = new QueryOptions();
        if (values != null && values.size() > 0) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                options.setValue(entry.getKey(), (Serializable)entry.getValue());
            }
        }
        if (properties == null || properties.size() == 0) {
            return options;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = (String)entry.getValue();
            if (name == null) continue;
            if (value == null) {
                String mesg = DMSUtil.errorMessage("50757", name);
                throw new IllegalArgumentException(mesg);
            }
            if (QUERY_TYPE.equalsIgnoreCase(name)) {
                if ("schema".equalsIgnoreCase(value)) {
                    options.setQueryType(QueryType.SCHEMA);
                    continue;
                }
                if ("rows".equalsIgnoreCase(value)) {
                    options.setQueryType(QueryType.ROWS);
                    continue;
                }
                if ("all".equalsIgnoreCase(value)) {
                    options.setQueryType(QueryType.ALL);
                    continue;
                }
                String mesg = DMSUtil.errorMessage("50756", name, value);
                throw new IllegalArgumentException(mesg);
            }
            if (QUERY_TIMEOUT.equalsIgnoreCase(name)) {
                int timeout = Integer.parseInt(value.trim());
                if (timeout >= 0) {
                    options.setTimeout(timeout);
                    continue;
                }
                String mesg = DMSUtil.errorMessage("50756", name, value);
                throw new IllegalArgumentException(mesg);
            }
            if (QUERY_INTERVAL.equalsIgnoreCase(name)) {
                int interval = Integer.parseInt(value.trim());
                if (interval >= 0) {
                    options.setInterval(interval);
                    continue;
                }
                String mesg = DMSUtil.errorMessage("50756", name, value);
                throw new IllegalArgumentException(mesg);
            }
            if (USE_CACHE.equalsIgnoreCase(name)) {
                options.setUseCache(value);
                continue;
            }
            if (PRE_FETCH.equalsIgnoreCase(name)) {
                if ("false".equalsIgnoreCase(value)) {
                    options.setPrefetching(false);
                    continue;
                }
                if ("true".equalsIgnoreCase(value)) continue;
                String mesg = DMSUtil.errorMessage("50756", name, value);
                throw new IllegalArgumentException(mesg);
            }
            if (AGGREGATE_SERVERS.equalsIgnoreCase(name)) {
                if ("true".equalsIgnoreCase(value)) {
                    options.setAggregateServers(true);
                    continue;
                }
                if ("false".equalsIgnoreCase(value)) continue;
                String mesg = DMSUtil.errorMessage("50756", name, value);
                throw new IllegalArgumentException(mesg);
            }
            if (FROM_COMMAND.equalsIgnoreCase(name)) {
                if ("true".equalsIgnoreCase(value)) {
                    options.setCommand(true);
                    continue;
                }
                if ("false".equalsIgnoreCase(value)) continue;
                String mesg = DMSUtil.errorMessage("50756", name, value);
                throw new IllegalArgumentException(mesg);
            }
            if (TABLE_CLASS.equalsIgnoreCase(name)) {
                if ("all".equalsIgnoreCase(value)) {
                    options.setIncludeParamScopedMetricTables(true);
                    continue;
                }
                String mesg = DMSUtil.errorMessage("50756", name, value);
                throw new IllegalArgumentException(mesg);
            }
            String mesg = DMSUtil.errorMessage("50759", name);
            throw new IllegalArgumentException(mesg);
        }
        return options;
    }

    public synchronized Object clone() {
        QueryOptions clone = null;
        try {
            clone = (QueryOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.m_valueRefreshTimes = (HashMap)this.m_valueRefreshTimes.clone();
        clone.m_variables = (HashMap)this.m_variables.clone();
        clone.m_serverIds = (HashSet)this.m_serverIds.clone();
        return clone;
    }

    public void close() {
        this.m_valueRefreshTimes.clear();
        this.m_variables.clear();
        this.m_serverIds.clear();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        buf.append(":QueryType=");
        buf.append((Object)this.m_queryType);
        buf.append(",UseCache=");
        buf.append((Object)this.m_useCache);
        buf.append(",serverIds=");
        buf.append(this.m_serverIds);
        buf.append(",variables=");
        buf.append(this.m_variables);
        buf.append("m_includeParamScopedMetricTables");
        buf.append(this.m_includeParamScopedMetricTables);
        return buf.toString();
    }

    public static enum CacheableRow {
        CACHEABLE,
        UNCACHEABLE,
        ALL;


        public boolean includeCacheableRows() {
            return this == CACHEABLE || this == ALL;
        }

        public boolean includeUncacheableRows() {
            return this == UNCACHEABLE || this == ALL;
        }
    }

    public static enum QueryType {
        SCHEMA,
        ROWS,
        ALL;


        public boolean includeSchema() {
            return this == SCHEMA || this == ALL;
        }

        public boolean includeRows() {
            return this == ROWS || this == ALL;
        }
    }

    public static enum UseCache {
        CACHE_COPY("true"),
        REFRESH_VALUE("false"),
        REFRESH_ALL("all");

        private String m_string;

        private UseCache(String string2) {
            this.m_string = string2;
        }

        public String getString() {
            return this.m_string;
        }

        private static UseCache _getUseCache(String cacheString) throws IllegalArgumentException {
            if (UseCache._isRefreshTopology(cacheString)) {
                return REFRESH_ALL;
            }
            if (UseCache._isRefreshCachedMetricValues(cacheString)) {
                return REFRESH_VALUE;
            }
            if ("true".equalsIgnoreCase(cacheString)) {
                return CACHE_COPY;
            }
            String mesg = DMSUtil.errorMessage("50758", cacheString);
            throw new IllegalArgumentException(mesg);
        }

        public boolean isRefreshValue() {
            return this == REFRESH_ALL || this == REFRESH_VALUE;
        }

        public boolean isRefreshTopology() {
            return this == REFRESH_ALL;
        }

        private static boolean _isRefreshCachedMetricValues(String value) {
            return "false".equalsIgnoreCase(value) || "refreshvalues".equalsIgnoreCase(value);
        }

        private static boolean _isRefreshTopology(String value) {
            return "all".equalsIgnoreCase(value) || "refreshall".equalsIgnoreCase(value);
        }
    }
}

