/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import oracle.dms.table.AndOrNotSelector;
import oracle.dms.table.CompareSelector;
import oracle.dms.table.Row;
import oracle.dms.table.Selector;
import oracle.dms.table.TopologyCompareSelector;
import oracle.dms.util.TopoNodeIDInfo;

public abstract class RowSelector
extends Selector {
    protected RowSelector(Selector.Operator operator) {
        super(operator);
    }

    public static RowSelector eq(String column, Serializable value) {
        return new CompareSelector(column, value, Selector.Operator.EQ);
    }

    public static RowSelector ne(String column, Serializable value) {
        return new CompareSelector(column, value, Selector.Operator.NE);
    }

    public static RowSelector gt(String column, Serializable value) {
        return new CompareSelector(column, value, Selector.Operator.GT);
    }

    public static RowSelector ge(String column, Serializable value) {
        return new CompareSelector(column, value, Selector.Operator.GE);
    }

    public static RowSelector lt(String column, Serializable value) {
        return new CompareSelector(column, value, Selector.Operator.LT);
    }

    public static RowSelector le(String column, Serializable value) {
        return new CompareSelector(column, value, Selector.Operator.LE);
    }

    public static RowSelector eqIgnoreCase(String column, String value) {
        return new CompareSelector(column, (Serializable)((Object)value), Selector.Operator.EQNOCASE);
    }

    public static RowSelector contains(String column, String value) {
        return new CompareSelector(column, (Serializable)((Object)value), Selector.Operator.CONTAINS);
    }

    public static RowSelector containsToken(String column, String value) {
        return new CompareSelector(column, (Serializable)((Object)value), Selector.Operator.CONTAINSTOKEN);
    }

    public static RowSelector containsAncestor(String column, String tnId, TopoNodeIDInfo topoInfo) {
        return new TopologyCompareSelector(column, tnId, Selector.Operator.CONTAINSANCESTOR, topoInfo);
    }

    public static RowSelector containsDescendant(String column, String tnId, TopoNodeIDInfo topoInfo) {
        return new TopologyCompareSelector(column, tnId, Selector.Operator.CONTAINSDESCENDANT, topoInfo);
    }

    public static RowSelector startsWith(String column, String value) {
        return new CompareSelector(column, (Serializable)((Object)value), Selector.Operator.STARTSWITH);
    }

    public static RowSelector endsWith(String column, String value) {
        return new CompareSelector(column, (Serializable)((Object)value), Selector.Operator.ENDSWITH);
    }

    public static RowSelector isNull(String column, String value) {
        return new CompareSelector(column, (Serializable)((Object)value), Selector.Operator.IS_NULL);
    }

    public static RowSelector notNull(String column, String value) {
        return new CompareSelector(column, (Serializable)((Object)value), Selector.Operator.NOT_NULL);
    }

    public static RowSelector and(RowSelector selector1, RowSelector selector2) {
        return new AndOrNotSelector(selector1, selector2, Selector.Operator.AND);
    }

    public static RowSelector or(RowSelector selector1, RowSelector selector2) {
        return new AndOrNotSelector(selector1, selector2, Selector.Operator.OR);
    }

    public static RowSelector not(RowSelector selector) {
        return new AndOrNotSelector(selector, Selector.Operator.NOT);
    }

    public abstract boolean select(Row var1);
}

