/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import oracle.dfw.common.DFWUtils;
import oracle.dfw.common.DiagnosticsException;
import oracle.dfw.incident.Incident;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.ActivationParameterFactory;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;

public class ADRInfo {
    private String m_productType;
    private String m_productId;
    private String m_instanceId;
    private String m_ADRHome;
    private String m_ADRBase;
    private String m_incidentPath;
    private volatile boolean m_created = false;
    private static AtomicLong lastIncidentMillis_s = new AtomicLong(0L);
    private static Map<String, ADRInfo> s_adrHomes = Collections.synchronizedMap(new HashMap(2));
    private Noun m_noun = null;
    private Event m_manualIncidentCreatedEvent = null;
    private Event m_systemIncidentCreatedEvent = null;
    private Event m_incidentFloodControlledEvent = null;
    private Event m_suppressedIncidentEvent = null;
    private Event m_sizeControlledIncidentEvent = null;
    private ActivationParameter m_ADRBaseParam = null;
    private ActivationParameter m_ADRHomeParam = null;
    private ActivationParameterDescriptor m_problemKeyParam = null;
    private ActivationParameterDescriptor m_incidentIdParam = null;

    private ADRInfo(String ADRBase, String productType, String productId, String instanceId) {
        if (ADRBase == null || ADRBase.length() == 0 || productType == null || productType.length() == 0 || productId == null || productId.length() == 0 || instanceId == null || instanceId.length() == 0) {
            throw new IllegalArgumentException("invalid parameters to ADRInfo constructor. productType=" + productType + " productId=" + productId + " instanceId=" + instanceId);
        }
        this.m_productType = productType;
        this.m_productId = DFWUtils.getADRProductId(productId);
        this.m_instanceId = DFWUtils.getADRInstanceId(instanceId);
        this.m_ADRHome = DFWUtils.getADRHome(this.m_productType, this.m_productId, this.m_instanceId);
        this.m_ADRBase = ADRBase.replaceAll("\\\\", "\\\\\\\\");
        StringBuilder incidentPath = new StringBuilder();
        incidentPath.append(this.m_ADRBase);
        incidentPath.append(File.separatorChar);
        incidentPath.append(this.m_ADRHome);
        incidentPath.append(File.separatorChar);
        incidentPath.append("incident");
        incidentPath.append(File.separatorChar);
        incidentPath.append("incdir_");
        this.m_incidentPath = incidentPath.toString();
        this.m_noun = Noun.create(".oracle.dfw." + this.m_productType + "/" + this.m_productId + "/" + this.m_instanceId, "DFW_Incident");
        ActivationParameterFactory apf = DMSConsole.getActivationParameterFactory();
        ActivationParameterDescriptor baseParam = apf.createDescriptor("oracle.dfw.ADRBase", DiagnosticTranslation.class, null, null, 1);
        this.m_ADRBaseParam = baseParam.createParameter(this.m_ADRBase);
        ActivationParameterDescriptor homeParam = apf.createDescriptor("oracle.dfw.ADRHome", DiagnosticTranslation.class, null, null, Integer.MIN_VALUE);
        this.m_ADRHomeParam = homeParam.createParameter(this.m_ADRHome);
        this.m_incidentIdParam = apf.createDescriptor("oracle.dfw.incidentId", DiagnosticTranslation.class, null, null, Integer.MAX_VALUE);
        this.m_problemKeyParam = apf.createDescriptor("oracle.dfw.problemKey", DiagnosticTranslation.class, null, null, Integer.MAX_VALUE);
        this.m_noun.getDescriptor().setActivationParameterDescriptors(baseParam, homeParam, this.m_incidentIdParam, this.m_problemKeyParam);
        this.m_systemIncidentCreatedEvent = Event.create(this.m_noun, "systemIncidentCreated", "Number of system created incidents");
        this.m_manualIncidentCreatedEvent = Event.create(this.m_noun, "manualIncidentCreated", "Number of manually created incidents");
        this.m_incidentFloodControlledEvent = Event.create(this.m_noun, "floodControlled", "Number of flood controlled incidents");
        this.m_suppressedIncidentEvent = Event.create(this.m_noun, "suppressed", "Number of suppressed incidents");
        this.m_sizeControlledIncidentEvent = Event.create(this.m_noun, "sizeControlled", "Number of incidents not created due to lack of disk space");
    }

    public static ADRInfo getADRInfo(String ADRBase, String productType, String productId, String instanceId) {
        String key = productType + productId + instanceId;
        ADRInfo info = s_adrHomes.get(key);
        if (info == null) {
            info = new ADRInfo(ADRBase, productType, productId, instanceId);
            s_adrHomes.put(key, info);
        }
        return info;
    }

    public static ADRInfo getADRInfo(String ADRBase, String ADRHome) throws DiagnosticsException {
        if (ADRBase == null || ADRBase.length() == 0 || ADRHome == null || ADRHome.length() == 0) {
            throw new IllegalArgumentException("invalid parameters to getADRInfo. ADRBase=" + ADRBase + " ADRHome=" + ADRHome);
        }
        StringTokenizer st = new StringTokenizer(ADRHome, File.separator);
        if (st.countTokens() != 4 || !ADRHome.startsWith("diag")) {
            throw new DiagnosticsException("DFW-40204", ADRHome);
        }
        st.nextToken();
        return ADRInfo.getADRInfo(ADRBase, st.nextToken(), st.nextToken(), st.nextToken());
    }

    public String getProductType() {
        return this.m_productType;
    }

    public String getProductId() {
        return this.m_productId;
    }

    public String getInstanceId() {
        return this.m_instanceId;
    }

    public String getADRBase() {
        return this.m_ADRBase;
    }

    public String getBaseIncidentPath() {
        return this.m_incidentPath;
    }

    public String getADRHome() {
        return this.m_ADRHome;
    }

    public boolean created() {
        return this.m_created;
    }

    public void setCreated() {
        this.m_created = true;
    }

    void updateIncidentMetrics(Incident incident) {
        ActivationParameter incidentId = this.m_incidentIdParam.createParameter(incident.getIncidentId());
        ActivationParameter problemKey = this.m_problemKeyParam.createParameter(incident.getProblemKey());
        if (incident.isFloodControlled()) {
            this.m_incidentFloodControlledEvent.occurred(this.m_ADRBaseParam, this.m_ADRHomeParam, problemKey, incidentId);
            lastIncidentMillis_s.set(System.currentTimeMillis());
        } else if (incident.getIncidentId() == "-4") {
            this.m_suppressedIncidentEvent.occurred(this.m_ADRBaseParam, this.m_ADRHomeParam, problemKey, incidentId);
        } else if (incident.getIncidentId() == "-3") {
            this.m_sizeControlledIncidentEvent.occurred(this.m_ADRBaseParam, this.m_ADRHomeParam, problemKey, incidentId);
        } else if (incident.getIncidentSource().equals((Object)Incident.IncidentSource.SYSTEM)) {
            this.m_systemIncidentCreatedEvent.occurred(this.m_ADRBaseParam, this.m_ADRHomeParam, problemKey, incidentId);
            lastIncidentMillis_s.set(System.currentTimeMillis());
        } else {
            this.m_manualIncidentCreatedEvent.occurred(this.m_ADRBaseParam, this.m_ADRHomeParam, problemKey, incidentId);
        }
    }

    public static long getLastIncidentTime() {
        return lastIncidentMillis_s.get();
    }
}

