/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.dfw.common.DiagnosticsException;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.impl.common.NamedThreadFactory;
import oracle.dfw.impl.incident.ADRDiskSpaceException;
import oracle.dfw.impl.incident.ADRInfo;
import oracle.dfw.impl.incident.ADRSizer;
import oracle.dfw.impl.incident.AccessCheck;
import oracle.dfw.impl.incident.DateFormat;
import oracle.dfw.impl.incident.IncidentImpl;
import oracle.dfw.impl.incident.ProblemImpl;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.Problem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class ADRHelper {
    private ADRSizer m_sizer;
    private boolean m_isWindows;
    private boolean m_isAIX;
    private Logger m_logger;
    private DateFormat m_dateFormatter;
    private Timer m_purgeTimer;
    private ExecutorService m_executor;
    private static String[] IGNORE_CONTEXT_KEYS = new String[]{"DFW_WATCH_RULE"};
    private static final int MAX_INCIDENT_ERROR_ARGS = 8;
    private static final int MAX_ERROR_FACILITY_LENGTH = 10;
    private static final int MAX_ERROR_MESSAGE_LENGTH = 1024;
    private static final int MAX_ERROR_ARGUMENT_LENGTH = 64;
    public static final int MAX_INCIDENT_FILENAME_LENGTH = 64;
    private static final int MAX_INCIDENT_KEY_VALUE_LENGTH = 64;
    private static final String INC_FILE_DELIM = "###";
    private XPathExpression m_xpathIncidentFiles;
    private XPathExpression m_xpathIncidentContextValues;
    private XPathExpression m_xpathIncidentDetails;
    private XPathExpression m_xpathProblems;
    private final String m_oracleHomeEnvSetting;
    private final String m_adrBaseInternal;
    private final String m_libraryPathEnvSetting;
    private String m_adrciExecutable;
    private static final String ADRCI_BINARY = "adrci";
    private static final String ADRCI_BINARY_WINDOWS = "adrci.exe";
    private static final String ADR_SET_BASE = "set base ";
    private static final String ADR_SET_HOME = "set homepath ";
    private static final String ADR_SHOW_HOMES = "show homes";
    private static final String ADR_PURGE = "purge -i ";
    private static final String QUERY_ALL_PROBLEMS_CMD = "query problem -type xml";
    private static final String QUERY_PROBLEM_CMD = "query problem -p \"problem_id=%1$s\" -type xml";
    private static final String SHOW_INCIDENTS_CMD = "query incident -type xml -p \"problem_id=%1$s\"";
    private static final String SHOW_INCIDENTS_BY_ID_CMD = "query incident -type xml -p \"incident_id in (%1$s)\"";
    private static final String SHOW_INCIDENT_CMD = "query incident -type xml -p \"incident_id=%1$s\"";
    private static final String QUERY_INCIDENT_FILES_CMD = "query incident_file -p \"incident_id in (%1$s)\" -type xml";
    private static final String QUERY_INCIDENT_CONTEXT_VALUES_CMD = "query (incident_id, key_name, key_value) incckey -p \"incident_id in (%1$s) and key_name != 'ECID'\" -type xml";
    private static final String QUERY_INCIDENT_STATUS_CMD = "query (status) incident -p \"incident_id=%1$s\" -type xml";
    private static final String ADD_INCIDENT_FILE_CMD = "register incident file incident_id=%1$s filename=%2$s\n";
    private static final String EXIT_CMD = "exit";
    private static final String CREATE_INCIDENT_CMD = "create incident problem_key=\"%1$s\" error_facility=\"%2$s\" error_number=%3$s error_message=\"%4$s\" create_time=\"%5$s\"";
    private static final String UPGRADE_SCHEMA_CMD = "migrate schema";
    private static final String STATUS = "STATUS";
    private static final String TRACKING_STATUS = "3";
    private static final String ADR_INCIDENT_ID_RET = "Incident_id=";
    private static final String ADR_INCIDENT_DIR = "incdir=[";
    private static final String XML_TYPE = "type";
    private static final String XML_DATETIME = "dateTime";
    public static final String README_FILE = "readme.txt";
    public static final String DIAGNOSTIC_DUMPS = "Diagnostic Dumps";
    public static final String DIAGNOSTIC_DUMPS_US = "----------------";
    public static final String DUMP_NAME = "Name:";
    public static final String DUMP_ARGUMENTS = "Dump Arguments:";
    public static final String CONTEXT_APPLICATION_NAME = "Application Name:";
    public static final String CONTEXT_USER_NAME = "User Name:";
    public static final String DUMP_FILES = "Dump Files:";
    public static final String INCIDENT_ID = "Incident Id:";
    public static final String INCIDENT_SOURCE = "Incident Source:";
    public static final String ECID = "ECID:";
    public static final String CREATE_TIME = "Create Time:";
    public static final String PROBLEM_KEY = "Problem Key:";
    public static final String PROBLEM_IMPACTS = "Problem Impacts:";
    public static final String ERROR_MESSAGE = "Error Message Id:";
    public static final String STACK_TRACE = "Stack Trace";
    public static final String STACK_TRACE_US = "-----------";
    public static final String CONTEXT_VALUES = "Context Values";
    public static final String CONTEXT_VALUES_US = "--------------";
    public static final String HTTP_REQUEST = "HTTP Request";
    public static final String HTTP_REQUEST_US = "------------";
    public static final String DESCRIPTION = "Description";
    public static final String DESCRIPTION_US = "-----------";
    public static final String SPACE_COLON_SPACE = " : ";
    public static final char SPACE = ' ';
    public static final char COMMA = ',';
    public static final char NEWLINE = '\n';
    private static final String ADR_PROBLEM_ID = "PROBLEM_ID";
    private static final String ADR_PROBLEM_KEY = "PROBLEM_KEY";
    private static final String ADR_INCIDENT_ID = "INCIDENT_ID";
    private static final String ADR_INCIDENT_FILE = "INCIDENT_FILE";
    private static final String ADR_BFILE = "BFILE";
    private static final String ADR_ECID = "ECID";
    private static final String ADR_KEY_NAME = "KEY_NAME";
    private static final String ADR_KEY_VALUE = "KEY_VALUE";

    public ADRHelper(String oracleHome, final ADRInfo defaultADR, DiagnosticsConfiguration config, Logger logger) throws DiagnosticsException {
        block21: {
            block20: {
                this.m_dateFormatter = new DateFormat();
                this.m_executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("oracle.dfw.impl.incident - ADR Executor"));
                if (logger == null || defaultADR == null) {
                    throw new IllegalArgumentException("invalid arguments, the arguments must not be null; logger=" + logger + " defaultADR=" + defaultADR);
                }
                String osName = ADRHelper.getProperty("os.name");
                this.m_isWindows = osName.startsWith("Windows");
                this.m_isAIX = osName.startsWith("AIX");
                this.m_logger = logger;
                this.m_oracleHomeEnvSetting = oracleHome;
                this.m_adrBaseInternal = defaultADR.getADRBase() + File.separatorChar + "internal";
                String libraryPathEnvSetting = new String();
                if (oracleHome != null && oracleHome.length() > 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(oracleHome);
                    buf.append(File.separatorChar);
                    buf.append("bin");
                    buf.append(File.separatorChar);
                    buf.append(this.m_isWindows ? ADRCI_BINARY_WINDOWS : ADRCI_BINARY);
                    this.m_adrciExecutable = buf.toString();
                    File adrciFile = new File(this.m_adrciExecutable);
                    if (!AccessCheck.exists(adrciFile)) {
                        buf.setLength(0);
                        buf.append(oracleHome);
                        buf.append(File.separatorChar);
                        buf.append(this.m_isWindows ? ADRCI_BINARY_WINDOWS : ADRCI_BINARY);
                        this.m_adrciExecutable = buf.toString();
                        adrciFile = new File(this.m_adrciExecutable);
                        if (!AccessCheck.exists(adrciFile)) {
                            this.m_adrciExecutable = this.m_isWindows ? ADRCI_BINARY_WINDOWS : ADRCI_BINARY;
                        } else {
                            libraryPathEnvSetting = libraryPathEnvSetting + oracleHome;
                        }
                    } else {
                        libraryPathEnvSetting = libraryPathEnvSetting + oracleHome + File.separatorChar + "bin" + ADRHelper.getProperty("path.separator") + oracleHome + File.separatorChar + "lib";
                    }
                } else {
                    this.m_adrciExecutable = this.m_isWindows ? ADRCI_BINARY_WINDOWS : ADRCI_BINARY;
                }
                this.m_libraryPathEnvSetting = libraryPathEnvSetting + ADRHelper.getProperty("path.separator") + ADRHelper.getProperty("java.library.path");
                try {
                    try {
                        this.invoke(new String[]{"help"}, null, false);
                    }
                    catch (DiagnosticsException e) {
                        if (this.m_adrciExecutable.compareTo(ADRCI_BINARY) != 0) {
                            this.m_adrciExecutable = ADRCI_BINARY;
                            this.invoke(new String[]{"help"}, null, false);
                            break block20;
                        }
                        throw e;
                    }
                }
                catch (DiagnosticsException e) {
                    if (oracleHome != null && oracleHome.length() > 0) {
                        throw new DiagnosticsException("failure loading adrci binary under Oracle Home \"" + oracleHome + "\" and from the system path", e);
                    }
                    throw new DiagnosticsException("failure loading adrci binary from the system path", e);
                }
            }
            try {
                XPath xpath = XPathFactory.newInstance().newXPath();
                this.m_xpathIncidentFiles = xpath.compile("/ADR_RELATION/ADR_HOME/incident_file_REC");
                this.m_xpathIncidentContextValues = xpath.compile("/ADR_RELATION/ADR_HOME/incckey_REC");
                this.m_xpathIncidentDetails = xpath.compile("/ADR_RELATION/ADR_HOME/incident_REC");
                this.m_xpathProblems = xpath.compile("/ADR_RELATION/ADR_HOME/problem_REC");
            }
            catch (XPathExpressionException e) {
                throw new DiagnosticsException("Failed to compile ADR XPath expressions", e);
            }
            this.m_sizer = new ADRSizer(this, defaultADR.getADRBase(), config, logger);
            if (this.m_isWindows) {
                try {
                    if (this.checkADRHomeExists(defaultADR)) {
                        this.invoke(new String[]{"show version schema"}, defaultADR, false);
                    }
                }
                catch (Exception e) {
                    File adrBaseDiagInternal;
                    if (!e.getMessage().contains("DIA-48227")) break block21;
                    File adrBaseDiag = new File(defaultADR.getADRBase(), "diag");
                    if (adrBaseDiag.exists()) {
                        File backupDir = new File(defaultADR.getADRBase(), "diag." + System.currentTimeMillis());
                        AccessCheck.renameTo(adrBaseDiag, backupDir);
                        this.m_logger.log(Level.WARNING, "DFW-40131", new Object[]{adrBaseDiag, backupDir});
                    }
                    if (!(adrBaseDiagInternal = new File(this.m_adrBaseInternal, "diag")).exists()) break block21;
                    File backupDirInternal = new File(this.m_adrBaseInternal, "diag." + System.currentTimeMillis());
                    AccessCheck.renameTo(adrBaseDiagInternal, backupDirInternal);
                }
            }
        }
        Runnable createBase = new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> adrHomes = ADRHelper.this.listADRHomes(defaultADR.getADRBase());
                    String[] cmds = new String[adrHomes.size() * 2];
                    int index = 0;
                    for (String adrHome : adrHomes) {
                        cmds[index++] = ADRHelper.ADR_SET_HOME + adrHome;
                        cmds[index++] = ADRHelper.UPGRADE_SCHEMA_CMD;
                    }
                    ADRHelper.this.invoke(cmds, defaultADR, true);
                }
                catch (Throwable e) {
                    ADRHelper.this.m_logger.log(Level.FINE, "failure creating ADR Base", e);
                }
                ADRHelper.this.m_sizer.init();
            }
        };
        Thread thread = new Thread(createBase);
        thread.setDaemon(true);
        thread.setName("oracle.dfw.impl.incident.ADRHelper - create ADR Base");
        thread.start();
        TimerTask purgeTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ADRHelper.this.m_logger.log(Level.FINE, "Invoking ADR purge for time-based cleanup");
                    List<String> adrHomes = ADRHelper.this.listADRHomes(defaultADR.getADRBase());
                    String[] cmds = new String[adrHomes.size() * 2];
                    int index = 0;
                    for (String adrHome : adrHomes) {
                        cmds[index++] = ADRHelper.ADR_SET_HOME + adrHome;
                        cmds[index++] = "purge";
                    }
                    ADRHelper.this.invoke(cmds, defaultADR, true);
                }
                catch (Throwable t) {
                    ADRHelper.this.m_logger.log(Level.FINE, "failure invoking ADR purge", t);
                }
            }
        };
        this.m_purgeTimer = new Timer("oracle.dfw.impl.incident.ADRHelper - purge incidents", true);
        this.m_purgeTimer.scheduleAtFixedRate(purgeTask, 300000L, 86400000L);
    }

    List<String> listADRHomes(String ADRBase) {
        ArrayList<String> homes = new ArrayList<String>(1);
        try {
            String output = this.invoke(new String[]{ADR_SET_BASE + ADRBase, ADR_SHOW_HOMES}, null, false);
            if (output != null) {
                BufferedReader br = new BufferedReader(new StringReader(output));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("diag")) continue;
                    homes.add(line);
                }
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "failure querying available ADR Homes", e);
        }
        return homes;
    }

    public boolean purgeIncident(String adrBase, String adrHome, String incidentId) {
        boolean purged = false;
        try {
            String status;
            List<Map<String, String>> incStatus = null;
            String output = this.invoke(new String[]{ADR_SET_BASE + adrBase, ADR_SET_HOME + adrHome, String.format(QUERY_INCIDENT_STATUS_CMD, incidentId)}, null, false);
            incStatus = this.parseData(output, this.m_xpathIncidentDetails);
            if (incStatus != null && incStatus.size() == 1 && (status = incStatus.get(0).get(STATUS)) != null && !status.equals(TRACKING_STATUS)) {
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.finer("Purging incident " + incidentId + " in  ADR Home " + adrHome);
                }
                output = this.invoke(new String[]{ADR_SET_BASE + adrBase, ADR_SET_HOME + adrHome, ADR_PURGE + incidentId}, null, false);
                purged = true;
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.CONFIG, "failure purging incident " + incidentId + " in ADR Home " + adrHome, e);
        }
        return purged;
    }

    List<Problem> listProblems(ADRInfo adrInfo) {
        List<Map<String, String>> problems = null;
        try {
            String problemsXML = this.invoke(new String[]{QUERY_ALL_PROBLEMS_CMD}, adrInfo, false);
            problems = this.parseData(problemsXML, this.m_xpathProblems);
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "failure parsing ADR XML data", e);
        }
        ArrayList<Problem> ret = new ArrayList<Problem>();
        if (problems != null) {
            for (Map map : problems) {
                ret.add(this.convertADRProblem(adrInfo, map));
            }
        }
        return ret;
    }

    Problem getProblem(ADRInfo adrInfo, String problemId) {
        List<Map<String, String>> problems = null;
        try {
            String problemXML = this.invoke(new String[]{String.format(QUERY_PROBLEM_CMD, problemId)}, adrInfo, false);
            problems = this.parseData(problemXML, this.m_xpathProblems);
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "failure parsing ADR XML data: ", e);
        }
        Problem ret = null;
        if (problems != null && problems.size() > 0) {
            ret = this.convertADRProblem(adrInfo, (Map)problems.get(0));
        }
        return ret;
    }

    private final Problem convertADRProblem(ADRInfo adrInfo, Map<String, String> attributes) {
        ProblemImpl ret = new ProblemImpl(attributes.get(ADR_PROBLEM_ID), attributes.get(ADR_PROBLEM_KEY), adrInfo.getADRBase(), adrInfo.getProductType(), adrInfo.getProductId(), adrInfo.getInstanceId());
        return ret;
    }

    List<Incident> listIncidents(ADRInfo adrInfo, String problemId) {
        List<Map<String, String>> incidents = null;
        try {
            String incidentsXML = this.invoke(new String[]{String.format(SHOW_INCIDENTS_CMD, problemId)}, adrInfo, false);
            incidents = this.parseData(incidentsXML, this.m_xpathIncidentDetails);
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "failure parsing ADR XML data: ", e);
        }
        ArrayList<Incident> ret = new ArrayList<Incident>();
        if (incidents != null) {
            Problem prob = this.getProblem(adrInfo, problemId);
            for (Map map : incidents) {
                map.put(ADR_PROBLEM_KEY, prob.getProblemKey());
                ret.add(this.convertADRIncident(adrInfo, map));
            }
            IncidentImpl[] incs = ret.toArray(new IncidentImpl[0]);
            this.addADRFilesToIncident(adrInfo, incs);
            this.addADRContextValuesToIncident(adrInfo, incs);
        }
        return ret;
    }

    List<Incident> getIncidents(ADRInfo adrInfo, Set<String> incidentIds) {
        List<Map<String, String>> incidents = null;
        StringBuilder incidentIdsList = new StringBuilder();
        boolean first = true;
        for (String id : incidentIds) {
            if (!first) {
                incidentIdsList.append(",");
            }
            incidentIdsList.append(id);
            first = false;
        }
        try {
            String incidentsXML = this.invoke(new String[]{String.format(SHOW_INCIDENTS_BY_ID_CMD, incidentIdsList.toString())}, adrInfo, false);
            incidents = this.parseData(incidentsXML, this.m_xpathIncidentDetails);
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "failure parsing ADR XML data: ", e);
        }
        ArrayList<Incident> ret = new ArrayList<Incident>();
        if (incidents != null) {
            for (Map map : incidents) {
                Problem prob = this.getProblem(adrInfo, (String)map.get(ADR_PROBLEM_ID));
                map.put(ADR_PROBLEM_KEY, prob.getProblemKey());
                ret.add(this.convertADRIncident(adrInfo, map));
            }
            IncidentImpl[] incs = ret.toArray(new IncidentImpl[0]);
            this.addADRFilesToIncident(adrInfo, incs);
            this.addADRContextValuesToIncident(adrInfo, incs);
        }
        return ret;
    }

    Incident getIncident(ADRInfo adrInfo, String incidentId) {
        List<Map<String, String>> incidents = null;
        try {
            String incidentXML = this.invoke(new String[]{String.format(SHOW_INCIDENT_CMD, incidentId)}, adrInfo, false);
            incidents = this.parseData(incidentXML, this.m_xpathIncidentDetails);
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "failure parsing ADR XML data: ", e);
        }
        IncidentImpl ret = null;
        if (incidents != null && incidents.size() > 0) {
            Problem prob = this.getProblem(adrInfo, (String)((Map)incidents.get(0)).get(ADR_PROBLEM_ID));
            incidents.get(0).put(ADR_PROBLEM_KEY, prob.getProblemKey());
            ret = this.convertADRIncident(adrInfo, incidents.get(0));
            this.addADRFilesToIncident(adrInfo, ret);
            this.addADRContextValuesToIncident(adrInfo, ret);
        }
        return ret;
    }

    public Set<String> queryIncidents(ADRInfo adrInfo, String query, boolean isIncidentRelation) throws DiagnosticsException {
        String incidentsXML = this.invoke(new String[]{query}, adrInfo, false);
        List<Map<String, String>> incidentQueryIds = null;
        incidentQueryIds = isIncidentRelation ? this.parseData(incidentsXML, this.m_xpathIncidentDetails) : this.parseData(incidentsXML, this.m_xpathIncidentContextValues);
        HashSet<String> incidentIds = null;
        if (incidentQueryIds != null && incidentQueryIds.size() > 0) {
            incidentIds = new HashSet<String>(incidentQueryIds.size());
            for (Map<String, String> id : incidentQueryIds) {
                incidentIds.add(id.get(ADR_INCIDENT_ID));
            }
        }
        return incidentIds;
    }

    public Set<String> queryProblems(ADRInfo adrInfo, String query) throws DiagnosticsException {
        String problemsXML = this.invoke(new String[]{query}, adrInfo, false);
        List<Map<String, String>> problemQueryIds = null;
        problemQueryIds = this.parseData(problemsXML, this.m_xpathProblems);
        HashSet<String> problemIds = null;
        if (problemQueryIds != null && problemQueryIds.size() > 0) {
            problemIds = new HashSet<String>(problemQueryIds.size());
            for (Map<String, String> id : problemQueryIds) {
                problemIds.add(id.get(ADR_PROBLEM_ID));
            }
        }
        return problemIds;
    }

    private final IncidentImpl convertADRIncident(ADRInfo adrInfo, Map<String, String> attributes) {
        ErrorMessage msg = null;
        String errFacility = attributes.get("ERROR_FACILITY");
        String errNumber = attributes.get("ERROR_NUMBER");
        if (errFacility != null && errFacility.length() > 0 && errNumber != null && errNumber.length() > 0) {
            String name;
            String value;
            try {
                msg = new ErrorMessage(errFacility, Integer.parseInt(errNumber));
            }
            catch (NumberFormatException e) {
                this.m_logger.log(Level.FINE, "failure parsing error number " + errNumber, e);
                msg = new ErrorMessage("DFW", 99999);
            }
            ArrayList<String> args = new ArrayList<String>();
            for (int i = 1; i < 9 && (value = attributes.get(name = "ERROR_ARG" + i)) != null && value.length() > 0; ++i) {
                args.add(value);
            }
            if (args.size() > 0) {
                msg.setErrorArguments(args);
            }
        } else {
            msg = new ErrorMessage("DFW", 99999);
        }
        IncidentImpl ret = new IncidentImpl(attributes.get(ADR_INCIDENT_ID), adrInfo.getBaseIncidentPath() + attributes.get(ADR_INCIDENT_ID), adrInfo.getADRBase(), adrInfo.getProductType(), adrInfo.getProductId(), adrInfo.getInstanceId(), attributes.get(ADR_PROBLEM_ID), attributes.get(ADR_PROBLEM_KEY), attributes.get(ADR_ECID), Long.parseLong(attributes.get("CREATE_TIME")), msg);
        if (attributes.get("FLOOD_CONTROLLED") != null && attributes.get("FLOOD_CONTROLLED").compareToIgnoreCase("1") == 0) {
            ret.setFloodContolled(null);
        }
        return ret;
    }

    private void addADRContextValuesToIncident(ADRInfo adrInfo, IncidentImpl ... incidents) {
        HashMap<String, IncidentImpl> incMap = new HashMap<String, IncidentImpl>();
        StringBuffer incidentIds = new StringBuffer();
        boolean first = true;
        for (IncidentImpl inc : incidents) {
            if (!first) {
                incidentIds.append(",");
            }
            incidentIds.append(inc.getIncidentId());
            incMap.put(inc.getIncidentId(), inc);
            first = false;
        }
        try {
            List<Map<String, String>> incContextValues = null;
            String incidentContextValuesXML = this.invoke(new String[]{String.format(QUERY_INCIDENT_CONTEXT_VALUES_CMD, incidentIds.toString())}, adrInfo, false);
            incContextValues = this.parseData(incidentContextValuesXML, this.m_xpathIncidentContextValues);
            if (incContextValues != null) {
                for (Map<String, String> contextValueDetail : incContextValues) {
                    IncidentImpl inc = (IncidentImpl)incMap.get(contextValueDetail.get(ADR_INCIDENT_ID));
                    inc.setContextValue(contextValueDetail.get(ADR_KEY_NAME), contextValueDetail.get(ADR_KEY_VALUE));
                }
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "unable to query context values for incidents " + incidentIds.toString(), e);
        }
    }

    private void addADRFilesToIncident(ADRInfo adrInfo, IncidentImpl ... incidents) {
        HashMap<String, IncidentImpl> incMap = new HashMap<String, IncidentImpl>();
        StringBuffer incidentIds = new StringBuffer();
        boolean first = true;
        for (IncidentImpl inc : incidents) {
            if (!first) {
                incidentIds.append(",");
            }
            incidentIds.append(inc.getIncidentId());
            incMap.put(inc.getIncidentId(), inc);
            first = false;
        }
        try {
            List<Map<String, String>> incFiles = null;
            String incidentFileXML = this.invoke(new String[]{String.format(QUERY_INCIDENT_FILES_CMD, incidentIds.toString())}, adrInfo, false);
            incFiles = this.parseData(incidentFileXML, this.m_xpathIncidentFiles);
            if (incFiles != null) {
                for (Map<String, String> fileDetails : incFiles) {
                    IncidentImpl inc = (IncidentImpl)incMap.get(fileDetails.get(ADR_INCIDENT_ID));
                    inc.addIncidentFiles(new File(fileDetails.get(ADR_BFILE)).getName());
                }
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.FINE, "unable to query files for incidents " + incidentIds.toString(), e);
        }
    }

    void createADRHome(ADRInfo adrInfo) throws DiagnosticsException {
        this.invoke(new String[]{"help"}, adrInfo, true);
    }

    String[] createIncident(ADRInfo adrInfo, IncidentFacts facts) throws DiagnosticsException, ADRDiskSpaceException {
        String output;
        String errorFacility;
        if (!this.m_sizer.isSpaceAvailable()) {
            throw new ADRDiskSpaceException(this.m_sizer.getMaxTotalIncidentSize(), this.m_sizer.getActualTotalIncidentSize());
        }
        String[] result = new String[]{null, null};
        String errorMessage = facts.getErrorMessage().getErrorMessageText();
        if (errorMessage != null) {
            errorMessage = ADRHelper.truncateValue(errorMessage, 1024);
            errorMessage = this.escapeValue(errorMessage);
        }
        if ((errorFacility = facts.getErrorMessage().getErrorFacility()) != null) {
            errorFacility = ADRHelper.truncateValue(errorFacility, 10);
        }
        StringBuilder cmd = new StringBuilder();
        cmd.append(String.format(CREATE_INCIDENT_CMD, facts.getProblemKey(), errorFacility, facts.getErrorMessage().getErrorNumber(), errorMessage, this.formatDate(new Date(facts.getIncidentTime()))));
        String ecid = facts.getExecutionContextId();
        if (ecid != null && ecid.length() > 0) {
            cmd.append(" ecid=\"");
            cmd.append(this.escapeValue(ecid));
            cmd.append("\"");
        }
        if (facts.getErrorMessage().getErrorArguments() != null) {
            int count = 1;
            for (String arg : facts.getErrorMessage().getErrorArguments()) {
                cmd.append(" error_arg" + count++);
                cmd.append("=\"");
                cmd.append(this.escapeValue(ADRHelper.truncateValue(arg, 64)));
                cmd.append("\"");
                if (count <= 8) continue;
                break;
            }
        }
        if ((output = this.invoke(new String[]{cmd.toString()}, adrInfo, true)) != null) {
            try {
                BufferedReader br = new BufferedReader(new StringReader(output));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith(ADR_INCIDENT_ID_RET)) {
                        result[0] = line.substring(ADR_INCIDENT_ID_RET.length(), line.length());
                        continue;
                    }
                    if (!line.startsWith(ADR_INCIDENT_DIR)) continue;
                    result[1] = line.substring(ADR_INCIDENT_DIR.length(), line.length() - 1);
                }
            }
            catch (IOException e) {
                throw new DiagnosticsException("DFW-40111", output, e);
            }
        }
        if (result[0] == null || result[1] == null) {
            throw new DiagnosticsException("DFW-40111", output);
        }
        if (facts.getContextValues() != null && facts.getContextValues().size() > 0) {
            String[] regKeyCommands = new String[facts.getContextValues().size()];
            int index = 0;
            for (Map.Entry<String, String> contextValue : facts.getContextValues().entrySet()) {
                String keyValue;
                if (ADRHelper.isIgnoringContextKey(contextValue.getKey())) continue;
                String flags = "";
                if (contextValue.getKey().equals("ODL_TRACE_ID") || contextValue.getKey().equals("DSID")) {
                    flags = " flags=6";
                }
                if ((keyValue = contextValue.getValue()).length() >= 64) {
                    keyValue = keyValue.substring(0, 63);
                }
                regKeyCommands[index] = "register incident key keyname='" + this.escapeValue(contextValue.getKey()) + "' keyvalue='" + this.escapeValue(keyValue) + "' incident_id=" + result[0] + flags;
                ++index;
            }
            String contextOut = this.invoke(regKeyCommands, adrInfo, true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIncidentFiles(ADRInfo adrInfo, String incidentId, String ... incidentFilenames) throws DiagnosticsException {
        long totalSizeUsed = 0L;
        try {
            StringBuilder addFilesCmd = new StringBuilder();
            for (String filename : incidentFilenames) {
                File incFile = new File(adrInfo.getADRBase(), adrInfo.getADRHome() + File.separatorChar + "incident" + File.separatorChar + "incdir_" + incidentId + File.separatorChar + filename);
                totalSizeUsed += AccessCheck.length(incFile);
                if (filename.length() > 64) {
                    DiagnosticsException exp = new DiagnosticsException("DFW-40119");
                    exp.addToken(filename);
                    exp.addToken(incidentId);
                    exp.addToken(String.valueOf(64));
                    throw exp;
                }
                filename = filename.replaceAll("\\\\", "\\\\\\\\");
                filename = filename.replaceAll("\"", "\\\\\"");
                addFilesCmd.append(String.format(ADD_INCIDENT_FILE_CMD, incidentId, filename));
            }
            this.invoke(new String[]{addFilesCmd.toString()}, adrInfo, false);
        }
        finally {
            this.m_sizer.incrementSize(totalSizeUsed);
        }
    }

    private boolean checkADRHomeExists(ADRInfo adrInfo) {
        boolean exists = false;
        try {
            List<String> homes = this.listADRHomes(adrInfo.getADRBase());
            if (homes != null && homes.contains(adrInfo.getADRHome())) {
                exists = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return exists;
    }

    private String escapeValue(String value) {
        value = value.replaceAll("\\\\", "\\\\\\\\");
        value = value.replaceAll("\"", "\\\\\"");
        value = value.replaceAll("'", "\\\\'");
        return value.replaceAll("#", " ");
    }

    private synchronized String invoke(String[] adrciCommands, ADRInfo adrInfo, boolean createADRHome) throws DiagnosticsException {
        if (adrciCommands == null) {
            return null;
        }
        StreamReader errorReader = null;
        StreamReader outputReader = null;
        int exitValue = 0;
        boolean adrHomeCreated = false;
        long timeout = 120L;
        StringBuilder commands = new StringBuilder();
        PrintWriter out = null;
        try {
            String adrciExecutable = this.m_adrciExecutable;
            Process proc = null;
            Map<String, String> env = null;
            final ProcessBuilder pb = new ProcessBuilder(adrciExecutable);
            try {
                env = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, String>>(){

                    @Override
                    public Map<String, String> run() {
                        return pb.environment();
                    }
                });
                env.put("ORACLE_HOME", this.m_oracleHomeEnvSetting);
                env.put("LD_LIBRARY_PATH", this.m_libraryPathEnvSetting);
                env.put("ORACLE_BASE", this.m_adrBaseInternal);
                if (this.m_isAIX) {
                    env.put("LIBPATH", this.m_libraryPathEnvSetting);
                }
                proc = AccessController.doPrivileged(new PrivilegedExceptionAction<Process>(){

                    @Override
                    public Process run() throws IOException {
                        return pb.start();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            errorReader = new StreamReader(proc.getErrorStream(), false);
            outputReader = new StreamReader(proc.getInputStream(), true);
            errorReader.start();
            outputReader.start();
            out = new PrintWriter(new OutputStreamWriter(proc.getOutputStream()));
            if (adrInfo != null) {
                if (!adrInfo.created() && createADRHome) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("create home base=\"");
                    buf.append(adrInfo.getADRBase());
                    buf.append("\" product_type=");
                    buf.append(adrInfo.getProductType());
                    buf.append(" product_id=");
                    buf.append(adrInfo.getProductId());
                    buf.append(" instance_id=");
                    buf.append(adrInfo.getInstanceId());
                    String createHomeCmd = buf.toString();
                    commands.append(createHomeCmd);
                    commands.append('\n');
                    out.println(createHomeCmd);
                    if (this.m_logger.isLoggable(Level.FINE)) {
                        this.m_logger.fine("Executing ADR command: migrate schema");
                    }
                    commands.append(UPGRADE_SCHEMA_CMD);
                    commands.append('\n');
                    out.println(UPGRADE_SCHEMA_CMD);
                    adrHomeCreated = true;
                    timeout = 500L;
                }
                String setHomePath = ADR_SET_BASE + adrInfo.getADRBase() + '\n' + ADR_SET_HOME + adrInfo.getADRHome();
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.fine("Executing ADR command: " + setHomePath);
                }
                commands.append(setHomePath);
                commands.append('\n');
                out.println(setHomePath);
            }
            for (String adrciCmd : adrciCommands) {
                if (adrciCmd == null) continue;
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.fine("Executing ADR command: " + adrciCmd);
                }
                commands.append(adrciCmd);
                commands.append('\n');
                out.println(adrciCmd);
            }
            out.println(EXIT_CMD);
            out.flush();
            exitValue = this.getProcessExitValue(proc, timeout);
            outputReader.join();
            errorReader.join();
        }
        catch (Throwable e) {
            DiagnosticsException de = new DiagnosticsException("DFW-40112", commands.toString());
            de.addCauseToken(e.getMessage());
            throw de;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.m_logger.log(Level.FINER, "failure closing ADRCI outputstream", e);
                }
            }
        }
        if (errorReader.getResult() != null && errorReader.getResult().length() > 0) {
            throw new DiagnosticsException("DFW-40112", errorReader.getResult());
        }
        if (outputReader.getErrors() != null && outputReader.getErrors().length() > 0) {
            DiagnosticsException de = new DiagnosticsException("DFW-40112", commands.toString());
            de.addCauseToken(outputReader.getErrors());
            throw de;
        }
        if (exitValue != 0) {
            throw new DiagnosticsException("DFW-40113", Integer.toString(exitValue));
        }
        if (adrInfo != null && adrHomeCreated) {
            adrInfo.setCreated();
        }
        return outputReader.getResult();
    }

    private int getProcessExitValue(final Process proc, long timeout) throws Exception {
        Callable<Integer> call = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                proc.waitFor();
                return proc.exitValue();
            }
        };
        try {
            Future<Integer> ft = this.m_executor.submit(call);
            int exitVal = ft.get(timeout, TimeUnit.SECONDS);
            return exitVal;
        }
        catch (TimeoutException toe) {
            proc.destroy();
            this.m_logger.finer("ADRCI timeout out after " + timeout + " seconds");
            throw new Exception("ADRCI timed out after " + timeout + " seconds");
        }
    }

    private String formatDate(Date date) {
        StringBuilder buf = new StringBuilder();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        buf.append(calendar.get(1));
        int val = calendar.get(2) + 1;
        buf.append(val < 10 ? "-0" : "-");
        buf.append(val);
        val = calendar.get(5);
        buf.append(val < 10 ? "-0" : "-");
        buf.append(val);
        val = calendar.get(11);
        buf.append(val < 10 ? " 0" : " ");
        buf.append(val);
        val = calendar.get(12);
        buf.append(val < 10 ? ":0" : ":");
        buf.append(val);
        val = calendar.get(13);
        buf.append(val < 10 ? ":0" : ":");
        buf.append(val);
        val = calendar.get(14);
        buf.append(val < 10 ? ".00" : (val < 100 ? ".0" : "."));
        buf.append(val);
        int offset = (calendar.get(15) + calendar.get(16)) / 1000;
        if (offset < 0) {
            buf.append(" -");
            offset = -offset;
        } else {
            buf.append(" +");
        }
        val = offset / 3600;
        if (val < 10) {
            buf.append("0");
        }
        buf.append(val);
        val = (offset - val * 3600) / 60;
        buf.append(val < 10 ? ":0" : ":");
        buf.append(val);
        return buf.toString();
    }

    private List<Map<String, String>> parseData(String dataXML, XPathExpression path) throws DiagnosticsException {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        if (dataXML != null && dataXML.startsWith("<")) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(new StringReader(dataXML)));
                NodeList rows = (NodeList)path.evaluate(doc, XPathConstants.NODESET);
                if (rows != null && rows.getLength() > 0) {
                    int len = rows.getLength();
                    for (int i = 0; i < len; ++i) {
                        NodeList colElements = rows.item(i).getChildNodes();
                        if (colElements == null || colElements.getLength() <= 0) continue;
                        int colCount = colElements.getLength();
                        StringBuffer incidentFiles = new StringBuffer();
                        LinkedHashMap<String, String> dataValues = new LinkedHashMap<String, String>();
                        data.add(dataValues);
                        for (int k = 0; k < colCount; ++k) {
                            Node colElement = colElements.item(k);
                            if (colElement.getNodeType() != 1) continue;
                            String colName = colElement.getNodeName();
                            String value = colElement.getTextContent();
                            if (((Element)colElement).getAttribute(XML_TYPE) != null && ((Element)colElement).getAttribute(XML_TYPE).equals(XML_DATETIME)) {
                                value = Long.toString(this.m_dateFormatter.parse(value));
                            }
                            if (colName.equals(ADR_INCIDENT_FILE)) {
                                File incFile = new File(value);
                                incidentFiles.append(INC_FILE_DELIM);
                                String filename = incFile.getName();
                                incidentFiles.append(filename);
                                if (filename.compareTo(README_FILE) == 0) {
                                    dataValues.put(README_FILE, value);
                                }
                            }
                            dataValues.put(colName, value);
                        }
                        if (incidentFiles.length() <= 0) continue;
                        dataValues.put(ADR_INCIDENT_FILE, incidentFiles.toString());
                    }
                }
            }
            catch (Throwable e) {
                throw new DiagnosticsException("DFW-40110", e);
            }
        }
        return data;
    }

    private static String getProperty(final String key) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    private static String truncateValue(String value, int maxLength) {
        String retVal = "";
        if (value == null || value.length() <= 0) {
            return retVal;
        }
        Charset utf8cs = Charset.forName("UTF-8");
        CharsetDecoder csDecoder = utf8cs.newDecoder();
        try {
            byte[] rawByteArray = value.getBytes("UTF-8");
            if (rawByteArray.length > maxLength) {
                ByteBuffer truncatedRawByteArray = ByteBuffer.wrap(rawByteArray, 0, maxLength);
                CharBuffer workBuffer = CharBuffer.allocate(maxLength);
                csDecoder.onMalformedInput(CodingErrorAction.IGNORE);
                csDecoder.decode(truncatedRawByteArray, workBuffer, true);
                csDecoder.flush(workBuffer);
                retVal = new String(workBuffer.array(), 0, workBuffer.position());
            } else {
                retVal = value;
            }
        }
        catch (UnsupportedEncodingException uex) {
            retVal = "";
        }
        return retVal;
    }

    static boolean isIgnoringContextKey(String key) {
        for (String ignoreKey : IGNORE_CONTEXT_KEYS) {
            if (!ignoreKey.equals(key)) continue;
            return true;
        }
        return false;
    }

    private static class StreamReader
    extends Thread {
        private InputStream m_is;
        private boolean m_cleanOutput;
        private StringBuilder m_result = new StringBuilder();
        private StringBuilder m_error = new StringBuilder();
        private static final String ADRCI_PROMPT = "adrci>";
        private static final char NEWLINE = '\n';
        private static final String BLANK = "";

        StreamReader(InputStream is, boolean cleanOutput) {
            this.m_is = is;
            this.m_cleanOutput = cleanOutput;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.m_is));
                String line = null;
                boolean startCleanOutput = false;
                while ((line = br.readLine()) != null) {
                    if (this.m_cleanOutput) {
                        int index = line.indexOf(ADRCI_PROMPT);
                        if (!startCleanOutput && index == -1) continue;
                        if (index > -1) {
                            startCleanOutput = true;
                            line = line.replace(ADRCI_PROMPT, BLANK);
                        }
                    }
                    if (line.indexOf("DIA-") >= 0) {
                        this.m_error.append(line.trim());
                        this.m_error.append('\n');
                    }
                    this.m_result.append(line.trim());
                    this.m_result.append('\n');
                }
            }
            catch (IOException ioe) {
                this.m_error.append(ioe.getMessage());
            }
        }

        public String getResult() {
            return this.m_result.toString();
        }

        public String getErrors() {
            return this.m_error.toString();
        }
    }
}

