/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.ApplicationContext;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpManager;
import oracle.dfw.dump.DumpRegistrationEvent;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.InvalidDumpContextException;
import oracle.dfw.impl.common.NamedThreadFactory;
import oracle.dfw.impl.common.WeakReferenceWithKey;
import oracle.dfw.impl.dump.AccessCheck;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.ActivationParameterFactory;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.PhaseEventActivationToken;
import oracle.dms.instrument.State;

public class DumpManagerImpl
implements DumpManager {
    private static final DumpManagerImpl INSTANCE = new DumpManagerImpl();
    private Map<String, WeakReferenceWithKey<String, DiagnosticDump>> m_sysDumps;
    private ReferenceQueue<WeakReferenceWithKey<String, DiagnosticDump>> m_sysRefQueue;
    private Map<String, Map<String, WeakReferenceWithKey<String, DiagnosticDump>>> m_appDumps;
    private ReferenceQueue<WeakReferenceWithKey<String, DiagnosticDump>> m_appRefQueue;
    private HashMap<String, PhaseEvent> m_executeTimePhaseEvents;
    private ActivationParameterDescriptor m_appNameParam;
    private ActivationParameterDescriptor m_dumpArgumentsParam;
    private Logger m_logger = LoggerFactory.getFrameworkLogger();
    private NamedThreadFactory m_dumpExectorThreadFactory = new NamedThreadFactory("oracle.dfw.dump.DumpManager - Dump Executor");
    private ApplicationContext m_appContext;
    private static final String CLASS_NAME = DumpManagerImpl.class.getName();
    private static final int DEFAULT_TIMEOUT = 900000;
    private static final char KEY_TOKEN = '%';

    private DumpManagerImpl() {
        this.m_sysDumps = new HashMap<String, WeakReferenceWithKey<String, DiagnosticDump>>();
        this.m_sysRefQueue = new ReferenceQueue();
        this.m_appDumps = Collections.synchronizedMap(new HashMap());
        this.m_appRefQueue = new ReferenceQueue();
        this.m_executeTimePhaseEvents = new HashMap();
    }

    @Override
    public void registerDump(DiagnosticDump dump, boolean systemScope, String appName) {
        if (dump == null) {
            return;
        }
        String dumpName = dump.getFullDumpName();
        if (systemScope) {
            this.m_sysDumps.put(dumpName, new WeakReferenceWithKey<String, DiagnosticDump>(dumpName, dump, this.m_sysRefQueue));
        } else {
            if (appName == null) {
                appName = this.getApplicationName();
            }
            if (appName != null) {
                Map<String, WeakReferenceWithKey<String, DiagnosticDump>> dumps = this.m_appDumps.get(appName);
                if (dumps == null) {
                    dumps = Collections.synchronizedMap(new HashMap());
                    this.m_appDumps.put(appName, dumps);
                }
                dumps.put(dumpName, new WeakReferenceWithKey<String, DiagnosticDump>(appName + '%' + dumpName, dump, this.m_appRefQueue));
            } else {
                this.m_sysDumps.put(dumpName, new WeakReferenceWithKey<String, DiagnosticDump>(dumpName, dump, this.m_sysRefQueue));
            }
        }
        if (appName == null) {
            this.m_logger.log(Level.FINE, "DFW-40000", dumpName);
        } else {
            this.m_logger.log(Level.FINE, "DFW-40001", new Object[]{dumpName, appName});
        }
        Noun dumpNoun = Noun.create("/oracle/dfw/dump/" + dumpName, "DFW_Dump");
        ActivationParameterFactory apf = DMSConsole.getActivationParameterFactory();
        this.m_appNameParam = apf.createDescriptor("oracle.dfw.appName", DiagnosticTranslation.class, null, null, Integer.MIN_VALUE);
        this.m_dumpArgumentsParam = apf.createDescriptor("oracle.dfw.dumpArguments", DiagnosticTranslation.class, null, null, Integer.MAX_VALUE);
        dumpNoun.getDescriptor().setActivationParameterDescriptors(this.m_appNameParam, this.m_dumpArgumentsParam);
        State appScopedState = State.create(dumpNoun, "appScoped", (byte)5, "", "Indicates whether the dump is scoped to an application");
        appScopedState.update(Boolean.valueOf(appName != null).toString());
        State appNameState = State.create(dumpNoun, "appName", (byte)5, "", "Name of the application if the dump is application scoped");
        if (appName != null) {
            appNameState.update(appName);
        }
        PhaseEvent dumpExecuteTime = PhaseEvent.create(dumpNoun, "executeTime", "Time to execute the dump");
        dumpExecuteTime.deriveMetric(511);
        this.m_executeTimePhaseEvents.put(dumpName + appName, dumpExecuteTime);
        DiagnosticsEventManager.notifyListeners(new DumpRegistrationEvent(dump));
    }

    @Override
    public void unregisterDump(String dumpName, boolean systemScope, String appName) {
        if (dumpName != null) {
            if (systemScope) {
                this.m_sysDumps.remove(dumpName);
            } else {
                Map<String, WeakReferenceWithKey<String, DiagnosticDump>> dumps;
                if (appName == null) {
                    appName = this.getApplicationName();
                }
                if (appName != null && (dumps = this.m_appDumps.get(appName)) != null) {
                    dumps.remove(dumpName);
                    if (dumps.size() == 0) {
                        this.m_appDumps.remove(appName);
                    }
                }
            }
        }
    }

    @Override
    public DiagnosticDump getDump(String dumpName, boolean systemScope, String appName) {
        this.purgeMaps();
        DiagnosticDump returnDump = null;
        if (dumpName != null) {
            if (systemScope) {
                WeakReferenceWithKey<String, DiagnosticDump> weakDump = this.m_sysDumps.get(dumpName);
                if (weakDump != null) {
                    returnDump = (DiagnosticDump)weakDump.get();
                }
            } else {
                WeakReferenceWithKey<String, DiagnosticDump> weakDump;
                Map<String, WeakReferenceWithKey<String, DiagnosticDump>> dumps;
                if (appName == null) {
                    appName = this.getApplicationName();
                }
                if (appName != null && (dumps = this.m_appDumps.get(appName)) != null && (weakDump = dumps.get(dumpName)) != null) {
                    returnDump = (DiagnosticDump)weakDump.get();
                }
            }
        }
        return returnDump;
    }

    @Override
    public Set<DiagnosticDump> getSystemDumps() {
        this.purgeMaps();
        TreeSet<DiagnosticDump> dumps = new TreeSet<DiagnosticDump>();
        for (WeakReferenceWithKey<String, DiagnosticDump> weakDump : this.m_sysDumps.values()) {
            DiagnosticDump dump = (DiagnosticDump)weakDump.get();
            if (dump == null) continue;
            dumps.add(dump);
        }
        return dumps;
    }

    @Override
    public Set<DiagnosticDump> getApplicationDumps(String appName) {
        Map<String, WeakReferenceWithKey<String, DiagnosticDump>> weakDumps;
        this.purgeMaps();
        if (appName == null) {
            appName = this.getApplicationName();
        }
        if (appName != null && (weakDumps = this.m_appDumps.get(appName)) != null) {
            TreeSet<DiagnosticDump> dumps = new TreeSet<DiagnosticDump>();
            for (WeakReferenceWithKey<String, DiagnosticDump> weakDump : weakDumps.values()) {
                DiagnosticDump dump = (DiagnosticDump)weakDump.get();
                if (dump == null) continue;
                dumps.add(dump);
            }
            return dumps;
        }
        return Collections.emptySet();
    }

    @Override
    public Map<String, Map<String, DiagnosticDump>> getApplicationDumps() {
        this.purgeMaps();
        HashMap<String, Map<String, DiagnosticDump>> appDumps = new HashMap<String, Map<String, DiagnosticDump>>();
        for (String appName : this.m_appDumps.keySet()) {
            Map<String, WeakReferenceWithKey<String, DiagnosticDump>> dumps = this.m_appDumps.get(appName);
            if (dumps == null) continue;
            HashMap<String, DiagnosticDump> dumpsForApp = new HashMap<String, DiagnosticDump>();
            for (WeakReferenceWithKey<String, DiagnosticDump> weakDump : dumps.values()) {
                DiagnosticDump dump = (DiagnosticDump)weakDump.get();
                if (dump == null) continue;
                dumpsForApp.put(weakDump.getKey(), dump);
            }
            appDumps.put(appName, dumpsForApp);
        }
        return appDumps;
    }

    @Override
    public boolean isDumpRegistered(String dumpName, boolean systemScope, String appName) {
        this.purgeMaps();
        if (dumpName != null) {
            Map<String, WeakReferenceWithKey<String, DiagnosticDump>> dumps;
            if (systemScope) {
                return this.m_sysDumps.containsKey(dumpName);
            }
            if (appName == null) {
                appName = this.getApplicationName();
            }
            if (appName != null && (dumps = this.m_appDumps.get(appName)) != null) {
                return dumps.containsKey(dumpName);
            }
        }
        return false;
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, InvalidDumpContextException {
        return this.executeDump(context, null, false, true);
    }

    public DumpResult executeDump(DumpContext context, DiagnosticDump dump, boolean runSync, boolean runDumpClassloader) throws DumpExecutionException, InvalidDumpContextException {
        DumpResult result;
        block27: {
            ExecutorService fexec;
            String dumpName = context.getDumpName();
            String appName = null;
            if (dump == null) {
                if (context.isAppScoped()) {
                    appName = context.getAppName();
                    if (appName == null) {
                        appName = this.getApplicationName();
                    }
                    if (appName != null) {
                        dump = this.getDump(dumpName, false, appName);
                    }
                } else {
                    dump = this.getDump(dumpName, true, null);
                }
                if (dump == null) {
                    throw new InvalidDumpContextException("DFW-40004", dumpName);
                }
            }
            dump.validateDumpContext(context);
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "executeDump", "DFW-40003", context.toString());
            }
            PhaseEvent executeTimePE = this.m_executeTimePhaseEvents.get(dumpName + appName);
            PhaseEventActivationToken startToken = null;
            result = null;
            if (runSync) {
                ClassLoader oldCtxCL = null;
                try {
                    if (runDumpClassloader && dump instanceof ComponentDiagnosticDump) {
                        oldCtxCL = AccessCheck.getContextClassLoader();
                        ClassLoader dumpCL = ((ComponentDiagnosticDump)dump).m_savedThreadContextLoader.get();
                        if (oldCtxCL != null && dumpCL != null && oldCtxCL != dumpCL) {
                            AccessCheck.setContextClassLoader(dumpCL);
                        } else {
                            oldCtxCL = null;
                        }
                    }
                    startToken = this.startDumpTimer(executeTimePE, context);
                    result = dump.executeDump(context);
                }
                catch (DumpExecutionException e) {
                    throw e;
                }
                catch (Throwable t) {
                    DumpExecutionException exception = new DumpExecutionException("DFW-40008", t);
                    exception.addToken(dumpName);
                    throw exception;
                }
                finally {
                    if (result != null && startToken != null) {
                        executeTimePE.stop(startToken);
                    } else if (startToken != null) {
                        executeTimePE.abort(startToken);
                    }
                    if (oldCtxCL != null) {
                        AccessCheck.setContextClassLoader(oldCtxCL);
                    }
                }
            }
            ExecutorService exec = null;
            try {
                exec = Executors.newSingleThreadExecutor(this.m_dumpExectorThreadFactory);
                Future<DumpResult> fres = exec.submit(new DumpExecutor(context, dump, executeTimePE, runDumpClassloader));
                result = fres.get(900000L, TimeUnit.MILLISECONDS);
                if (exec == null || exec.isShutdown()) break block27;
                fexec = exec;
            }
            catch (Throwable e) {
                try {
                    if (e instanceof ExecutionException && e.getCause() != null && e.getCause() instanceof DumpExecutionException) {
                        throw (DumpExecutionException)e.getCause();
                    }
                    DumpExecutionException exception = new DumpExecutionException("DFW-40008", e);
                    exception.addToken(dumpName);
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (exec != null && !exec.isShutdown()) {
                        ExecutorService fexec2 = exec;
                        AccessController.doPrivileged(new PrivilegedAction(fexec2){
                            final /* synthetic */ ExecutorService val$fexec;
                            {
                                this.val$fexec = executorService;
                            }

                            public Object run() {
                                this.val$fexec.shutdownNow();
                                return null;
                            }
                        });
                    }
                    throw throwable;
                }
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        return result;
    }

    private synchronized void purgeMaps() {
        WeakReferenceWithKey refWithKey;
        Reference<WeakReferenceWithKey<String, DiagnosticDump>> ref = null;
        while ((ref = this.m_sysRefQueue.poll()) != null) {
            refWithKey = (WeakReferenceWithKey)ref;
            this.m_sysDumps.remove(refWithKey.getKey());
        }
        while ((ref = this.m_appRefQueue.poll()) != null) {
            String appName;
            Map<String, WeakReferenceWithKey<String, DiagnosticDump>> dumps;
            refWithKey = (WeakReferenceWithKey)ref;
            String key = (String)refWithKey.getKey();
            int tokenPos = key.indexOf(37);
            if (tokenPos <= 0 || tokenPos == key.length() - 1 || (dumps = this.m_appDumps.get(appName = key.substring(0, tokenPos))) == null) continue;
            dumps.remove(key.substring(tokenPos + 1));
        }
    }

    public void setApplicationConext(ApplicationContext appContext) {
        this.m_appContext = appContext;
    }

    private String getApplicationName() {
        return this.m_appContext != null ? this.m_appContext.getApplicationName() : null;
    }

    private PhaseEventActivationToken startDumpTimer(PhaseEvent dumpTimer, DumpContext context) {
        PhaseEventActivationToken token = null;
        if (dumpTimer != null) {
            ActivationParameter appNameParam = this.m_appNameParam.createParameter(context.getAppName());
            ActivationParameter dumpArgumentsParam = this.m_dumpArgumentsParam.createParameter(context.toString());
            token = dumpTimer.start(appNameParam, dumpArgumentsParam);
        }
        return token;
    }

    public static DumpManagerImpl getInstance() {
        return INSTANCE;
    }

    private class DumpExecutor
    implements Callable<DumpResult> {
        private DumpContext m_context;
        private DiagnosticDump m_dump;
        private PhaseEvent m_executeTimePE;
        private boolean m_runDumpClassloader;

        DumpExecutor(DumpContext context, DiagnosticDump dump, PhaseEvent executeTimePE, boolean runDumpClassloader) {
            this.m_context = context;
            this.m_dump = dump;
            this.m_executeTimePE = executeTimePE;
            this.m_runDumpClassloader = runDumpClassloader;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public DumpResult call() throws DumpExecutionException {
            PhaseEventActivationToken startToken = null;
            DumpResult result = null;
            ClassLoader oldCtxCL = null;
            try {
                if (this.m_runDumpClassloader && this.m_dump instanceof ComponentDiagnosticDump) {
                    oldCtxCL = AccessCheck.getContextClassLoader();
                    ClassLoader dumpCL = ((ComponentDiagnosticDump)this.m_dump).m_savedThreadContextLoader.get();
                    if (oldCtxCL != null && dumpCL != null && oldCtxCL != dumpCL) {
                        AccessCheck.setContextClassLoader(dumpCL);
                    } else {
                        oldCtxCL = null;
                    }
                }
                startToken = DumpManagerImpl.this.startDumpTimer(this.m_executeTimePE, this.m_context);
                result = this.m_dump.executeDump(this.m_context);
                if (result != null && startToken != null) {
                    this.m_executeTimePE.stop(startToken);
                } else if (startToken != null) {
                    this.m_executeTimePE.abort(startToken);
                }
                if (oldCtxCL == null) return result;
            }
            catch (DumpExecutionException e) {
                try {
                    throw e;
                    catch (Throwable t) {
                        DumpExecutionException exception = new DumpExecutionException("DFW-40008", t);
                        exception.addToken(this.m_dump.getFullDumpName());
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    if (result != null && startToken != null) {
                        this.m_executeTimePE.stop(startToken);
                    } else if (startToken != null) {
                        this.m_executeTimePE.abort(startToken);
                    }
                    if (oldCtxCL == null) throw throwable;
                    AccessCheck.setContextClassLoader(oldCtxCL);
                    throw throwable;
                }
            }
            AccessCheck.setContextClassLoader(oldCtxCL);
            return result;
        }
    }
}

