/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.jmx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.as.jmx.framework.annotations.Inject;
import oracle.as.jmx.framework.services.JMXSupport;
import oracle.as.management.exception.ASException;
import oracle.as.management.streaming.Streamer;
import oracle.dfw.common.DiagnosticsException;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpManager;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.impl.common.TempFileManager;
import oracle.dfw.impl.dump.DumpManagerImpl;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.IncidentManager;
import oracle.dfw.jmx.DiagnosticDumpInfo;
import oracle.dfw.jmx.DumpManagerMXBean;

public class JMXDumpManager
implements DumpManagerMXBean {
    private DumpManagerImpl m_dumpManager;
    private IncidentManager m_incidentManager;
    private JMXSupport m_jmxSupport;
    private static final String[] STRING_ARRAY = new String[0];
    private static final int IOBUFFERSIZE = 65536;
    private static final String[] ASCII_EXT = new String[]{".txt", ".html", ".dmp", ".log", ".xml"};

    public JMXDumpManager(DumpManager dumpManager, IncidentManager incidentManager) {
        this.m_dumpManager = (DumpManagerImpl)dumpManager;
        this.m_incidentManager = incidentManager;
    }

    @Inject
    public void setJMXSupport(JMXSupport jmxSupport) throws Exception {
        this.m_jmxSupport = jmxSupport;
    }

    @Override
    public String getTemporaryDumpPath() throws IOException {
        return TempFileManager.getTemporaryDirectory().getAbsolutePath();
    }

    @Override
    public List<DiagnosticDumpInfo> getSystemDumps() {
        ArrayList<DiagnosticDumpInfo> dumps = new ArrayList<DiagnosticDumpInfo>();
        for (DiagnosticDump dump : this.m_dumpManager.getSystemDumps()) {
            dumps.add(new DiagnosticDumpInfo(dump, this.m_jmxSupport.getLocale()));
        }
        this.sortDumps(dumps);
        return dumps;
    }

    @Override
    public List<DiagnosticDumpInfo> getApplicationDumps(String appName) {
        ArrayList<DiagnosticDumpInfo> dumps = new ArrayList<DiagnosticDumpInfo>();
        for (DiagnosticDump dump : this.m_dumpManager.getApplicationDumps(appName)) {
            dumps.add(new DiagnosticDumpInfo(dump, this.m_jmxSupport.getLocale()));
        }
        this.sortDumps(dumps);
        return dumps;
    }

    private void sortDumps(List<DiagnosticDumpInfo> dumps) {
        Collections.sort(dumps, new Comparator<DiagnosticDumpInfo>(){

            @Override
            public int compare(DiagnosticDumpInfo dump1, DiagnosticDumpInfo dump2) {
                return dump1.getName().compareTo(dump2.getName());
            }
        });
    }

    @Override
    public List<String> executeDump(String dumpName, String appName, Map<String, String> dumpArgs) throws Exception {
        this.validateDumpMode(dumpName, appName);
        DumpResult result = null;
        try {
            DumpContext dc = DumpContext.createDumpContext(dumpName);
            if (appName != null && appName.length() > 0) {
                dc.setAppScoped(appName);
            }
            if (dumpArgs != null) {
                for (Map.Entry<String, String> arg : dumpArgs.entrySet()) {
                    dc.addArgument(arg.getKey(), (Serializable)((Object)arg.getValue()));
                }
            }
            result = this.m_dumpManager.executeDump(dc, null, true, true);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
        return result != null ? result.getDumpFiles() : null;
    }

    @Override
    public List<String> executeDump(String dumpName, String appName, Map<String, String> dumpArgs, String incidentId) throws Exception {
        return this.executeDump(dumpName, appName, dumpArgs, null, incidentId);
    }

    @Override
    public List<String> executeDump(String dumpName, String appName, Map<String, String> dumpArgs, String ADRHome, String incidentId) throws Exception {
        this.validateDumpMode(dumpName, appName);
        if (this.m_incidentManager == null) {
            throw new Exception("incident manager is unavailable; dump output cannot be added to incident");
        }
        if (ADRHome == null) {
            ADRHome = this.m_incidentManager.getADRHome();
        }
        Incident incident = null;
        try {
            incident = this.m_incidentManager.getIncident(ADRHome, incidentId);
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
        if (incident == null) {
            DiagnosticsException de = new DiagnosticsException("DFW-40122", incidentId);
            throw ASException.toException(de, Exception.class);
        }
        DumpResult result = null;
        try {
            List<String> files;
            IncidentFacts facts = IncidentFacts.createManualIncidentFacts(System.currentTimeMillis());
            DumpContext dc = DumpContext.createDumpContext(dumpName, ADRHome, incidentId, incident.getIncidentDirectory(), facts);
            if (appName != null && appName.length() > 0) {
                dc.setAppScoped(appName);
            }
            if (dumpArgs != null) {
                for (Map.Entry<String, String> arg : dumpArgs.entrySet()) {
                    dc.addArgument(arg.getKey(), (Serializable)((Object)arg.getValue()));
                }
            }
            if ((result = this.m_dumpManager.executeDump(dc, null, true, true)) != null && (files = result.getDumpFiles()) != null && files.size() > 0) {
                this.m_incidentManager.addIncidentFileWithADRHome(ADRHome, incidentId, files.toArray(STRING_ARRAY));
            }
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
        ArrayList<String> fileList = null;
        if (result != null && result.getDumpFiles() != null) {
            String directory = incident.getIncidentDirectory();
            directory = directory.replace(this.m_incidentManager.getADRBase() + File.separatorChar, "");
            fileList = new ArrayList<String>(result.getDumpFiles().size());
            for (String file : result.getDumpFiles()) {
                fileList.add(directory + File.separatorChar + file);
            }
        }
        return fileList;
    }

    @Override
    public String getDumpContents(String filename) throws Exception {
        String[] filenames = new String[]{filename};
        return this.getDumpContents(filenames, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDumpContents(String[] filenames, boolean zipOutput) throws Exception {
        FileOutputStream fos = null;
        ZipOutputStream zout = null;
        OutputStreamWriter owrt = null;
        byte[] buffer = new byte[65536];
        boolean isIncidentFiles = this.validateDumpFiles(filenames);
        File directory = TempFileManager.getTemporaryDirectory();
        if (isIncidentFiles) {
            directory = new File(this.m_incidentManager.getADRBase());
        }
        if (filenames.length == 1 && !zipOutput) {
            String dumpFilename = filenames[0];
            File dumpFile = new File(directory, dumpFilename);
            FileInputStream resultantStream = JMXDumpManager.getFileInputStream(dumpFile);
            return Streamer.addInputStream(resultantStream);
        }
        File resultantFile = TempFileManager.createTempFile("ToBeDisposedDumpContents", zipOutput ? ".zip" : ".txt");
        resultantFile.deleteOnExit();
        fos = JMXDumpManager.getFileOutputStream(resultantFile);
        if (zipOutput) {
            zout = new ZipOutputStream(fos);
        } else {
            owrt = new OutputStreamWriter(fos);
        }
        try {
            for (String filename : filenames) {
                boolean textFormat = false;
                if (!zipOutput && !(textFormat = this.isTextFormat(filename)) && filenames.length > 1) {
                    throw new IllegalArgumentException("Cannot append Non-ASCII format file: " + filename);
                }
                File dumpFile = new File(directory, filename);
                FileInputStream fis = JMXDumpManager.getFileInputStream(dumpFile);
                int len = 0;
                if (zipOutput) {
                    ZipEntry ze = new ZipEntry(dumpFile.getName());
                    ze.setTime(dumpFile.lastModified());
                    zout.putNextEntry(ze);
                    do {
                        if ((len = fis.read(buffer)) <= 0) continue;
                        zout.write(buffer, 0, len);
                    } while (len > 0);
                } else {
                    if (textFormat) {
                        owrt.write(filename);
                        owrt.write("\n");
                    }
                    do {
                        if ((len = fis.read(buffer)) <= 0) continue;
                        fos.write(buffer, 0, len);
                    } while (len > 0);
                    if (textFormat) {
                        owrt.write("\n");
                    }
                }
                fis.close();
                fos.flush();
            }
        }
        finally {
            try {
                if (zout != null) {
                    zout.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioex) {
                fos = null;
            }
        }
        FileInputStream resultantStream = JMXDumpManager.getFileInputStream(resultantFile);
        return Streamer.addInputStream(resultantStream);
    }

    private boolean validateDumpFiles(String[] filenames) {
        if (filenames == null || filenames.length == 0) {
            throw new IllegalArgumentException("Filename not specified");
        }
        boolean hasIncidentFiles = false;
        for (String filename : filenames) {
            if ((filename.startsWith(".") || filename.contains("/") || filename.contains("\\") || filename.contains(":")) && !filename.startsWith("diag/") && !filename.startsWith("diag\\")) {
                throw new IllegalArgumentException("Invalid arguments; filename=" + filename);
            }
            if (!filename.startsWith("diag/") && !filename.startsWith("diag\\")) continue;
            hasIncidentFiles = true;
        }
        return hasIncidentFiles;
    }

    private boolean isTextFormat(String filename) {
        boolean result = false;
        int pos = filename.lastIndexOf(".");
        if (pos >= 0) {
            String extension = filename.substring(pos, filename.length());
            for (String ext : ASCII_EXT) {
                if (!extension.equalsIgnoreCase(ext)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static FileOutputStream getFileOutputStream(final File file) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static FileInputStream getFileInputStream(final File file) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private void validateDumpMode(String dumpName, String appName) throws Exception {
        DiagnosticDump dump;
        if (dumpName == null) {
            return;
        }
        boolean sysScoped = true;
        if (appName != null && appName.length() > 0) {
            sysScoped = false;
        }
        if ((dump = this.m_dumpManager.getDump(dumpName, sysScoped, appName)) != null && dump.getRunMode() == DiagnosticDump.DumpRunMode.SYNCHRONOUS) {
            DiagnosticsException de = new DiagnosticsException("DFW-40011", dumpName);
            throw ASException.toException(de, Exception.class);
        }
    }
}

