/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.common;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DFWUtils {
    private static final int MAX_PROD_INST_LENGTH = 30;

    public static String getADRProductId(String value) {
        String os;
        if (value == null) {
            return null;
        }
        String productId = value;
        if (productId.length() > 30) {
            productId = productId.substring(0, 30);
        }
        if ((os = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        })) != null && os.startsWith("Windows")) {
            productId = productId.toLowerCase();
        }
        productId = productId.replace('$', '_');
        return productId.replace(' ', '_');
    }

    public static String getADRInstanceId(String value) {
        String os;
        if (value == null) {
            return null;
        }
        String productId = value;
        if (productId.length() > 30) {
            productId = productId.substring(0, 30);
        }
        if ((os = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        })) != null && os.startsWith("Windows")) {
            productId = productId.toLowerCase();
        }
        productId = productId.replace('$', '_');
        return productId.replace(' ', '_');
    }

    public static String getADRHome(String productType, String productId, String instanceId) {
        if (productType == null || productType.length() == 0 || productId == null || productId.length() == 0 || instanceId == null || instanceId.length() == 0) {
            throw new IllegalArgumentException("invalid parameters to getADRHome. productType=" + productType + " productId=" + productId + " instanceId=" + instanceId);
        }
        productId = DFWUtils.getADRProductId(productId);
        instanceId = DFWUtils.getADRInstanceId(instanceId);
        StringBuilder ADRHome = new StringBuilder();
        ADRHome.append("diag");
        ADRHome.append(File.separatorChar);
        ADRHome.append(productType);
        ADRHome.append(File.separatorChar);
        ADRHome.append(productId);
        ADRHome.append(File.separatorChar);
        ADRHome.append(instanceId);
        return ADRHome.toString();
    }
}

