/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.spy.ErrorObject;
import oracle.dms.table.NullValue;

public abstract class NetUtil {
    private static final Logger LOGGER;
    private static final HashSet<InetAddress> LOCAL_IP_SET;

    private static Enumeration<InetAddress> _getInetAddresses(final NetworkInterface net) {
        Enumeration<InetAddress> ips = AccessController.doPrivileged(new PrivilegedAction<Enumeration<InetAddress>>(){

            @Override
            public Enumeration<InetAddress> run() {
                return net.getInetAddresses();
            }
        });
        return ips;
    }

    public static String addSoftBreak(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int len = text.length();
        int count = 0;
        int max = 32;
        boolean isOthers = false;
        for (int i = 0; i < len; ++i) {
            char car = text.charAt(i);
            if (Character.isLetterOrDigit(car)) {
                if (isOthers) {
                    isOthers = false;
                    count = 0;
                    buf.append("<wbr>");
                }
                buf.append(car);
                if (++count < max) continue;
                buf.append("<wbr>");
                count = 0;
                continue;
            }
            if (Character.isWhitespace(car) || Character.isISOControl(car)) {
                buf.append(car);
                count = 0;
                isOthers = false;
                continue;
            }
            if (car == '&') {
                while (i < len && (car = text.charAt(i)) != ';') {
                    buf.append(car);
                    ++i;
                }
                if (i == len) {
                    break;
                }
            } else if (car == '<') {
                while (i < len && (car = text.charAt(i)) != '>') {
                    buf.append(car);
                    ++i;
                }
                if (i == len) break;
            }
            buf.append(car);
            if (++count >= max) {
                buf.append("<wbr>");
                count = 0;
                isOthers = false;
                continue;
            }
            isOthers = true;
        }
        return buf.toString();
    }

    public static boolean isSameHost(final String host1, String host2) {
        if (host1 == null || host2 == null) {
            return false;
        }
        if (host1.equalsIgnoreCase(host2)) {
            return true;
        }
        InetAddress[] host1Addrs = null;
        try {
            host1Addrs = AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress[]>(){

                @Override
                public InetAddress[] run() throws UnknownHostException {
                    return InetAddress.getAllByName(host1);
                }
            });
        }
        catch (PrivilegedActionException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        if (host1Addrs == null) {
            return false;
        }
        return NetUtil.isSameHost(host1Addrs, host2);
    }

    public static boolean isSameHost(InetAddress[] host1Addrs, final String host2) {
        if (host1Addrs == null || host2 == null) {
            return false;
        }
        InetAddress[] host2Addrs = null;
        try {
            host2Addrs = AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress[]>(){

                @Override
                public InetAddress[] run() throws UnknownHostException {
                    return InetAddress.getAllByName(host2);
                }
            });
        }
        catch (PrivilegedActionException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        if (host2Addrs == null) {
            return false;
        }
        return NetUtil.isSameHost(host1Addrs, host2Addrs);
    }

    public static boolean isSameHost(InetAddress[] host1Addrs, InetAddress[] host2Addrs) {
        if (host1Addrs == null || host2Addrs == null) {
            return false;
        }
        for (int i = 0; i < host1Addrs.length; ++i) {
            if (host1Addrs[i] == null) continue;
            for (int j = 0; j < host2Addrs.length; ++j) {
                if (!host1Addrs[i].equals(host2Addrs[j]) || host2Addrs[j] == null) continue;
                return true;
            }
        }
        boolean isLocal1 = false;
        for (int i = 0; i < host1Addrs.length; ++i) {
            if (host1Addrs[i] == null || !LOCAL_IP_SET.contains(host1Addrs[i])) continue;
            isLocal1 = true;
            break;
        }
        if (!isLocal1) {
            return false;
        }
        boolean isLocal2 = false;
        for (int i = 0; i < host2Addrs.length; ++i) {
            if (host2Addrs[i] == null || !LOCAL_IP_SET.contains(host2Addrs[i])) continue;
            isLocal2 = true;
            break;
        }
        return isLocal1 && isLocal2;
    }

    public static boolean isLocalAddress(final String host) {
        if (host == null || host.trim().length() == 0) {
            return false;
        }
        InetAddress[] hosts = null;
        try {
            hosts = AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress[]>(){

                @Override
                public InetAddress[] run() throws UnknownHostException {
                    return InetAddress.getAllByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        if (hosts == null) {
            return false;
        }
        for (int i = 0; i < hosts.length; ++i) {
            if (!NetUtil.isLocalAddress(hosts[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isLocalAddress(InetAddress host) {
        if (host == null) {
            return false;
        }
        if (host.isLoopbackAddress()) {
            return true;
        }
        return LOCAL_IP_SET.contains(host);
    }

    private static String _replaceAll(String string, String from, String to) {
        if (string == null || string.trim().length() == 0 || from == null || from.trim().length() == 0 || to == null) {
            return string;
        }
        int fromlength = from.length();
        int index = -1;
        int pos = 0;
        StringBuilder buf = null;
        while ((index = string.indexOf(from, pos)) != -1) {
            if (buf == null) {
                buf = new StringBuilder(string.length());
            }
            buf.append(string.substring(pos, index));
            buf.append(to);
            pos = index + fromlength;
        }
        if (buf == null) {
            return string;
        }
        buf.append(string.substring(pos));
        return buf.toString();
    }

    public static String replaceVariableInPath(String string, String variableSign, String variableValue) {
        if (variableValue == null) {
            return string;
        }
        if (variableValue.endsWith(File.separator)) {
            string = NetUtil._replaceAll(string, variableSign + File.separatorChar, variableValue);
        }
        string = NetUtil._replaceAll(string, variableSign, variableValue);
        return string;
    }

    public static Long cast2Long(Serializable value) throws NumberFormatException {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Float || value instanceof Double) {
            return Math.round(((Number)value).doubleValue());
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.valueOf(value.toString());
    }

    public static Integer cast2Integer(Serializable value) throws NumberFormatException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Float || value instanceof Double) {
            return Math.round(((Number)value).floatValue());
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static Double cast2Double(Serializable value) throws NumberFormatException {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        return new Double(value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSize(Map<String, ?> map) {
        if (map == null) {
            return 0;
        }
        int size = 0;
        Map<String, ?> map2 = map;
        synchronized (map2) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                size += key.length();
                size += NetUtil.getSize(value);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSize(Collection<?> values) {
        if (values == null) {
            return 0;
        }
        int size = 0;
        Collection<?> collection = values;
        synchronized (collection) {
            for (Object value : values) {
                size += NetUtil.getSize(value);
            }
        }
        return size;
    }

    private static int getSize(Object value) {
        if (value == null) {
            return 0;
        }
        if (value == null || value instanceof NullValue || value instanceof ErrorObject) {
            return 0;
        }
        if (value instanceof Integer || value instanceof Float) {
            return 4;
        }
        if (value instanceof Long || value instanceof Double) {
            return 8;
        }
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (value instanceof Short || value instanceof Character) {
            return 2;
        }
        return value.toString().length();
    }

    private NetUtil() {
    }

    static {
        block4: {
            LOGGER = Logger.getLogger("oracle.dms.util", "oracle.dms.util.dms");
            LOCAL_IP_SET = new HashSet();
            try {
                Enumeration<NetworkInterface> enum1 = NetworkInterface.getNetworkInterfaces();
                while (enum1.hasMoreElements()) {
                    NetworkInterface net = enum1.nextElement();
                    Enumeration<InetAddress> enum2 = NetUtil._getInetAddresses(net);
                    while (enum2.hasMoreElements()) {
                        LOCAL_IP_SET.add(enum2.nextElement());
                    }
                }
            }
            catch (SocketException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block4;
                LOGGER.logp(Level.FINE, NetUtil.class.getName(), NetUtil.class.getName(), "Error in looking up IP addresses");
            }
        }
    }
}

