/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dms.http.Request;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounRefresh;
import oracle.dms.reporter.BranchTreeletNode;
import oracle.dms.reporter.DMSTreeletGenerator;
import oracle.dms.reporter.LeafTreeletNode;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.TreeletGenerator;
import oracle.dms.reporter.TreeletOptions;

abstract class TreeletReporter
extends Reporter {
    protected TreeletOptions m_treeletOptions = new TreeletOptions();
    private List<TreeletGenerator> m_treeletGenerators = new ArrayList<TreeletGenerator>();
    private static final Set<String> EMPTY_SET = Collections.emptySet();

    TreeletReporter(Request request) {
        super(request);
        if (this.m_request.includeDescendents("children")) {
            this.m_treeletOptions.setincludeDescendant(TreeletOptions.IncludeDescendant.CHILDREN);
        } else if (this.m_request.includeDescendents("none")) {
            this.m_treeletOptions.setincludeDescendant(TreeletOptions.IncludeDescendant.NO_DESCENDANTS);
        } else if (this.m_request.includeDescendents("all")) {
            this.m_treeletOptions.setincludeDescendant(TreeletOptions.IncludeDescendant.ALL_DESCENDANTS);
        } else if (this.m_op == 3) {
            this.m_treeletOptions.setincludeDescendant(TreeletOptions.IncludeDescendant.ALL_DESCENDANTS);
        } else if (this.m_op == 1) {
            this.m_treeletOptions.setincludeDescendant(TreeletOptions.IncludeDescendant.CHILDREN);
        } else {
            this.m_treeletOptions.setincludeDescendant(TreeletOptions.IncludeDescendant.NO_DESCENDANTS);
        }
        this.registerTreeletGenerator(new DMSTreeletGenerator());
    }

    public void registerTreeletGenerator(TreeletGenerator treeletGenerator) {
        if (treeletGenerator != null) {
            this.m_treeletGenerators.add(treeletGenerator);
        }
    }

    public void unregisterTreeletGenerator(TreeletGenerator treeletGenerator) {
        if (treeletGenerator != null) {
            this.m_treeletGenerators.remove(treeletGenerator);
        }
    }

    @Override
    public final void printResponse(PrintWriter out) {
        if (this.m_op == 1 || this.m_op == 2) {
            this.m_treeletOptions.setMetrics(true);
            this.printResetResponse(out);
        } else {
            this.m_treeletOptions.setIncludeDescriptions(this.m_request.includeDescription());
            this.m_treeletOptions.setIncludeUnits(this.m_request.includeUnits());
            this.m_treeletOptions.setIncludeValues(this.m_request.includeValues());
            this.printGetResponse(out);
        }
    }

    @Override
    public void clear() {
        for (TreeletGenerator treeletGenerator : this.m_treeletGenerators) {
            treeletGenerator.clear();
        }
        this.m_treeletGenerators.clear();
    }

    void startWalkTree(PrintWriter out) {
        out.print("<statistics><![CDATA[\n");
    }

    void endWalkTree(PrintWriter out) {
        out.print("]]></statistics>\n");
    }

    abstract void printHeading(PrintWriter var1);

    abstract void printEnding(PrintWriter var1);

    abstract void startPrintBranchNode(BranchTreeletNode var1, PrintWriter var2);

    abstract void endPrintBranchNode(BranchTreeletNode var1, PrintWriter var2);

    abstract void printLeafNode(LeafTreeletNode var1, PrintWriter var2);

    void printGetResponse(PrintWriter out) {
        String[] names;
        HashSet<String> badNames = new HashSet<String>();
        HashSet<String> badTables = new HashSet<String>();
        String[] tables = this.m_request.getTables();
        if (tables != null && tables.length > 0) {
            badTables.addAll(Arrays.asList(tables));
        }
        if ((names = this.m_request.getNames()) != null && names.length > 0) {
            badNames.addAll(Arrays.asList(names));
        }
        this._refreshNoun();
        this.printHeading(out);
        this.startWalkTree(out);
        for (TreeletGenerator treeletGenerator : this.m_treeletGenerators) {
            HashSet<String> localBadNames = new HashSet<String>();
            HashSet<String> localBadTables = new HashSet<String>();
            treeletGenerator.init(this.m_treeletOptions);
            treeletGenerator.getTreeletNodes(tables, names, localBadNames, localBadTables);
            if (this.m_treeletOptions.includeValues()) {
                treeletGenerator.queryMetricValues();
            }
            this._walk(treeletGenerator.getRoot(), treeletGenerator.getRoot(), out);
            Iterator<String> iter = badNames.iterator();
            while (iter.hasNext()) {
                String badName = iter.next();
                if (localBadNames.contains(badName)) continue;
                iter.remove();
            }
            iter = badTables.iterator();
            while (iter.hasNext()) {
                String badTable = iter.next();
                if (localBadTables.contains(badTable)) continue;
                iter.remove();
            }
        }
        this.endWalkTree(out);
        this.printBadParams(badNames, badTables, out);
        this.printEnding(out);
        badNames.clear();
        badTables.clear();
    }

    private void printResetResponse(PrintWriter out) {
        String[] names;
        HashSet<String> badNames = new HashSet<String>();
        HashSet<String> badTables = new HashSet<String>();
        String[] tables = this.m_request.getTables();
        if (tables != null && tables.length > 0) {
            badTables.addAll(Arrays.asList(tables));
        }
        if ((names = this.m_request.getNames()) != null && names.length > 0) {
            badNames.addAll(Arrays.asList(names));
        }
        this.printHeading(out);
        for (TreeletGenerator treeletGenerator : this.m_treeletGenerators) {
            HashSet<String> localBadNames = new HashSet<String>();
            HashSet<String> localBadTables = new HashSet<String>();
            treeletGenerator.init(this.m_treeletOptions);
            treeletGenerator.getTreeletNodes(tables, names, localBadNames, localBadTables);
            treeletGenerator.resetMetrics();
            Iterator<String> iter = badNames.iterator();
            while (iter.hasNext()) {
                String badName = iter.next();
                if (localBadNames.contains(badName)) continue;
                iter.remove();
            }
            iter = badTables.iterator();
            while (iter.hasNext()) {
                String badTable = iter.next();
                if (localBadTables.contains(badTable)) continue;
                iter.remove();
            }
        }
        this.printBadParams(badNames, badTables, out);
        this.printEnding(out);
        badNames.clear();
        badTables.clear();
    }

    private void _walk(BranchTreeletNode node, BranchTreeletNode root, PrintWriter out) {
        Collection<LeafTreeletNode> metrics;
        if (node != root) {
            this.startPrintBranchNode(node, out);
        }
        if ((metrics = node.getLeaves(this.m_treeletOptions.isOrdered())) != null && metrics.size() > 0) {
            for (LeafTreeletNode metric : metrics) {
                this.printLeafNode(metric, out);
            }
        }
        out.flush();
        Collection nouns = node.getBranches(this.m_treeletOptions.isOrdered());
        if (nouns != null && nouns.size() > 0) {
            for (BranchTreeletNode noun : nouns) {
                this._walk(noun, root, out);
            }
        }
        if (node != root) {
            this.endPrintBranchNode(node, out);
        }
    }

    private void _refreshNoun() {
        Set<NounRefresh> refreshes = Noun.getNounRefresh();
        if (refreshes == null) {
            return;
        }
        for (NounRefresh refresh : refreshes) {
            if (refresh == null) continue;
            refresh.refresh(EMPTY_SET);
        }
    }
}

