/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.config;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.config.Config;
import oracle.dms.config.ConfigChangeListener;
import oracle.dms.config.ConfigChild;
import oracle.dms.config.DMSConfigurationException;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;
import oracle.dms.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DumpConfig
implements ConfigChild {
    private int m_intervalSeconds;
    private int m_maxSizeMBytes;
    private boolean m_enabled = false;
    private boolean m_updatesPending;
    private boolean m_isRuntime;
    private Set<ConfigChangeListener> m_listeners = Collections.synchronizedSet(new LinkedHashSet());
    private static final String DUMP = "dump";
    private static final String DUMP_CONFIGURATION = "dumpConfiguration";
    private static final int DEFAULT_DUMP_INTERVAL = 10800;
    private static final int DEFAULT_MAX_SIZE = 75;
    private static final String CLASS_NAME = DumpConfig.class.getName();
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");
    private volatile boolean m_shutdown = false;

    public boolean isShutdown() {
        return this.m_shutdown;
    }

    public void shutdown() {
        if (this.m_shutdown) {
            return;
        }
        this.m_shutdown = true;
        this.m_listeners.clear();
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        this.m_updatesPending = true;
    }

    public int getIntervalSeconds() {
        return this.m_intervalSeconds;
    }

    public void setIntervalSeconds(int interval) {
        if (interval < 1) {
            return;
        }
        this.m_intervalSeconds = interval;
        this.m_updatesPending = true;
    }

    public int getMaxSizeMBytes() {
        return this.m_maxSizeMBytes;
    }

    public void setMaxSizeMBytes(int maxSize) {
        if (maxSize < 1) {
            return;
        }
        this.m_maxSizeMBytes = maxSize;
        this.m_updatesPending = true;
    }

    @Override
    public synchronized void parseConfigDocument(Element xdms) throws DMSConfigurationException {
        if (xdms == null) {
            throw new IllegalArgumentException("xdms=null");
        }
        if (this.m_shutdown) {
            return;
        }
        try {
            this._getDump(xdms);
        }
        catch (NumberFormatException e) {
            String mesg = DMSUtil.errorMessage("50727", new Object[0]);
            throw new DMSConfigurationException(mesg, e);
        }
    }

    private void _getDump(Element metricConfig) throws NumberFormatException {
        String METHOD_NAME = "_getDump";
        NodeList dumpList = metricConfig.getElementsByTagName(DUMP);
        int length = dumpList == null ? 0 : dumpList.getLength();
        int dumpInterval = 10800;
        int maxSize = 75;
        boolean enabled = false;
        for (int i = length - 1; i >= 0; --i) {
            Node child = dumpList.item(i);
            if (!(child instanceof Element)) continue;
            Element dump = (Element)child;
            int interval = XmlUtil.getAttributeInt(dump, "intervalSeconds");
            if (interval < 1) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.logp(Level.INFO, this.getClass().getName(), "_getDump", "DMS-50993", Integer.toString(interval));
                }
                enabled = false;
                break;
            }
            dumpInterval = interval;
            int size = XmlUtil.getAttributeInt(dump, "maxSizeMBytes");
            if (size < 1) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.logp(Level.INFO, this.getClass().getName(), "_getDump", "DMS-50994", Integer.toString(size));
                }
                enabled = false;
                break;
            }
            maxSize = size;
            enabled = XmlUtil.getAttributeBoolean(dump, "enabled");
            break;
        }
        this.m_intervalSeconds = dumpInterval;
        this.m_maxSizeMBytes = maxSize;
        this.m_enabled = enabled;
    }

    @Override
    public synchronized Element buildElement(Document document) throws DMSConfigurationException {
        Element xdumpConfig = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", DUMP_CONFIGURATION);
        Element xdump = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", DUMP);
        xdump.setAttribute("intervalSeconds", Integer.toString(this.m_intervalSeconds));
        xdump.setAttribute("maxSizeMBytes", Integer.toString(this.m_maxSizeMBytes));
        xdump.setAttribute("enabled", Boolean.toString(this.m_enabled));
        xdumpConfig.appendChild(xdump);
        return xdumpConfig;
    }

    public void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        if (this.m_shutdown) {
            return;
        }
        if (configChangeListener != null) {
            this.m_listeners.add(configChangeListener);
        }
    }

    public void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        if (configChangeListener != null) {
            this.m_listeners.remove(configChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateConfiguration() {
        if (this.m_shutdown || this.m_listeners.size() == 0) {
            return;
        }
        LinkedHashSet<ConfigChangeListener> listeners = new LinkedHashSet<ConfigChangeListener>();
        Set<ConfigChangeListener> set = this.m_listeners;
        synchronized (set) {
            listeners.addAll(this.m_listeners);
        }
        for (ConfigChangeListener listener : listeners) {
            listener.configChanged();
        }
    }

    public void setRuntime(boolean isRuntime) {
        this.m_isRuntime = isRuntime;
    }

    @Override
    public synchronized void sync(Config pendingConfig) throws DMSConfigurationException {
        if (!this.m_isRuntime) {
            this.syncConfig(pendingConfig.getDumpConfig());
        }
    }

    private synchronized void syncConfig(DumpConfig updatedConfig) throws EventConfigException {
        String METHOD_NAME = "syncConfig";
        if (LOGGER.isLoggable(Level.FINER)) {
            String msg = "START sync:" + Time.currentTimeMillis();
            LOGGER.logp(Level.FINER, CLASS_NAME, "syncConfig", msg);
        }
        this.m_intervalSeconds = updatedConfig.m_intervalSeconds;
        this.m_maxSizeMBytes = updatedConfig.m_maxSizeMBytes;
        this.m_enabled = updatedConfig.m_enabled;
    }

    @Override
    public boolean isConfigurationUpdated() {
        return this.m_updatesPending;
    }

    @Override
    public void setConfigurationUpdated(boolean updated) {
        this.m_updatesPending = updated;
    }
}

