/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dms.event.Event;
import oracle.dms.event.EventType;
import oracle.dms.event.EventTypeEnthusiast;
import oracle.dms.event.LoadableDestination;
import oracle.dms.event.config.DestinationDescription;
import oracle.dms.util.StackTrace;
import oracle.dms.util.StackTraceAggregate;
import oracle.dms.util.Validatable;
import oracle.dms.util.ValidationException;

@DestinationDescription(nlsDescriptionResourceBundle="oracle.dms.event.EventResourceBundle", nlsDescriptionID="STACK_TRACE_COLLATOR_DESTINATION")
public class StackTraceCollatorDestination
implements LoadableDestination,
EventTypeEnthusiast {
    private String mName;
    private String mId;
    private EventType[] mEventTypesOfInterest;
    private PrintStream mPrintStream;
    private String mLoggerName;
    private Map<EventType, StackTraceAggregate> mAggregates = new HashMap<EventType, StackTraceAggregate>();
    private int mMinDumpIntervalInMinutes = 1;
    private boolean mClearTracesWhenDumped = true;

    public StackTraceCollatorDestination() {
        this.mPrintStream = System.err;
    }

    @Override
    public void handleEvent(Event event) {
        EventType eventType = EventType.getEventType(event.getSourceType(), event.getActionType());
        StackTraceAggregate sta = this.mAggregates.get(eventType);
        if (sta != null) {
            sta.addStackTrace(new StackTrace());
            if (this.mMinDumpIntervalInMinutes > 0 && event.getTime() > sta.getLastDumpTime() + (long)(this.mMinDumpIntervalInMinutes * 60 * 1000)) {
                this.dumpStackAggregate(eventType, sta);
            }
        }
    }

    @Override
    public boolean needsContext() {
        return false;
    }

    @Override
    public void initDestination() {
    }

    @Override
    public void shutdownDestination() {
        for (Map.Entry<EventType, StackTraceAggregate> entry : this.mAggregates.entrySet()) {
            this.dumpStackAggregate(entry.getKey(), entry.getValue());
        }
    }

    private void dumpStackAggregate(EventType eventType, StackTraceAggregate sta) {
        if (this.mPrintStream != null) {
            sta.printStackTraces(eventType.toString(), this.mPrintStream);
        } else if (this.mLoggerName != null) {
            Logger logger = Logger.getLogger(this.mLoggerName);
            sta.printStackTraces(eventType.toString(), logger);
        }
        if (this.mClearTracesWhenDumped) {
            sta.clearStackTraces();
        }
    }

    public void setEventTypesOfInterest(String eventListAsString) {
        for (EventType et : this.mEventTypesOfInterest = EventType.parseList(eventListAsString)) {
            this.mAggregates.put(et, new StackTraceAggregate());
        }
    }

    public void setMinDumpIntervalInMinutes(String s) {
        try {
            int value = Integer.parseInt(s);
            if (value < 0) {
                value = 0;
            }
            this.mMinDumpIntervalInMinutes = value;
        }
        catch (NumberFormatException nfe) {
            this.mMinDumpIntervalInMinutes = 1;
        }
    }

    public int getMinDumpIntervalInMinutes() {
        return this.mMinDumpIntervalInMinutes;
    }

    @Override
    public void setName(String name) {
        if (this.mName == null) {
            this.mName = name;
        }
    }

    @Override
    public void setId(String id) {
        if (this.mId == null) {
            this.mId = id;
        }
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void setLoggerName(String loggerName) {
        this.mLoggerName = loggerName;
        this.mPrintStream = null;
    }

    public String getLoggerName() {
        return this.mLoggerName;
    }

    public void setPrintStream(String printStream) {
        if (printStream != null) {
            if ("stderr".equals(printStream.toLowerCase())) {
                this.mPrintStream = System.err;
            }
            if ("stdout".equals(printStream.toLowerCase())) {
                this.mPrintStream = System.out;
            }
        }
        this.mLoggerName = null;
    }

    public void setClearTracesWhenDumped(String s) {
        this.mClearTracesWhenDumped = Boolean.parseBoolean(s);
    }

    public boolean getClearTracesWhenDumped() {
        return this.mClearTracesWhenDumped;
    }

    @Override
    public EventType[] getEventTypesOfInterest() {
        return this.mEventTypesOfInterest;
    }

    public boolean equals(Object o) {
        boolean retVal = false;
        if (o == null) {
            retVal = false;
        } else if (o == this) {
            retVal = true;
        } else if (o instanceof StackTraceCollatorDestination) {
            retVal = true;
            StackTraceCollatorDestination you = (StackTraceCollatorDestination)o;
            if (this.mId != null) {
                retVal = retVal && this.mId.equals(you.mId);
            } else {
                boolean bl = retVal = retVal && you.mId == null;
            }
            if (this.mName != null) {
                retVal = retVal && this.mName.equals(you.mName);
            } else {
                boolean bl = retVal = retVal && you.mName == null;
            }
            if (this.mLoggerName != null) {
                retVal = retVal && this.mLoggerName.equals(you.mLoggerName);
            } else {
                boolean bl = retVal = retVal && you.mLoggerName == null;
            }
            retVal = this.mPrintStream != null ? retVal && this.mPrintStream.equals(you.mPrintStream) : retVal && you.mPrintStream == null;
            retVal = retVal && this.mClearTracesWhenDumped == you.mClearTracesWhenDumped;
            retVal = retVal && EventType.arraysEqual(this.mEventTypesOfInterest, you.mEventTypesOfInterest);
        }
        return retVal;
    }

    public int hashCode() {
        int retVal = (this.mId == null ? 0 : this.mId.hashCode()) ^ (this.mName == null ? 0 : this.mName.hashCode()) ^ (this.mLoggerName == null ? 0 : this.mLoggerName.hashCode()) ^ (this.mPrintStream == null ? 0 : this.mPrintStream.hashCode());
        if (this.mEventTypesOfInterest != null) {
            for (EventType eventType : this.mEventTypesOfInterest) {
                retVal ^= eventType.hashCode();
            }
        }
        return retVal;
    }

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) throws ValidationException {
    }
}

