/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.io.UnsupportedEncodingException;

public abstract class Base64Encoder {
    private static final String HEADER_ENCODING = "ISO8859_1";
    private static byte[] encodetable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public static final String encode(String cleartext) {
        byte[] bytes = null;
        if (cleartext == null) {
            return null;
        }
        try {
            bytes = cleartext.getBytes(HEADER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Internal error: could not get byte array for " + cleartext + " in encoding " + HEADER_ENCODING);
            return null;
        }
        StringBuffer encodedBuf = new StringBuffer(bytes.length * 2);
        int encode_index = 0;
        int whichpiece = 0;
        int i = 0;
        block8: while (i < bytes.length) {
            switch (whichpiece) {
                case 0: {
                    encode_index = (bytes[i] & 0xFC) >> 2;
                    encodedBuf.append((char)encodetable[encode_index]);
                    whichpiece = 1;
                    continue block8;
                }
                case 1: {
                    encode_index = (bytes[i] & 3) << 4;
                    if (++i == bytes.length) {
                        encodedBuf.append((char)encodetable[encode_index]);
                        encodedBuf.append('=');
                        encodedBuf.append('=');
                        continue block8;
                    }
                    encodedBuf.append((char)encodetable[encode_index |= (bytes[i] & 0xF0) >>> 4]);
                    whichpiece = 2;
                    continue block8;
                }
                case 2: {
                    encode_index = (bytes[i] & 0xF) << 2;
                    if (++i < bytes.length) {
                        encodedBuf.append((char)encodetable[encode_index |= (bytes[i] & 0xC0) >>> 6]);
                    } else {
                        encodedBuf.append((char)encodetable[encode_index]);
                        encodedBuf.append('=');
                    }
                    whichpiece = 3;
                    continue block8;
                }
                case 3: {
                    encode_index = bytes[i] & 0x3F;
                    encodedBuf.append((char)encodetable[encode_index]);
                    whichpiece = 0;
                    ++i;
                    continue block8;
                }
            }
        }
        return encodedBuf.toString();
    }

    private Base64Encoder() {
    }
}

