/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.clock.ClockManager;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.instrument.state.DoubleValue;
import oracle.dms.instrument.state.IntegerValue;
import oracle.dms.instrument.state.LongValue;
import oracle.dms.instrument.state.Value;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.Time;

public class BucketSensor
extends Sensor {
    public static final byte STATE = 0;
    public static final byte EVENT = 1;
    public static final byte PHASE_EVENT = 2;
    private byte m_sensorType;
    private byte m_state_type;
    private Value m_value = null;
    private String m_units = null;
    private int m_count;
    long m_time = 0L;
    long m_minTime = Long.MAX_VALUE;
    long m_maxTime = Long.MIN_VALUE;
    private int m_derived = 0;

    private BucketSensor() {
    }

    private BucketSensor(Noun parent, String name) {
        super(false, parent, name, "");
    }

    static BucketSensor create(Noun bucket, Sensor sensor) {
        if (bucket == null || sensor == null) {
            return null;
        }
        BucketSensor bs = null;
        if (sensor instanceof State) {
            byte valueType = ((State)sensor).getValueType();
            switch (valueType) {
                case 1: 
                case 2: 
                case 3: {
                    bs = new BucketSensor(bucket, sensor.getName());
                    bs.createStateMetrics((State)sensor);
                    break;
                }
            }
        } else if (sensor instanceof PhaseEvent) {
            bs = new BucketSensor(bucket, sensor.getName());
            bs.createPhaseEventMetrics((PhaseEvent)sensor);
        } else if (sensor instanceof Event) {
            bs = new BucketSensor(bucket, sensor.getName());
            bs.createEventMetrics((Event)sensor);
        } else {
            return null;
        }
        return bs;
    }

    private void createEventMetrics(Event event) {
        this.m_sensorType = 1;
        this._metrics[1] = Metric.create(this._name + ".count", this._description, "ops", this, false, (byte)3, (byte)1);
        this.setUpdateTime(0L);
    }

    private void createStateMetrics(State state) {
        this.m_sensorType = 0;
        Metric met = state.getMetric(1);
        if (met == null) {
            return;
        }
        this.m_state_type = state.getValueType();
        this.m_units = met.getUnits();
        switch (this.m_state_type) {
            case 3: {
                this.m_value = new IntegerValue();
                break;
            }
            case 2: {
                this.m_value = new LongValue();
                break;
            }
            case 1: {
                this.m_value = new DoubleValue();
                break;
            }
            default: {
                return;
            }
        }
        this._metrics[0] = Metric.create(this._name + ".value", this._description, this.m_units, this, false, this.m_state_type, (byte)0);
        met = state.getMetric(8);
        if (met != null) {
            this._metrics[3] = Metric.create(this._name + ".maxValue", this._description, this.m_units, this, false, this.m_state_type, (byte)3);
            this.m_derived |= 8;
        }
        if ((met = state.getMetric(4)) != null) {
            this._metrics[2] = Metric.create(this._name + ".minValue", this._description, this.m_units, this, false, this.m_state_type, (byte)2);
            this.m_derived |= 4;
        }
        this.m_value.deriveMetric(this.m_derived);
        this.setUpdateTime(0L);
    }

    private void createPhaseEventMetrics(PhaseEvent pe) {
        this.m_sensorType = (byte)2;
        this.m_units = ClockManager.getUnits(DMSConsole.UNITS);
        Metric met = null;
        this._metrics[0] = Metric.create(this._name + ".time", this._description, this.m_units, this, false, (byte)2, (byte)0);
        met = pe.getMetric(4);
        if (met != null) {
            this._metrics[2] = Metric.create(this._name + ".minTime", this._description, this.m_units, this, false, (byte)2, (byte)2);
            this.m_derived |= 4;
        }
        if ((met = pe.getMetric(8)) != null) {
            this._metrics[3] = Metric.create(this._name + ".maxTime", this._description, this.m_units, this, false, (byte)2, (byte)3);
            this.m_derived |= 8;
        }
        if ((met = pe.getMetric(2)) != null) {
            this._metrics[1] = Metric.create(this._name + ".completed", this._description, "ops", this, false, (byte)3, (byte)1);
            this.m_derived |= 2;
        }
        if ((met = pe.getMetric(32)) != null && this._metrics[1] != null) {
            this._metrics[5] = Metric.create(this._name + ".avg", this._description, this.m_units, this, false, (byte)1, (byte)5);
            this.m_derived |= 0x20;
        }
    }

    void update(long amount, long time) {
        this._lastUpdate = time;
        switch (this.m_sensorType) {
            case 2: {
                this.stop(amount);
                break;
            }
            case 0: {
                this.increment(amount);
                break;
            }
            case 1: {
                ++this.m_count;
            }
        }
    }

    void update(double amount, long time) {
        this._lastUpdate = time;
        this.increment(amount);
    }

    synchronized void stop(long duration) {
        this.m_time += duration;
        if (this.m_maxTime < duration) {
            this.m_maxTime = duration;
        }
        if (this.m_minTime > duration) {
            this.m_minTime = duration;
        }
        ++this.m_count;
    }

    void increment(int amount) {
        this.m_value.increment(amount);
        ++this.m_count;
    }

    void increment(long amount) {
        this.m_value.increment(amount);
        ++this.m_count;
    }

    void increment(double amount) {
        this.m_value.increment(amount);
        ++this.m_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Metric metric) {
        if (metric == null) {
            throw new InstrumentationException("DMS-50750");
        }
        if (!metric.isAlive()) {
            return new ErrorObject();
        }
        byte index = metric.getIndex();
        if (this._metrics[index] != metric) {
            throw new InstrumentationException("DMS-50751", metric.toString(), this.toString());
        }
        BucketSensor bucketSensor = this;
        synchronized (bucketSensor) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (index) {
                case 0: {
                    if (this.m_sensorType == 2) {
                        return new Long(this.m_time);
                    }
                    return this.m_value.getValue();
                }
                case 1: {
                    return new Integer(this.m_count);
                }
                case 2: {
                    if (this.m_sensorType == 2) {
                        return new Long(this.m_minTime);
                    }
                    return this.m_value.getMin();
                }
                case 3: {
                    if (this.m_sensorType == 2) {
                        return new Long(this.m_maxTime);
                    }
                    return this.m_value.getMax();
                }
                case 5: {
                    if (this.m_count == 0) {
                        return new Double(0.0);
                    }
                    return new Double(this.m_time / (long)this.m_count);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (!this._alive) {
            return;
        }
        long timeStamp = Time.currentTimeMillis();
        BucketSensor bucketSensor = this;
        synchronized (bucketSensor) {
            this.m_count = 0;
            this.m_time = 0L;
            this.m_minTime = Long.MAX_VALUE;
            this.m_maxTime = Long.MIN_VALUE;
            this._lastUpdate = timeStamp;
            this.setResetTime(timeStamp);
        }
    }

    @Override
    public void deriveMetric(int metric) {
    }

    public byte getType() {
        return this.m_sensorType;
    }
}

