/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import java.util.StringTokenizer;
import oracle.dms.table.CompareSelector;
import oracle.dms.table.Row;
import oracle.dms.table.Selector;
import oracle.dms.util.TopoNodeIDInfo;

class TopologyCompareSelector
extends CompareSelector {
    private TopoNodeIDInfo m_topoInfo;

    TopologyCompareSelector(String column, String tnId, Selector.Operator operator, TopoNodeIDInfo topoInfo) {
        super(column, (Serializable)((Object)tnId), operator);
        if (topoInfo == null || operator != Selector.Operator.CONTAINSANCESTOR && operator != Selector.Operator.CONTAINSDESCENDANT) {
            throw new IllegalArgumentException("topoInfo=" + topoInfo + " operator=" + (Object)((Object)operator));
        }
        this.m_topoInfo = topoInfo;
    }

    @Override
    public boolean select(Row row) {
        if (row == null) {
            return false;
        }
        String curId = (String)((Object)this.m_value);
        Serializable tnIds = row.getValue(this.m_column);
        if (tnIds == null) {
            return false;
        }
        boolean bool = false;
        StringTokenizer tok = new StringTokenizer(tnIds.toString(), " \t\r\n,");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ((this.m_operator != Selector.Operator.CONTAINSDESCENDANT || !this.m_topoInfo.containsServer(curId, token)) && (this.m_operator != Selector.Operator.CONTAINSANCESTOR || !this.m_topoInfo.containsServer(token, curId))) continue;
            bool = true;
            break;
        }
        return bool;
    }

    @Override
    public String toString() {
        switch (this.m_operator) {
            case CONTAINSDESCENDANT: {
                return '(' + this.m_column + " ContainsDescendant " + this.m_value.toString() + ')';
            }
            case CONTAINSANCESTOR: {
                return '(' + this.m_column + " ContainsAncestor " + this.m_value.toString() + ')';
            }
        }
        return super.toString();
    }
}

