/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.common;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.concurrent.ThreadFactory;

public class NamedThreadFactory
implements ThreadFactory {
    final ThreadGroup m_group;
    final String m_name;

    public NamedThreadFactory(String name) {
        SecurityManager s = System.getSecurityManager();
        this.m_group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.m_name = name;
    }

    @Override
    public Thread newThread(Runnable r) {
        final Thread t = new Thread(this.m_group, r, this.m_name + " (created: " + new Date() + ")", 0L);
        if (!t.isDaemon()) {
            t.setDaemon(true);
        }
        if (t.getPriority() != 5) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    t.setPriority(5);
                    return null;
                }
            });
        }
        return t;
    }
}

