/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event;

import java.util.Map;
import java.util.Set;
import oracle.dms.event.Destination;
import oracle.dms.event.config.EventConfig;
import oracle.dms.event.config.Filter;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.ObjectUtils;

public interface EventConfigManager {
    public boolean associateFilterWithDestination(FilterConfigRuntimePair var1, DestinationConfigRuntimePair var2);

    public boolean associateInternalFilterWithDestination(oracle.dms.event.Filter var1, Destination var2);

    public void disassociateFilterAndDestination(String var1, String var2);

    public void removeFilter(String var1);

    public void removeDestination(String var1);

    public boolean replaceFilter(FilterConfigRuntimePair var1);

    public boolean replaceDestination(DestinationConfigRuntimePair var1);

    public void shutdown();

    public boolean[] isNounTypeOfPossibleInterest(String var1);

    public boolean hasFilter(String var1);

    public boolean hasDestination(String var1);

    public Map<String, Filter> getAllFilterConfigs();

    public Map<String, oracle.dms.event.config.Destination> getAllDestinationConfigs();

    public DestinationConfigRuntimePair findDestination(oracle.dms.event.config.Destination var1);

    public Set<EventConfig.EventRouteTuple> getAllEventRouteTuples(boolean var1);

    @JSONUtils.JSONFormatToString
    public static class DestinationConfigRuntimePair {
        private final oracle.dms.event.config.Destination mConfigDestination;
        private final Destination mRuntimeDestination;
        private final int mHashCode;
        private String mAsString;

        public DestinationConfigRuntimePair(oracle.dms.event.config.Destination configDestination, Destination runtimeDestination) {
            if (runtimeDestination == null) {
                throw new IllegalArgumentException("runtimeDestination must not be null.");
            }
            if (configDestination != null && !runtimeDestination.getId().equals(configDestination.getDestinationId())) {
                throw new IllegalArgumentException("runtimeDestination and configDestination must have the same id.");
            }
            this.mConfigDestination = configDestination;
            this.mRuntimeDestination = runtimeDestination;
            this.mHashCode = (this.mConfigDestination == null ? 0 : this.mConfigDestination.hashCode()) ^ this.mRuntimeDestination.hashCode();
        }

        public oracle.dms.event.config.Destination getConfigDestination() {
            return this.mConfigDestination;
        }

        public Destination getRuntimeDestination() {
            return this.mRuntimeDestination;
        }

        public String getId() {
            return this.mRuntimeDestination.getId();
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (this == o) {
                retVal = true;
            } else if (o instanceof DestinationConfigRuntimePair) {
                DestinationConfigRuntimePair that = (DestinationConfigRuntimePair)o;
                retVal = ObjectUtils.areEqual(this.mConfigDestination, that.mConfigDestination) && ObjectUtils.areEqual(this.mRuntimeDestination, that.mRuntimeDestination);
            }
            return retVal;
        }

        public String toString() {
            if (this.mAsString == null) {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                sb.append("\"destination\"");
                sb.append(':');
                sb.append('{');
                sb.append("\"config\"");
                sb.append(':');
                sb.append(this.mConfigDestination);
                sb.append(',');
                sb.append("\"runtime\"");
                sb.append(':');
                sb.append(this.mRuntimeDestination);
                sb.append('}');
                sb.append('}');
                this.mAsString = sb.toString();
            }
            return this.mAsString;
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }

    @JSONUtils.JSONFormatToString
    public static class FilterConfigRuntimePair {
        private final Filter mConfigFilter;
        private final oracle.dms.event.Filter mRuntimeFilter;
        private final int mHashCode;
        private String mAsString;

        public FilterConfigRuntimePair(Filter configFilter, oracle.dms.event.Filter runtimeFilter) {
            if (runtimeFilter == null) {
                throw new IllegalArgumentException("runtimeFilter must not be null.");
            }
            if (configFilter != null && !runtimeFilter.getId().equals(configFilter.getFilterId())) {
                throw new IllegalArgumentException("runtimeFilter and configFilter must have the same id.");
            }
            this.mConfigFilter = configFilter;
            this.mRuntimeFilter = runtimeFilter;
            this.mHashCode = (this.mConfigFilter == null ? 0 : this.mConfigFilter.hashCode()) ^ this.mRuntimeFilter.hashCode();
        }

        public Filter getConfigFilter() {
            return this.mConfigFilter;
        }

        public oracle.dms.event.Filter getRuntimeFilter() {
            return this.mRuntimeFilter;
        }

        public String getId() {
            return this.mRuntimeFilter.getId();
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (this == o) {
                retVal = true;
            } else if (o instanceof FilterConfigRuntimePair) {
                FilterConfigRuntimePair that = (FilterConfigRuntimePair)o;
                retVal = ObjectUtils.areEqual(this.mConfigFilter, that.mConfigFilter) && ObjectUtils.areEqual(this.mRuntimeFilter, that.mRuntimeFilter);
            }
            return retVal;
        }

        public String toString() {
            if (this.mAsString == null) {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                sb.append("\"filter\"");
                sb.append(':');
                sb.append('{');
                sb.append("\"config\"");
                sb.append(':');
                sb.append(this.mConfigFilter);
                sb.append(',');
                sb.append("\"runtime\"");
                sb.append(':');
                sb.append(this.mRuntimeFilter);
                sb.append('}');
                sb.append('}');
                this.mAsString = sb.toString();
            }
            return this.mAsString;
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }
}

