/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class RuntimeStats
implements GroupRefresh {
    private static RuntimeStats s_stats = null;
    private static final int CLASS = 1;
    private static final int LIBRARY = 2;
    private static final int BOOT_CLASS = 3;
    private RuntimeMXBean m_runtime = null;
    private State m_uptime = null;

    private RuntimeStats() {
    }

    private RuntimeStats(Noun baseNoun) {
        if (baseNoun == null) {
            baseNoun = Noun.create("/JVM/MxBeans");
        }
        this.m_runtime = ManagementFactory.getRuntimeMXBean();
        Noun runtimeNoun = Noun.create(baseNoun, "runtime", "JVM_Runtime");
        State bootClassPath = State.create(runtimeNoun, "bootClassPath", (byte)5, "", "boot class path used by the bootstrap class loader");
        bootClassPath.update(RuntimeStats.getPath(this.m_runtime, 3));
        State klassPath = State.create(runtimeNoun, "classPath", (byte)5, "", "Java class path used by the System class loader");
        klassPath.update(RuntimeStats.getPath(this.m_runtime, 1));
        State libraryPath = State.create(runtimeNoun, "libraryPath", (byte)5, "", "Java library path");
        libraryPath.update(RuntimeStats.getPath(this.m_runtime, 2));
        State mgmtSpecVersion = State.create(runtimeNoun, "mgmtSpecVersion", (byte)5, "", "version of the management interface spec implemented in running JVM");
        mgmtSpecVersion.update(this.m_runtime.getManagementSpecVersion());
        State nameJVM = State.create(runtimeNoun, "name", (byte)5, "", "JVM name");
        nameJVM.update(this.m_runtime.getName());
        State specName = State.create(runtimeNoun, "specName", (byte)5, "", "JVM specification name");
        specName.update(this.m_runtime.getSpecName());
        State specVendor = State.create(runtimeNoun, "specVendor", (byte)5, "", "JVM specification vendor");
        specVendor.update(this.m_runtime.getSpecVendor());
        State specVersion = State.create(runtimeNoun, "specVersion", (byte)5, "", "JVM specification version");
        specVersion.update(this.m_runtime.getSpecVersion());
        State vmName = State.create(runtimeNoun, "vmName", (byte)5, "", "JVM implementation name");
        vmName.update(this.m_runtime.getVmName());
        State vmVendor = State.create(runtimeNoun, "vmVendor", (byte)5, "", "JVM vendor");
        vmVendor.update(this.m_runtime.getVmVendor());
        State vmVersion = State.create(runtimeNoun, "vmVersion", (byte)5, "", "JVM version");
        vmVersion.update(this.m_runtime.getVmVersion());
        State bootClassSupport = State.create(runtimeNoun, "bootClassPathSupport", (byte)5, "", "wheter the JVM supports booth class path mechanism");
        boolean support = this.m_runtime.isBootClassPathSupported();
        bootClassSupport.update(support ? "TRUE" : "FALSE");
        this.m_uptime = State.create(runtimeNoun, "uptime", (byte)2, "msecs", "uptime of the JVM");
        this.m_uptime.setRefresh(this);
        this.refresh();
    }

    private static String getPath(final RuntimeMXBean runtime, final int type) {
        String value = null;
        value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String path = null;
                switch (type) {
                    case 1: {
                        path = runtime.getClassPath();
                        break;
                    }
                    case 2: {
                        path = runtime.getLibraryPath();
                        break;
                    }
                    case 3: {
                        path = runtime.getBootClassPath();
                        break;
                    }
                }
                return path;
            }
        });
        return value;
    }

    public static void create(Noun base) {
        if (s_stats != null) {
            return;
        }
        s_stats = new RuntimeStats(base);
    }

    @Override
    public void refresh() {
        this.m_uptime.update(this.m_runtime.getUptime());
    }

    static void exit() {
        s_stats = null;
    }
}

