/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.internal;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import oracle.dms.AbstractParameterDescriptor;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.ActivationParameterFactory;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.internal.ActivationParameterDescriptorEx;
import oracle.dms.instrument.internal.ActivationParameterListener;
import oracle.dms.util.ClientObjectHolderImpl;
import oracle.dms.util.ClientObjectKey;
import oracle.dms.util.ClientObjectKeyManager;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.JSONUtils;

public class ActivationParameterFactoryImpl
implements ActivationParameterFactory {
    public static Logger sLogger = Logger.getLogger("oracle.dms.instrument");
    private Map<String, WeakReference<ActivationParameterDescriptorImpl>> mDescriptorMap = new HashMap<String, WeakReference<ActivationParameterDescriptorImpl>>();
    private Set<ActivationParameterListener> mListeners = new CopyOnWriteArraySet<ActivationParameterListener>();

    @Override
    public ActivationParameterDescriptorEx createDescriptor(String name, Class<? extends ResourceBundle> resourceBundleClass, String resourceKeyPrefix, Set<String> valueSet, int valueSetSize) {
        ActivationParameterDescriptorImpl retVal = null;
        if (!DMSUtil.isLegalIdentifier(name) || name.indexOf(46) < 0) {
            throw new IllegalArgumentException("The proposed parameter name, " + name + ", does not conform to the activation-parameter-naming guidelines: " + "names must contain only ASCII characters, " + "and, using the standard java paradigm, must not " + "reside in the unnamed package");
        }
        ActivationParameterDescriptorImpl newDesc = new ActivationParameterDescriptorImpl(name, resourceBundleClass, resourceKeyPrefix, valueSet, valueSetSize);
        ActivationParameterDescriptorImpl oldDesc = this.findDescriptor(name);
        if (oldDesc == null) {
            this.mDescriptorMap.put(name, new WeakReference<ActivationParameterDescriptorImpl>(newDesc));
            retVal = newDesc;
            for (ActivationParameterListener listener : this.mListeners) {
                listener.parameterDescriptorCreated(retVal);
            }
        } else if (oldDesc.equals(newDesc)) {
            oldDesc.addResourceBundleClass(resourceBundleClass);
            retVal = oldDesc;
        } else {
            throw new IllegalArgumentException("The proposed new paramaeter descriptor has the same name as an existing parameter descriptor, but the details of the descriptor differ.");
        }
        return retVal;
    }

    @Override
    public ActivationParameterDescriptorImpl findDescriptor(String name) {
        ActivationParameterDescriptorImpl retVal = null;
        if (this.mDescriptorMap.get(name) != null) {
            retVal = (ActivationParameterDescriptorImpl)this.mDescriptorMap.get(name).get();
        }
        return retVal;
    }

    @Override
    public Set<String> getDescriptorNames() {
        HashSet<String> retVal = new HashSet<String>();
        retVal.addAll(this.mDescriptorMap.keySet());
        return retVal;
    }

    public void registerListener(ActivationParameterListener listener) {
        this.mListeners.add(listener);
    }

    public void deregisterListener(ActivationParameterListener listener) {
        this.mListeners.remove(listener);
    }

    @JSONUtils.JSONFormatToString
    private static class ActivationParameterImpl
    implements ActivationParameter {
        String mToStringReturnValue;
        ActivationParameterDescriptorEx mDescriptor;
        String mValue;

        ActivationParameterImpl(ActivationParameterDescriptorEx descriptor, String value) {
            this.mDescriptor = descriptor;
            this.mValue = value;
        }

        @Override
        public ActivationParameterDescriptorEx getDescriptor() {
            return this.mDescriptor;
        }

        @Override
        public String getValue() {
            return this.mValue;
        }

        @Override
        public String getName() {
            return this.mDescriptor.getName();
        }

        public String toString() {
            if (this.mToStringReturnValue == null) {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                JSONUtils.appendNameValuePair(sb, "name", this.mDescriptor.getName());
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "value", this.mValue);
                sb.append('}');
                this.mToStringReturnValue = sb.toString();
            }
            return this.mToStringReturnValue;
        }
    }

    private static class ActivationParameterDescriptorImpl
    extends AbstractParameterDescriptor
    implements ActivationParameterDescriptorEx {
        private String mAsString = null;
        private final ClientObjectHolderImpl mClientObjectHolderImpl = new ClientObjectHolderImpl(ClientObjectKeyManager.ClientObjectHolderType.ACTIVATION_PARAMETER_DESCRIPTOR);
        private Set<NounDescriptor> mNounDescriptors = Collections.newSetFromMap(new ConcurrentHashMap());

        private ActivationParameterDescriptorImpl(String name, Class<? extends ResourceBundle> resourceBundleClass, String resourceKeyPrefix, Set<String> valueSet, int valueSetSize) {
            super(name, resourceBundleClass, resourceKeyPrefix, valueSet, valueSetSize);
        }

        @Override
        public ActivationParameter createParameter(String value) {
            if (this.getValueSet() != null && !this.getValueSet().contains(value)) {
                throw new IllegalArgumentException("Value '" + value + "' is not a legal value for activation parameter " + this.getName());
            }
            ActivationParameterImpl retVal = new ActivationParameterImpl(this, value);
            return retVal;
        }

        @Override
        public String toString() {
            if (this.mAsString == null) {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                JSONUtils.appendNameValuePair(sb, "name", this.getName());
                sb.append(',');
                JSONUtils.appendName(sb, "nounDescriptors");
                sb.append(':');
                sb.append('[');
                if (this.getNounDescriptors() != null) {
                    int entryCount = 0;
                    for (NounDescriptor nd : this.getNounDescriptors()) {
                        JSONUtils.appendValue(sb, nd.getName());
                        if (++entryCount <= 1) continue;
                        sb.append(',');
                    }
                }
                sb.append(']');
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "valueSetSize", this.getValueSetSize());
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "valueSet", this.getValueSet());
                sb.append('}');
                this.mAsString = sb.toString();
            }
            return this.mAsString;
        }

        @Override
        protected Logger getLogger() {
            return sLogger;
        }

        @Override
        public Object setClientObject(ClientObjectKey key, Object value) {
            return this.mClientObjectHolderImpl.setClientObject(key, value);
        }

        @Override
        public Object getClientObject(ClientObjectKey key) {
            return this.mClientObjectHolderImpl.getClientObject(key);
        }

        @Override
        public Set<NounDescriptor> getNounDescriptors() {
            return new HashSet<NounDescriptor>(this.mNounDescriptors);
        }

        @Override
        public void addNounDescriptor(NounDescriptor nounDescriptor) {
            this.mNounDescriptors.add(nounDescriptor);
        }

        @Override
        public boolean equals(Object o) {
            boolean retVal = false;
            if (o instanceof ActivationParameterDescriptorImpl) {
                retVal = super.equals(o);
            }
            return retVal;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

