/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.event.EventConfigManager;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.EventSystem;
import oracle.dms.event.EventTypeEnthusiast;
import oracle.dms.event.FilterProvider;
import oracle.dms.event.LoadableDestination;
import oracle.dms.event.NullFilterAllEventTypes;
import oracle.dms.event.NullFilterWithEventTypeProxy;
import oracle.dms.event.config.AndCondition;
import oracle.dms.event.config.Condition;
import oracle.dms.event.config.ConditionFilter;
import oracle.dms.event.config.ContextCondition;
import oracle.dms.event.config.DataType;
import oracle.dms.event.config.Destination;
import oracle.dms.event.config.EventConfig;
import oracle.dms.event.config.Filter;
import oracle.dms.event.config.NestedCondition;
import oracle.dms.event.config.NounTypeCondition;
import oracle.dms.event.config.OpType;
import oracle.dms.event.config.OrCondition;
import oracle.dms.trace2.runtime.ConditionFilter;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.CollectionUtils;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.MapUtils;
import oracle.dms.util.ObjectUtils;
import oracle.dms.util.Validatable;
import oracle.dms.util.ValidationException;

public class EventConfigurationAdapter {
    private static final String CLASS_NAME = EventConfigurationAdapter.class.getName();
    private ODLLogger m_logger = ODLLogger.getODLLogger((String)LOGGER_NAME, (String)EventResourceBundle.class.getName());
    private static String LOGGER_NAME = "oracle.dms.event";
    private AdaptedEventConfig mEventConfig;
    private Map<String, EventConfigManager.DestinationConfigRuntimePair> mRuntimeDestinationMap;
    private Map<String, EventConfigManager.FilterConfigRuntimePair> mRuntimeFilterMap;
    private static final EnumSet<Validatable.ValidationLevel> sRuntimeValidationLevels = EnumSet.of(Validatable.ValidationLevel.INTERNAL_STATE, Validatable.ValidationLevel.ENVIRONMENT);

    EventConfigurationAdapter(EventConfig eventConfig) {
        this.mEventConfig = new AdaptedEventConfig(eventConfig);
        this.mRuntimeDestinationMap = new HashMap<String, EventConfigManager.DestinationConfigRuntimePair>();
        this.mRuntimeFilterMap = new HashMap<String, EventConfigManager.FilterConfigRuntimePair>();
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.logp(Level.FINE, CLASS_NAME, "<init>", "mEventConfig = " + this.mEventConfig);
        }
    }

    public void pushToRuntime() {
        String METHOD_NAME = "pushToRuntime";
        this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "start");
        ResourceBundle translations = ResourceBundle.getBundle(EventResourceBundle.class.getName());
        StringBuilder cumulativeMessage = new StringBuilder();
        EventConfigManager runtimeEventManager = EventSystem.getEventConfigManager();
        if (runtimeEventManager != null) {
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "runtimeEventManager != null");
            }
            HashSet<EventConfigManager.DestinationConfigRuntimePair> destinationsToBeReplaced = new HashSet<EventConfigManager.DestinationConfigRuntimePair>();
            HashSet<EventConfigManager.FilterConfigRuntimePair> filtersToBeReplaced = new HashSet<EventConfigManager.FilterConfigRuntimePair>();
            HashSet<String> failedDestinationIds = new HashSet<String>();
            HashSet<String> failedFilterIds = new HashSet<String>();
            HashSet<Object[]> filterDestinationPairsToAdd = new HashSet<Object[]>();
            HashMap<String, NullConfigFilter> nullFiltersNeedingAttention = new HashMap<String, NullConfigFilter>();
            Map<String, Filter> runtimeFilterConfigs = runtimeEventManager.getAllFilterConfigs();
            Map<String, Destination> runtimeDestinationConfigs = runtimeEventManager.getAllDestinationConfigs();
            Set<EventConfig.EventRouteTuple> runtimeEventRouteTuples = runtimeEventManager.getAllEventRouteTuples(true);
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "current state of runtimeEventManager:filter configurations:" + MapUtils.toString(runtimeFilterConfigs) + ", destination configurations:" + MapUtils.toString(runtimeDestinationConfigs) + ", event routes:" + CollectionUtils.toString(runtimeEventRouteTuples));
            }
            Collection<Filter> configFilters = this.mEventConfig.getAllFilters();
            for (Filter configFilter : configFilters) {
                Filter runtimeFilterConfig = runtimeFilterConfigs.get(configFilter.getFilterId());
                if (runtimeFilterConfig == null) continue;
                EventConfigManager.FilterConfigRuntimePair fcrp = null;
                if (configFilter instanceof NullConfigFilter) {
                    nullFiltersNeedingAttention.put(((NullConfigFilter)configFilter).getConfigDestination().getDestinationId(), (NullConfigFilter)configFilter);
                } else if (!runtimeFilterConfig.equals(configFilter)) {
                    try {
                        fcrp = this.getRuntimeFilter(configFilter.getFilterId(), null);
                    }
                    catch (Throwable t) {
                        failedFilterIds.add(configFilter.getFilterId());
                        EventConfigurationAdapter.appendMessage(cumulativeMessage, translations, "FAILED_RUNTIME_FILTER_CREATION", new String[]{this.mEventConfig.getFilter(configFilter.getFilterId()).toString(), t.getMessage()});
                    }
                }
                if (fcrp == null) continue;
                filtersToBeReplaced.add(fcrp);
            }
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "filtersToBeReplaced:" + CollectionUtils.toString(filtersToBeReplaced) + ", nullFiltersNeedingAttention:" + MapUtils.toString(nullFiltersNeedingAttention) + ", failedFilterIds:" + CollectionUtils.toString(failedFilterIds));
            }
            Collection<Destination> configDestinations = this.mEventConfig.getAllDestinations();
            for (Destination configDestination : configDestinations) {
                Destination runtimeDestinationConfig = runtimeDestinationConfigs.get(configDestination.getDestinationId());
                if (runtimeDestinationConfig == null) continue;
                EventConfigManager.DestinationConfigRuntimePair dcrp = null;
                if (!runtimeDestinationConfig.equals(configDestination)) {
                    try {
                        dcrp = this.getRuntimeDestination(configDestination.getDestinationId(), null);
                    }
                    catch (Throwable t) {
                        failedDestinationIds.add(configDestination.getDestinationId());
                        EventConfigurationAdapter.appendMessage(cumulativeMessage, translations, "FAILED_RUNTIME_DESTINATION_CREATION", new String[]{this.mEventConfig.getDestination(configDestination.getDestinationId()).toString(), t.getMessage()});
                    }
                }
                if (dcrp == null) continue;
                NullConfigFilter ncf = (NullConfigFilter)nullFiltersNeedingAttention.get(configDestination.getDestinationId());
                if (ncf != null) {
                    EventConfigManager.FilterConfigRuntimePair fcrp = this.getRuntimeFilter(ncf.getFilterId(), dcrp.getRuntimeDestination());
                    filtersToBeReplaced.add(fcrp);
                }
                destinationsToBeReplaced.add(dcrp);
            }
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "destinationsToBeReplaced:" + CollectionUtils.toString(destinationsToBeReplaced) + ", failedDestinationIds:" + CollectionUtils.toString(failedDestinationIds) + (nullFiltersNeedingAttention.size() > 0 ? "" : ",filtersToBeReplaced (now includes null filters):" + CollectionUtils.toString(filtersToBeReplaced)));
            }
            Set<EventConfig.EventRouteTuple> configEventRoutes = this.mEventConfig.getEnabledEventRoutes();
            HashSet<EventConfig.EventRouteTuple> eventRoutesToAdd = new HashSet<EventConfig.EventRouteTuple>(configEventRoutes);
            eventRoutesToAdd.removeAll(runtimeEventRouteTuples);
            HashSet<EventConfig.EventRouteTuple> eventRoutesToRemove = new HashSet<EventConfig.EventRouteTuple>(runtimeEventRouteTuples);
            eventRoutesToRemove.removeAll(configEventRoutes);
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "eventRoutesToAdd:" + CollectionUtils.toString(eventRoutesToAdd));
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "eventRoutesToRemove:" + CollectionUtils.toString(eventRoutesToRemove));
            }
            for (EventConfig.EventRouteTuple configEventRouteToAdd : eventRoutesToAdd) {
                String destinationId = configEventRouteToAdd.getDestinationId();
                String filterId = configEventRouteToAdd.getFilterId();
                EventConfigManager.DestinationConfigRuntimePair d = null;
                EventConfigManager.FilterConfigRuntimePair f = null;
                if (failedDestinationIds.contains(destinationId)) {
                    EventConfigurationAdapter.appendMessage(cumulativeMessage, translations, "RUNTIME_WILL_NOT_USE_FAILED_DESTINATION", new String[]{this.mEventConfig.getDestination(destinationId).toString(), filterId, destinationId});
                } else {
                    try {
                        d = this.getRuntimeDestination(destinationId, runtimeEventManager);
                    }
                    catch (Throwable t) {
                        failedDestinationIds.add(destinationId);
                        EventConfigurationAdapter.appendMessage(cumulativeMessage, translations, "FAILED_RUNTIME_DESTINATION_CREATION", new String[]{this.mEventConfig.getDestination(destinationId).toString(), t.getMessage()});
                    }
                }
                if (d != null) {
                    if (failedFilterIds.contains(filterId)) {
                        EventConfigurationAdapter.appendMessage(cumulativeMessage, translations, "RUNTIME_WILL_NOT_USE_FAILED_FILTER", new String[]{this.mEventConfig.getFilter(filterId).toString(), filterId, destinationId});
                    } else {
                        try {
                            f = this.getRuntimeFilter(filterId, d.getRuntimeDestination());
                        }
                        catch (Throwable t) {
                            failedFilterIds.add(filterId);
                            EventConfigurationAdapter.appendMessage(cumulativeMessage, translations, "FAILED_RUNTIME_FILTER_CREATION", new String[]{this.mEventConfig.getFilter(filterId).toString(), t.getMessage()});
                        }
                    }
                }
                if (f == null) continue;
                filterDestinationPairsToAdd.add(new Object[]{f, d});
            }
            if (cumulativeMessage.length() > 0) {
                this.m_logger.log(Level.WARNING, cumulativeMessage.toString());
            }
            for (EventConfigManager.FilterConfigRuntimePair f : filtersToBeReplaced) {
                runtimeEventManager.replaceFilter(f);
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "replaced filter: " + f);
            }
            for (EventConfigManager.DestinationConfigRuntimePair d : destinationsToBeReplaced) {
                runtimeEventManager.replaceDestination(d);
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "replaced destination: " + d);
            }
            for (EventConfig.EventRouteTuple tuple : eventRoutesToRemove) {
                runtimeEventManager.disassociateFilterAndDestination(tuple.getFilterId(), tuple.getDestinationId());
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "disassociated filter and destination " + tuple);
            }
            for (Object[] filterDestination : filterDestinationPairsToAdd) {
                runtimeEventManager.associateFilterWithDestination((EventConfigManager.FilterConfigRuntimePair)filterDestination[0], (EventConfigManager.DestinationConfigRuntimePair)filterDestination[1]);
                this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "asassociated filter " + filterDestination[0] + " and destination " + filterDestination[1]);
            }
        }
        this.m_logger.logp(Level.FINE, CLASS_NAME, "pushToRuntime", "end");
    }

    private EventConfigManager.DestinationConfigRuntimePair getRuntimeDestination(String destinationId, EventConfigManager configManager) throws Exception {
        EventConfigManager.DestinationConfigRuntimePair retVal = null;
        retVal = this.mRuntimeDestinationMap.get(destinationId);
        if (retVal == null) {
            oracle.dms.event.Destination runtimeDestination;
            Destination destinationConfig = this.mEventConfig.getDestination(destinationId);
            if (configManager != null) {
                retVal = configManager.findDestination(destinationConfig);
            }
            if (retVal == null && (runtimeDestination = EventConfigurationAdapter.loadDestinationFromDestinationConfig(destinationConfig, sRuntimeValidationLevels)) != null) {
                retVal = new EventConfigManager.DestinationConfigRuntimePair(destinationConfig, runtimeDestination);
            }
            if (retVal != null) {
                this.mRuntimeDestinationMap.put(retVal.getId(), retVal);
            }
        }
        return retVal;
    }

    public static oracle.dms.event.Destination loadDestinationFromDestinationConfig(Destination destinationConfig, Set<Validatable.ValidationLevel> validationLevels) throws ValidationException, ClassUtils.CompoundMapException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String METHOD_NAME = "loadConfigFromConfigDestination";
        LoadableDestination retVal = null;
        String className = destinationConfig.getDestinationClassName();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = cl.loadClass(className);
        Object possibleRetVal = clazz.newInstance();
        retVal = (LoadableDestination)LoadableDestination.class.cast(possibleRetVal);
        String destName = destinationConfig.getDestinationName();
        String destId = destinationConfig.getDestinationId();
        retVal.setName(destName);
        retVal.setId(destId);
        ClassUtils.applyProperties(retVal, destinationConfig.getProperties());
        retVal.validate(validationLevels);
        return retVal;
    }

    private EventConfigManager.FilterConfigRuntimePair getRuntimeFilter(String filterId, oracle.dms.event.Destination runtimeDestination) {
        EventConfigManager.FilterConfigRuntimePair retVal = null;
        retVal = this.mRuntimeFilterMap.get(filterId);
        if (retVal == null) {
            oracle.dms.event.Filter runtimeFilter = null;
            Filter filterConfig = this.mEventConfig.getFilter(filterId);
            if (filterConfig instanceof NullConfigFilter) {
                NullConfigFilter ncf = (NullConfigFilter)filterConfig;
                if (!ncf.getConfigDestination().getDestinationId().equals(runtimeDestination.getId())) {
                    throw new IllegalArgumentException("The id of the config destination and runtime destination must match.");
                }
                runtimeFilter = this.createNullFilter(ncf, runtimeDestination);
            } else if (filterConfig instanceof ConditionFilter) {
                runtimeFilter = this.loadFilterFromFilterConfig((ConditionFilter)filterConfig);
            }
            if (runtimeFilter != null) {
                retVal = new EventConfigManager.FilterConfigRuntimePair(filterConfig, runtimeFilter);
                this.mRuntimeFilterMap.put(runtimeFilter.getId(), retVal);
            }
        }
        return retVal;
    }

    private oracle.dms.event.Filter loadFilterFromFilterConfig(ConditionFilter filterConfig) {
        oracle.dms.trace2.runtime.ConditionFilter retVal;
        block2: {
            String METHOD_NAME = "loadFilterFromFilterConfig";
            retVal = null;
            try {
                String filterName = filterConfig.getFilterName();
                String filterId = filterConfig.getFilterId();
                String eventTypes = filterConfig.getEventTypes();
                oracle.dms.trace2.runtime.Condition condition = this.loadConditionFromConditionConfig(filterConfig._getCondition());
                retVal = new oracle.dms.trace2.runtime.ConditionFilter(filterName, filterId, eventTypes, condition);
            }
            catch (LoadConditionConfigException e) {
                if (!this.m_logger.isLoggable(Level.WARNING)) break block2;
                this.m_logger.logp(Level.WARNING, CLASS_NAME, "loadFilterFromFilterConfig", "DMS-58024", (Object[])new String[]{filterConfig.getFilterId()}, (Throwable)e);
            }
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private oracle.dms.trace2.runtime.Condition loadConditionFromConditionConfig(Condition conditionConfig) throws LoadConditionConfigException {
        void var3_9;
        String METHOD_NAME = "loadConditionFromConditionConfig";
        Object var3_3 = null;
        if (conditionConfig == null) return var3_9;
        if (conditionConfig instanceof AndCondition) {
            AndCondition andConfig = (AndCondition)conditionConfig;
            oracle.dms.trace2.runtime.Condition lh = this.loadConditionFromConditionConfig(andConfig.getLHCondition());
            oracle.dms.trace2.runtime.Condition rh = this.loadConditionFromConditionConfig(andConfig.getRHCondition());
            if (lh == null || rh == null) throw new LoadConditionConfigException("Invalid inner conditions for AND condition : " + (lh == null ? "lh condition was null" : "") + (rh == null ? "rh condition was null" : ""));
            ConditionFilter.AndCondition andCondition = new ConditionFilter.AndCondition(lh, rh);
            return var3_9;
        } else if (conditionConfig instanceof OrCondition) {
            OrCondition orConfig = (OrCondition)conditionConfig;
            oracle.dms.trace2.runtime.Condition lh = this.loadConditionFromConditionConfig(orConfig.getLHCondition());
            oracle.dms.trace2.runtime.Condition rh = this.loadConditionFromConditionConfig(orConfig.getRHCondition());
            if (lh == null || rh == null) throw new LoadConditionConfigException("Invalid inner conditions for OR condition : " + (lh == null ? "lh condition was null" : "") + (rh == null ? "rh condition was null" : ""));
            ConditionFilter.OrCondition orCondition = new ConditionFilter.OrCondition(lh, rh);
            return var3_9;
        } else if (conditionConfig instanceof NounTypeCondition) {
            NounTypeCondition nounTypeConditionConfig = (NounTypeCondition)conditionConfig;
            if (nounTypeConditionConfig.getNounType() == null || nounTypeConditionConfig.getOpType() == null) throw new LoadConditionConfigException("Invalid parameters for NounTypeCondition : " + (nounTypeConditionConfig.getNounType() == null ? "NounType was null. " : "") + (nounTypeConditionConfig.getOpType() == null ? "OpType was null. " : ""));
            ConditionFilter.NounTypeCondition nounTypeCondition = new ConditionFilter.NounTypeCondition(nounTypeConditionConfig.getNounType(), oracle.dms.trace2.runtime.OpType.decodeConfigOpType(nounTypeConditionConfig.getOpType()));
            return var3_9;
        } else if (conditionConfig instanceof ContextCondition) {
            ContextCondition contextConfig = (ContextCondition)conditionConfig;
            if (contextConfig.getOpType() == null || contextConfig.getName() == null) {
                throw new LoadConditionConfigException("Invalid parameters for ContextCondition : " + (contextConfig.getName() == null ? "Context parameter name was null. " : "") + (contextConfig.getOpType() == null ? "OpType was null. " : ""));
            }
            if (contextConfig.getOpType() != OpType.IS_NULL && contextConfig.getOpType() != OpType.ISNULL && contextConfig.getOpType() != OpType.IS_NOT_NULL && contextConfig.getOpType() != OpType.ISNOTNULL && contextConfig.getValue() == null) {
                throw new LoadConditionConfigException("Invalid parameters for ContextCondition : value was null, but opType " + (Object)((Object)contextConfig.getOpType()) + " requires a non null value.");
            }
            String name = contextConfig.getName();
            String value = contextConfig.getValue();
            boolean ignorecase = contextConfig.getIgnoreCase();
            oracle.dms.trace2.runtime.OpType otype = oracle.dms.trace2.runtime.OpType.decodeConfigOpType(contextConfig.getOpType());
            DataType configDataType = DataType.getDataType(contextConfig.getDataType(), value);
            oracle.dms.trace2.runtime.DataType runtimeDataType = oracle.dms.trace2.runtime.DataType.decodeConfigDataType(configDataType);
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, CLASS_NAME, METHOD_NAME, "name=" + name + " value=" + value + " OpType=" + (Object)((Object)otype) + " configDataType =" + (Object)((Object)configDataType) + " runtimeDataType=" + (Object)((Object)runtimeDataType) + " IGNORECASE=" + ignorecase + "\n");
            }
            ConditionFilter.ExecutionContextCondition executionContextCondition = new ConditionFilter.ExecutionContextCondition(name, value, otype, runtimeDataType, ignorecase);
            return var3_9;
        } else {
            if (!(conditionConfig instanceof NestedCondition)) throw new LoadConditionConfigException("Failed to create runtime condition object from configuration. Unknown condition \"" + conditionConfig.getClass().getName() + "\"");
            NestedCondition nestedConfig = (NestedCondition)conditionConfig;
            ConditionFilter.NestedCondition nestedCondition = new ConditionFilter.NestedCondition(this.loadConditionFromConditionConfig(nestedConfig.getCondition()));
        }
        return var3_9;
    }

    private oracle.dms.event.Filter createNullFilter(NullConfigFilter nullConfigFilter, oracle.dms.event.Destination runtimeDestination) {
        if (runtimeDestination == null) {
            throw new IllegalArgumentException("runtimeDestination is required.");
        }
        oracle.dms.event.Filter retVal = null;
        String filterId = nullConfigFilter.getFilterId();
        String filterName = nullConfigFilter.getFilterName();
        retVal = runtimeDestination instanceof FilterProvider ? ((FilterProvider)((Object)runtimeDestination)).getFilter(filterId, filterName) : (runtimeDestination instanceof EventTypeEnthusiast ? new NullFilterWithEventTypeProxy(filterName, filterId, (EventTypeEnthusiast)((Object)runtimeDestination)) : new NullFilterAllEventTypes(filterName, filterId));
        return retVal;
    }

    private static void appendMessage(StringBuilder sb, ResourceBundle rb, String messageKey, String[] messageValues) {
        String messagePattern = rb.getString(messageKey);
        MessageFormat mf = new MessageFormat(messagePattern);
        String message = mf.format(messageValues);
        sb.append(message).append(' ');
    }

    @JSONUtils.JSONFormatToString
    public static class NullConfigFilter
    implements Filter {
        private final Destination mConfigDestination;
        private final String mId;
        private final int mHashCode;
        private final String mString;

        NullConfigFilter(Destination configDestination) {
            if (configDestination == null) {
                throw new IllegalArgumentException("configDestination is required when constructing a NullConfigFilter.");
            }
            this.mConfigDestination = configDestination;
            this.mId = "<Null:" + configDestination.getDestinationId() + ">";
            this.mHashCode = this.mId.hashCode() ^ configDestination.hashCode();
            this.mString = "{\"filterId\":\"" + this.mId + "\",\"type\":\"NullConfigFilter\"}";
        }

        public Destination getConfigDestination() {
            return this.mConfigDestination;
        }

        @Override
        public String getFilterId() {
            return this.mId;
        }

        @Override
        public String getFilterName() {
            return this.mId + " (auto-generated)";
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o == this) {
                retVal = true;
            } else if (o instanceof NullConfigFilter) {
                NullConfigFilter that = (NullConfigFilter)o;
                retVal = ObjectUtils.areEqual(this.mId, that.mId) && ObjectUtils.areEqual(this.mConfigDestination, that.mConfigDestination);
            }
            return retVal;
        }

        public String toString() {
            return this.mString;
        }
    }

    private static class AdaptedEventConfig {
        private EventConfig mSourceConfig;
        private Map<String, Filter> mFilters;
        private Map<String, Destination> mDestinations;
        private Set<EventConfig.EventRouteTuple> mEnabledEventRoutes;
        private String mString;

        AdaptedEventConfig(EventConfig sourceConfig) {
            this.mSourceConfig = sourceConfig;
            this.mEnabledEventRoutes = new HashSet<EventConfig.EventRouteTuple>();
            this.mFilters = new HashMap<String, Filter>();
            this.mDestinations = new HashMap<String, Destination>();
            for (EventConfig.EventRouteTuple ertLoop : this.mSourceConfig.getEnabledEventRoutes()) {
                EventConfig.EventRouteTuple ert = null;
                Filter f = null;
                Destination d = null;
                d = sourceConfig.getDestination(ertLoop.getDestinationId());
                if (ertLoop.getFilterId() == null) {
                    f = new NullConfigFilter(d);
                    ert = new EventConfig.EventRouteTuple(f.getFilterId(), d.getDestinationId(), true);
                } else {
                    f = sourceConfig.getFilter(ertLoop.getFilterId());
                    ert = ertLoop;
                }
                if (f == null || d == null || ert == null) continue;
                this.mFilters.put(f.getFilterId(), f);
                this.mDestinations.put(d.getDestinationId(), d);
                this.mEnabledEventRoutes.add(ert);
            }
        }

        public Collection<Filter> getAllFilters() {
            return this.mFilters.values();
        }

        public Filter getFilter(String filterId) {
            return this.mFilters.get(filterId);
        }

        public Collection<Destination> getAllDestinations() {
            return this.mDestinations.values();
        }

        public Destination getDestination(String destinationId) {
            return this.mDestinations.get(destinationId);
        }

        public Set<EventConfig.EventRouteTuple> getEnabledEventRoutes() {
            return this.mEnabledEventRoutes;
        }

        public String toString() {
            if (this.mString == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("{\"ObjectId\":\"");
                sb.append(this.getClass().getName());
                sb.append("@");
                sb.append(Integer.toHexString(this.hashCode()));
                sb.append("\",");
                sb.append("\"Destinations\":[");
                for (Destination d : this.mDestinations.values()) {
                    sb.append(d.toString());
                }
                sb.append("],");
                sb.append("\"Filters\":[");
                for (Filter f : this.mFilters.values()) {
                    sb.append(f.toString());
                }
                sb.append("],");
                sb.append("\"EventRoutes\":[");
                for (EventConfig.EventRouteTuple ert : this.mEnabledEventRoutes) {
                    sb.append(ert.toString());
                }
                sb.append("]");
                sb.append("}");
                this.mString = sb.toString();
            }
            return this.mString;
        }
    }

    private static class LoadConditionConfigException
    extends Exception {
        LoadConditionConfigException(String s) {
            super(s);
        }
    }
}

