/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.impl.incident.ADRHelper;
import oracle.dfw.impl.incident.AccessCheck;

class ADRSizer
implements DiagnosticsListener {
    private ADRHelper m_adrHelper;
    private String m_adrBase;
    private Logger m_logger;
    private AtomicLong m_maxTotalIncidentSize = new AtomicLong();
    private AtomicLong m_currentSize = new AtomicLong();
    private ReentrantLock m_calculateLock = new ReentrantLock();
    private TreeMap<Long, IncidentDir> m_incDirs = new TreeMap();
    private static long ONE_MB_IN_BYTES = 0x100000L;

    ADRSizer(ADRHelper adrHelper, String adrBase, DiagnosticsConfiguration config, Logger logger) {
        this.m_adrHelper = adrHelper;
        this.m_adrBase = adrBase;
        this.m_logger = logger;
        this.m_maxTotalIncidentSize.set((long)config.getMaxTotalIncidentSize() * ONE_MB_IN_BYTES);
        DiagnosticsEventManager.registerListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        this.m_logger.finer("ADRSizer calculating total space used by all incidents");
        long size = 0L;
        try {
            if (this.m_calculateLock.tryLock()) {
                size = this.calculateSize();
            }
        }
        finally {
            if (this.m_calculateLock.isHeldByCurrentThread()) {
                this.m_calculateLock.unlock();
            }
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.finer("ADRSizer calculated that " + size + " bytes are currently being used by all incidents");
        }
    }

    private long calculateSize() {
        this.m_incDirs.clear();
        long size = 0L;
        List<String> adrHomes = this.m_adrHelper.listADRHomes(this.m_adrBase);
        for (String home : adrHomes) {
            File homeDir = new File(this.m_adrBase, home + File.separatorChar + "incident");
            if (!AccessCheck.exists(homeDir) || !AccessCheck.isDirectory(homeDir)) continue;
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File incDir) {
                    return incDir.isDirectory() && incDir.getName().startsWith("incdir_");
                }
            };
            for (File incDir : AccessCheck.listFiles(homeDir, filter)) {
                long incDirSize = 0L;
                for (File incFile : AccessCheck.listFiles(incDir)) {
                    incDirSize += AccessCheck.length(incFile);
                }
                size += incDirSize;
                String[] incDirName = incDir.getName().split("_");
                if (incDirName == null || incDirName.length != 2) continue;
                try {
                    Long timestamp = AccessCheck.lastModified(incDir) + Long.valueOf(incDirName[1]);
                    this.m_incDirs.put(timestamp, new IncidentDir(home, incDirName[1], incDirSize));
                }
                catch (NumberFormatException e) {
                    this.m_logger.log(Level.FINER, "directory " + incDir.getName() + " is not a valid incident directory name. ADRSizer " + " will exclude it when processing incident size", e);
                }
            }
        }
        this.m_currentSize.set(size);
        return size;
    }

    private void cleanup() {
        long size;
        this.m_logger.finer("ADRSizer attempting to clean up old incidensts");
        boolean calculatedSize = false;
        if (this.m_incDirs.isEmpty()) {
            this.m_logger.finer("ADRSizer calculating total space used by all incidents");
            size = this.calculateSize();
            calculatedSize = true;
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.finer("ADRSizer calculated that " + size + " bytes are currently being used by all incidents");
            }
        }
        if (!this.m_incDirs.isEmpty()) {
            this.cleanupIncDirs();
            if (!calculatedSize && this.m_currentSize.get() >= this.m_maxTotalIncidentSize.get()) {
                this.m_logger.finer("ADRSizer calculating total space used by all incidents");
                size = this.calculateSize();
                calculatedSize = true;
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.finer("ADRSizer calculated that " + size + " bytes are currently being used by all incidents");
                }
                this.cleanupIncDirs();
            }
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.finer("ADRSizer calculated that " + this.m_currentSize + " bytes have been used after cleanup");
        }
    }

    private void cleanupIncDirs() {
        Vector<Long> toRemove = new Vector<Long>();
        for (Map.Entry<Long, IncidentDir> dir : this.m_incDirs.entrySet()) {
            if (this.m_currentSize.get() < this.m_maxTotalIncidentSize.get()) break;
            IncidentDir incDir = dir.getValue();
            boolean purged = this.m_adrHelper.purgeIncident(this.m_adrBase, incDir.m_adrHome, incDir.m_incidentId);
            toRemove.add(dir.getKey());
            if (!purged) continue;
            this.m_currentSize.addAndGet(0L - incDir.m_size);
        }
        for (Long removeKey : toRemove) {
            this.m_incDirs.remove(removeKey);
        }
    }

    void incrementSize(long size) {
        this.m_currentSize.addAndGet(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSpaceAvailable() {
        boolean spaceAvailable = false;
        if (this.m_currentSize.get() >= this.m_maxTotalIncidentSize.get()) {
            try {
                if (this.m_calculateLock.tryLock()) {
                    this.cleanup();
                }
            }
            finally {
                if (this.m_calculateLock.isHeldByCurrentThread()) {
                    this.m_calculateLock.unlock();
                }
            }
            if (this.m_currentSize.get() < this.m_maxTotalIncidentSize.get()) {
                spaceAvailable = true;
            }
        } else {
            spaceAvailable = true;
        }
        return spaceAvailable;
    }

    public long getMaxTotalIncidentSize() {
        return this.m_maxTotalIncidentSize.get();
    }

    public long getActualTotalIncidentSize() {
        return this.m_currentSize.get();
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        if (event instanceof DiagnosticsConfigurationChangedEvent) {
            DiagnosticsConfiguration config = ((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration();
            if (this.m_maxTotalIncidentSize.get() != (long)config.getMaxTotalIncidentSize()) {
                this.m_maxTotalIncidentSize.set((long)config.getMaxTotalIncidentSize() * ONE_MB_IN_BYTES);
            }
        }
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }

    private static class IncidentDir {
        String m_adrHome;
        String m_incidentId;
        long m_size;

        IncidentDir(String adrHome, String incidentId, long size) {
            this.m_adrHome = adrHome;
            this.m_incidentId = incidentId;
            this.m_size = size;
        }
    }
}

