/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.File;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportFactory;

public class PlatformSupportNotJRF
implements PlatformSupport {
    private Platform mPlatform;
    private String mServerName;
    private String mDomainHome;
    private String mDomainConfigDirectory;
    private String mServerConfigDirectory;
    private String mServerLogDirectory;
    private String mClusterName;
    private boolean mIsAdminServer;
    private boolean mIsDomainManager;
    private static final String CONFIG_DIR = "config";
    private static final String FMW_CONFIG_DIR = "fmwconfig";
    private static final String DMS_CONFIG_XML_FILE = "dms_config.xml";

    public PlatformSupportNotJRF(Platform platform) {
        String serverName = DMSProperties.getProperty("oracle.server.name");
        if (serverName == null) {
            serverName = DMSProperties.getProperty("weblogic.Name");
        }
        if (serverName == null || serverName.trim().length() == 0) {
            serverName = "proc" + DMSUtil.getProcessID();
        }
        this.initState(platform, serverName);
    }

    public PlatformSupportNotJRF(Platform platform, String serverName) {
        this.initState(platform, serverName);
    }

    private void initState(Platform platform, String serverName) {
        if (serverName == null) {
            throw new IllegalArgumentException("serverName must not be null.");
        }
        this.mPlatform = platform;
        if (platform == Platform.WebLogic) {
            this.mIsAdminServer = false;
            this.mIsDomainManager = false;
        } else if (platform == Platform.WebLogicAS) {
            this.mIsAdminServer = true;
            this.mIsDomainManager = false;
        } else if (platform == Platform.WebSphere) {
            this.mIsAdminServer = false;
            this.mIsDomainManager = false;
        } else if (platform == Platform.WebSphereAS) {
            this.mIsAdminServer = false;
            this.mIsDomainManager = true;
        } else if (platform == Platform.WebSphereND) {
            this.mIsAdminServer = false;
            this.mIsDomainManager = false;
        }
        this.mDomainHome = PlatformSupportFactory.getenv("DOMAIN_HOME");
        if (this.mDomainHome == null) {
            this.mDomainHome = DMSProperties.getProperty("domain.home");
        }
        this.mServerName = serverName;
        this.mDomainConfigDirectory = DMSProperties.getProperty("oracle.domain.config.dir");
        if (this.mDomainConfigDirectory == null && this.mDomainHome != null) {
            this.mDomainConfigDirectory = this.mDomainHome + File.separatorChar + CONFIG_DIR + File.separatorChar + FMW_CONFIG_DIR;
        }
        this.mServerConfigDirectory = DMSProperties.getProperty("oracle.server.config.dir");
        if (this.mServerConfigDirectory == null && this.mDomainHome != null && this.mServerName != null) {
            this.mServerConfigDirectory = this.mDomainHome + File.separatorChar + CONFIG_DIR + File.separatorChar + FMW_CONFIG_DIR + File.separatorChar + "servers" + File.separatorChar + this.mServerName;
        }
        this.mServerLogDirectory = DMSProperties.getProperty("oracle.server.log.dir");
        if (this.mServerLogDirectory == null) {
            this.mServerLogDirectory = this.mServerConfigDirectory + File.separatorChar + "logs";
        }
        this.mClusterName = DMSProperties.getProperty("oracle.cluster.name");
    }

    @Override
    public Platform getPlatform() {
        return this.mPlatform;
    }

    @Override
    public String getServerName() {
        return this.mServerName;
    }

    public String getDomainHome() {
        return this.mDomainHome;
    }

    @Override
    public String getDomainConfigDirectory() {
        return this.mDomainConfigDirectory;
    }

    @Override
    public String getServerConfigDirectory(String s1, String s2) {
        return this.mServerConfigDirectory;
    }

    @Override
    public String getServerConfigDirectory() {
        return this.mServerConfigDirectory;
    }

    @Override
    public String getConfigFilename() {
        String serverConfigDir = this.getServerConfigDirectory();
        String domainConfigDir = this.getDomainConfigDirectory();
        String configFilename = null;
        if (serverConfigDir != null) {
            configFilename = serverConfigDir + File.separator + DMS_CONFIG_XML_FILE;
        }
        if (!(configFilename != null && new File(configFilename).canRead() || domainConfigDir == null)) {
            configFilename = domainConfigDir + File.separator + DMS_CONFIG_XML_FILE;
        }
        return configFilename;
    }

    @Override
    public String getServerLogPath() {
        return this.mServerLogDirectory;
    }

    @Override
    public String getClusterName() {
        return this.mClusterName;
    }

    @Override
    public boolean isAdminServer() {
        return this.mIsAdminServer;
    }

    @Override
    public boolean isDeploymentManager() {
        return this.mIsDomainManager;
    }
}

