/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.config.Config;
import oracle.dms.config.ConfigChild;
import oracle.dms.config.DMSConfigurationException;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.EventType;
import oracle.dms.event.FilterProvider;
import oracle.dms.event.LoadableDestination;
import oracle.dms.event.config.AndCondition;
import oracle.dms.event.config.Condition;
import oracle.dms.event.config.ConditionFilter;
import oracle.dms.event.config.ConditionParser;
import oracle.dms.event.config.ContextCondition;
import oracle.dms.event.config.DataType;
import oracle.dms.event.config.Destination;
import oracle.dms.event.config.DestinationProperty;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.event.config.EventConfigurationAdapter;
import oracle.dms.event.config.Filter;
import oracle.dms.event.config.NounTypeCondition;
import oracle.dms.event.config.NounTypeOpType;
import oracle.dms.event.config.OpType;
import oracle.dms.event.config.OrCondition;
import oracle.dms.jfr.JFREnvironmentInspector;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupportFactory;
import oracle.dms.util.Time;
import oracle.dms.util.Validatable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JSONUtils.JSONFormatToString
public class EventConfig
implements ConfigChild {
    private static final String SCHEMA_NAME_SPACE = "http://xmlns.oracle.com/dms/DMSConfiguration/V2";
    private static final String EVENT_ELEMENT_NAME = "eventConfiguration";
    private static final String DESTINATIONS_ELEMENT_NAME = "destinations";
    private static final String DESTINATION_ELEMENT_NAME = "destination";
    private static final String PROPERTIES_ELEMENT_NAME = "properties";
    private static final String PROPERTY_ELEMENT_NAME = "property";
    private static final String FILTERS_ELEMENT_NAME = "filters";
    private static final String CONDITION_FILTER_ELEMENT_NAME = "conditionFilter";
    private static final String CONDITION_ELEMENT_NAME = "condition";
    private static final String EVENTROUTINGTABLE_ELEMENT_NAME = "eventRoutingTable";
    private static final String EVENTROUTE_ELEMENT_NAME = "eventRoute";
    private static final String TEXTCONDITION_ELEMENT_NAME = "textCondition";
    private static final String JFR_DESTINATION_CLASS = "oracle.dms.jfr.JFRDestination";
    private static final String LOGGER_DESTINATION_LOGGERNAME_VALUE = "DMSEventTraceLoggerDestination";
    private static final String LOGGER_DESTINATION_LOGGERNAME = "loggerName";
    private ODLLogger m_logger;
    private Map<String, Map<String, Boolean>> m_eventRoute = new HashMap<String, Map<String, Boolean>>();
    private Map<String, Destination> m_destinations = new HashMap<String, Destination>();
    private Map<String, Filter> m_filters = new HashMap<String, Filter>();
    private static final String LOGGER_NAME = "oracle.dms.event";
    private static final String CLASS_NAME = EventConfig.class.getName();
    private static final String STRING_CONDITION = "condition";
    private long m_ConfigTimeStamp;
    private long mLastActivation;
    private boolean m_UpdatesPending;
    private boolean m_ConfigActivated;
    private boolean m_isRuntime;
    private static Set<Validatable.ValidationLevel> sConfigValidationLevels = EnumSet.of(Validatable.ValidationLevel.INTERNAL_STATE);

    public EventConfig() {
        this.m_logger = ODLLogger.getODLLogger((String)LOGGER_NAME, (String)EventResourceBundle.class.getName());
        this.mLastActivation = Long.MIN_VALUE;
    }

    @Deprecated
    public Element getElement(Document document) throws EventConfigException {
        Element retVal = null;
        try {
            retVal = this.buildElement(document);
        }
        catch (Exception e) {
            throw new EventConfigException("DMS-58056", e);
        }
        return retVal;
    }

    public void setRuntime(boolean isRuntime) {
        this.m_isRuntime = isRuntime;
    }

    public synchronized void syncAndActivateConfiguration(EventConfig updatedConfig) throws EventConfigException, TransformerConfigurationException, ParserConfigurationException, TransformerException {
        this.syncConfig(updatedConfig);
        this.activateConfiguration();
    }

    public synchronized void activateConfiguration() throws EventConfigException, TransformerConfigurationException, ParserConfigurationException, TransformerException {
        EventConfigurationAdapter mgr = new EventConfigurationAdapter(this);
        try {
            mgr.pushToRuntime();
        }
        catch (Exception e) {
            throw new EventConfigException("DMS-58057", e);
        }
        this.mLastActivation = Time.currentTimeMillis();
        this.setConfigurationActivated(true);
    }

    public void setConfigurationActivated(boolean activated) {
        this.m_ConfigActivated = activated;
    }

    protected boolean isConfigActivated() {
        return this.m_ConfigActivated;
    }

    @Override
    public void setConfigurationUpdated(boolean updated) {
        this.m_UpdatesPending = updated;
    }

    protected void setLastConfigActivationTime(long atime) {
        this.m_ConfigTimeStamp = atime;
    }

    @Deprecated
    public synchronized void sync(EventConfig updatedConfig) throws EventConfigException {
        if (!this.m_isRuntime) {
            this.syncConfig(updatedConfig);
        }
    }

    @Override
    public synchronized void sync(Config pendingConfig) throws DMSConfigurationException {
        if (!this.m_isRuntime) {
            this.syncConfig(pendingConfig.getEventConfig());
        }
    }

    private synchronized void syncConfig(EventConfig updatedConfig) throws EventConfigException {
        String METHOD_NAME = "sync";
        if (this.m_logger.isLoggable(Level.FINER)) {
            String msg = "START sync:" + Time.currentTimeMillis();
            this.m_logger.logp(Level.FINER, CLASS_NAME, "sync", msg);
        }
        this.m_destinations = updatedConfig.m_destinations;
        this.m_eventRoute = updatedConfig.m_eventRoute;
        this.m_filters = updatedConfig.m_filters;
    }

    public void addFilter(String id, String name, String eventTypesString, Map<String, String> props) throws EventConfigException {
        if (id == null || props.isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments passed to EventConfig.addFilter; id=" + id + ";props=" + props);
        }
        String stringCondition = props.get("condition");
        if (stringCondition == null) {
            stringCondition = props.get("condition".toUpperCase());
        }
        Condition filterCondition = null;
        if (stringCondition != null) {
            ConditionParser parseCondition = new ConditionParser();
            try {
                filterCondition = parseCondition.parse(stringCondition);
            }
            catch (Exception e) {
                EventConfigException ec = new EventConfigException("DMS-58058", e);
                ec.addToken(stringCondition);
                ec.addToken(id);
                throw ec;
            }
        }
        ConditionFilter filter = new ConditionFilter(id, filterCondition, stringCondition);
        if (name != null) {
            filter.setFilterName(name);
        }
        filter.setEventTypes(eventTypesString);
        this.addFilter(filter);
        this.m_UpdatesPending = true;
    }

    @Deprecated
    public synchronized void addFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("invalid arguments to addFilter; filter=" + filter);
        }
        this.m_filters.put(filter.getFilterId(), filter);
        this.m_UpdatesPending = true;
    }

    public synchronized void removeFilter(String filterId) throws EventConfigException {
        if (!DMSUtil.isLegalIdentifier(filterId)) {
            throw new IllegalArgumentException("invalid arguments to removeFilter; filterId=" + filterId + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        String METHOD_NAME = "removeFilter";
        Map<String, Boolean> destinations = this.getEventRouteStatus(filterId, true);
        if (!destinations.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            List<EventRouteTuple> currentRoutes = this.getEventRoutesAsFlatList();
            for (EventRouteTuple currentRoute : currentRoutes) {
                if (!currentRoute.mFilterId.equals(filterId)) continue;
                msg.append(currentRoute.mDestinationId + " ");
            }
            this.m_logger.logp(Level.FINE, CLASS_NAME, "removeFilter", "DMS-58060", (Object[])new String[]{filterId, msg.toString()});
            EventConfigException ec = new EventConfigException("DMS-58060");
            ec.addToken(filterId);
            ec.addToken(msg.toString());
            throw ec;
        }
        this.m_filters.remove(filterId);
        this.m_UpdatesPending = true;
    }

    public synchronized Filter getFilter(String filterId) {
        if (!DMSUtil.isLegalIdentifier(filterId)) {
            throw new IllegalArgumentException("invalid arguments to getFilter; filterId=" + filterId + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        return this.m_filters.get(filterId);
    }

    public String getFilterCondition(String filterId) {
        String retVal = null;
        try {
            ConditionFilter filter = null;
            filter = (ConditionFilter)this.getFilter(filterId);
            retVal = filter.getConditionAsString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("filter; " + filterId + " does not exist", e);
        }
        return retVal;
    }

    public synchronized Set<String> getActiveFilterIDs() {
        return this.m_eventRoute.keySet();
    }

    public synchronized Collection<Filter> getAllFilters() {
        return this.m_filters.values();
    }

    public synchronized void addDestination(Destination destination) throws EventConfigException {
        if (destination == null) {
            throw new IllegalArgumentException("invalid arguments to addDestination. Destination=" + destination);
        }
        this.validateDestination(destination, false);
        this.m_destinations.put(destination.getDestinationId(), destination);
        this.m_UpdatesPending = true;
    }

    public synchronized void removeDestination(String destinationId) throws EventConfigException {
        if (!DMSUtil.isLegalIdentifier(destinationId)) {
            throw new IllegalArgumentException("invalid argument to removeDestination; destinationId=" + destinationId + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        String METHOD_NAME = "removeDestination";
        if (this.m_destinations.containsKey(destinationId)) {
            for (Map.Entry<String, Map<String, Boolean>> mapping : this.m_eventRoute.entrySet()) {
                if (!mapping.getValue().containsKey(destinationId)) continue;
                StringBuilder msg = new StringBuilder();
                List<EventRouteTuple> currentRoutes = this.getEventRoutesAsFlatList();
                for (EventRouteTuple currentRoute : currentRoutes) {
                    if (!currentRoute.mDestinationId.equals(destinationId)) continue;
                    msg.append(currentRoute.mFilterId + " ");
                }
                this.m_logger.logp(Level.FINE, CLASS_NAME, "removeDestination", "DMS-58059", (Object[])new String[]{destinationId, msg.toString()});
                EventConfigException ec = new EventConfigException("DMS-58059");
                ec.addToken(destinationId);
                ec.addToken(msg.toString());
                throw ec;
            }
            this.m_destinations.remove(destinationId);
            this.m_UpdatesPending = true;
        }
    }

    public synchronized Destination getDestination(String destinationId) {
        if (!DMSUtil.isLegalIdentifier(destinationId)) {
            throw new IllegalArgumentException("invalid argument to getDestination; destinationId=" + destinationId + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        return this.m_destinations.get(destinationId);
    }

    public synchronized Collection<Destination> getAllDestinations() {
        return this.m_destinations.values();
    }

    public synchronized void addEventRoute(String filterId, String destinationId) throws EventConfigException {
        Map<String, Boolean> destinationStatus = this.getEventRouteStatus(filterId, true);
        if (!destinationStatus.containsKey(destinationId)) {
            this.addEventRoute(filterId, destinationId, true);
            this.m_UpdatesPending = true;
        }
    }

    public synchronized void addEventRoute(String filterId, String destinationId, boolean enabled) throws EventConfigException {
        if (!DMSUtil.isLegalIdentifier(destinationId)) {
            throw new IllegalArgumentException("invalid destinationId passed to addEventRoute; filterId=" + filterId + " destinationId=" + destinationId + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        if (filterId != null && !DMSUtil.isLegalIdentifier(filterId)) {
            throw new IllegalArgumentException("invalid filterId passed to addEventRoute; filterId=" + filterId + " destinationId=" + destinationId + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        if ((filterId == null || this.m_filters.containsKey(filterId)) && this.m_destinations.containsKey(destinationId)) {
            this.validateDestination(this.m_destinations.get(destinationId), filterId != null);
            Map<String, Boolean> destinations = this.m_eventRoute.get(filterId);
            if (destinations == null) {
                destinations = new HashMap<String, Boolean>();
                destinations.put(destinationId, enabled);
                this.m_eventRoute.put(filterId, destinations);
                this.m_UpdatesPending = true;
            } else if (destinations.containsKey(destinationId)) {
                Boolean currentEnabled = destinations.get(destinationId);
                if (!currentEnabled.equals(enabled)) {
                    destinations.put(destinationId, enabled);
                    this.m_eventRoute.put(filterId, destinations);
                    this.m_UpdatesPending = true;
                }
            } else {
                destinations.put(destinationId, enabled);
                this.m_eventRoute.put(filterId, destinations);
                this.m_UpdatesPending = true;
            }
        } else {
            String msg = "invalid argument to addEventRoute for filterId=" + filterId + " destinationId=" + destinationId + ". ";
            if (filterId == null) {
                msg = " The destination does not exist. filterId=" + filterId + " destinationId=" + destinationId;
            } else {
                if (!this.m_filters.containsKey(filterId)) {
                    msg = msg + " The filter '" + filterId + "' does not exist.";
                }
                if (!this.m_destinations.containsKey(destinationId)) {
                    msg = msg + "The destination '" + destinationId + "' does not exist.";
                }
            }
            throw new IllegalArgumentException(msg);
        }
    }

    public synchronized void removeEventRoute(String filterId, String destinationId) {
        if (destinationId == null) {
            this.m_eventRoute.remove(filterId);
        } else if (this.m_eventRoute.containsKey(filterId)) {
            this.m_eventRoute.get(filterId).remove(destinationId);
            if (this.m_eventRoute.get(filterId).isEmpty()) {
                this.m_eventRoute.remove(filterId);
                this.m_UpdatesPending = true;
            }
        }
    }

    @Deprecated
    public synchronized List<String> getEventRoutes(String filterId) {
        List<String> retVal = Collections.emptyList();
        if (this.m_eventRoute.containsKey(filterId)) {
            ArrayList<String> destinationStatusList = new ArrayList<String>();
            if (this.m_eventRoute.containsKey(filterId)) {
                Map<String, Boolean> statusMap = this.m_eventRoute.get(filterId);
                for (Map.Entry<String, Boolean> dest : statusMap.entrySet()) {
                    destinationStatusList.add(dest.getKey());
                }
            }
            retVal = destinationStatusList;
        }
        return retVal;
    }

    public synchronized Map<String, Boolean> getEventRouteStatus(String id, boolean isFilter) {
        Map<String, Boolean> retVal = Collections.emptyMap();
        if (isFilter) {
            if (this.m_eventRoute.containsKey(id)) {
                Map<String, Boolean> statusMap = this.m_eventRoute.get(id);
                retVal = statusMap;
            }
        } else {
            List<EventRouteTuple> eventRoutes = this.getEventRoutesAsFlatList();
            HashMap<String, Boolean> filterStatusMap = new HashMap<String, Boolean>();
            for (EventRouteTuple route : eventRoutes) {
                if (!route.mDestinationId.equals(id)) continue;
                filterStatusMap.put(route.mFilterId, route.mEnabled);
            }
            if (!filterStatusMap.isEmpty()) {
                retVal = filterStatusMap;
            }
        }
        return retVal;
    }

    public Map<String, Map<String, Boolean>> getAllEventRouteStatus() {
        return this.m_eventRoute;
    }

    public Set<EventRouteTuple> getEnabledEventRoutes() {
        HashSet<EventRouteTuple> retVal = new HashSet<EventRouteTuple>();
        if (this.m_eventRoute.size() > 0) {
            for (Map.Entry<String, Map<String, Boolean>> destEntry : this.m_eventRoute.entrySet()) {
                if (destEntry.getValue() == null) continue;
                for (Map.Entry<String, Boolean> filterEntry : destEntry.getValue().entrySet()) {
                    if (!filterEntry.getValue().booleanValue()) continue;
                    EventRouteTuple t = new EventRouteTuple(destEntry.getKey(), filterEntry.getKey(), true);
                    retVal.add(t);
                }
            }
        }
        return retVal;
    }

    @Override
    public boolean isConfigurationUpdated() {
        return this.m_UpdatesPending;
    }

    void validateDestination(Destination destination, boolean failIfFilterProvider) throws EventConfigException {
        EventConfigException ec;
        JFREnvironmentInspector.Availability availability;
        String METHOD_NAME = "validateDestination";
        String className = destination.getDestinationClassName();
        if (className.equals(JFR_DESTINATION_CLASS) && (availability = JFREnvironmentInspector.isFlightRecorderAvailable()) != JFREnvironmentInspector.Availability.AVAILABLE) {
            EventConfigException ec2;
            Platform platform = PlatformSupportFactory.getPlatformSupport().getPlatform();
            String vmName = DMSProperties.getProperty("java.vm.name");
            String vmVersion = DMSProperties.getProperty("java.vm.version");
            String vmSpecVersion = DMSProperties.getProperty("java.vm.specification.version");
            if (availability == JFREnvironmentInspector.Availability.SUPPORTED_BUT_NOT_AVAILABLE) {
                ec2 = new EventConfigException("DMS-58081");
                ec2.addToken(destination.getDestinationId());
                ec2.addToken(platform.toString());
                ec2.addToken("{'name'='" + vmName + "', 'version'='" + vmVersion + "', 'spec-version'='" + vmSpecVersion + "'}");
            } else {
                ec2 = new EventConfigException("DMS-58070");
                ec2.addToken(destination.getDestinationId());
                ec2.addToken(platform.toString());
                ec2.addToken("{'name'='" + vmName + "', 'version'='" + vmVersion + "', 'spec-version'='" + vmSpecVersion + "'}");
                ec2.addToken(availability.toString());
            }
            ec2.put("JFREnvironmentInspector.Availability", availability);
            throw ec2;
        }
        Class<?> destinationClass = null;
        try {
            destinationClass = Class.forName(className);
        }
        catch (Throwable e) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, CLASS_NAME, "validateDestination", "DMS-58061", (Object[])new String[]{className, destination.getDestinationId()});
            }
            EventConfigException ec3 = new EventConfigException("DMS-58061");
            ec3.addToken(className);
            ec3.addToken(destination.getDestinationId());
            throw ec3;
        }
        for (Method m : destinationClass.getMethods()) {
            if (!ClassUtils.isSetterMethod(m) || !m.isAnnotationPresent(DestinationProperty.class)) continue;
            DestinationProperty destinationAnnotation = m.getAnnotation(DestinationProperty.class);
            String propertyName = ClassUtils.getPropertyNameForSetMethod(m);
            if (!destinationAnnotation.isMandatory() || destination.getProperty(propertyName) != null) continue;
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINE, CLASS_NAME, "validateDestination", "DMS-58062", (Object[])new String[]{propertyName, destination.getDestinationId(), destination.getDestinationClassName()});
            }
            EventConfigException ec4 = new EventConfigException("DMS-58062");
            ec4.addToken(propertyName);
            ec4.addToken(destination.getDestinationId());
            ec4.addToken(destination.getDestinationClassName());
            throw ec4;
        }
        Map<String, String> props = destination.getProperties();
        String unsupportedPropertiesList = null;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String propertyName = entry.getKey();
            Method method = ClassUtils.getSetMethodForProperty(destinationClass, propertyName);
            if (method != null) continue;
            if (unsupportedPropertiesList == null) {
                unsupportedPropertiesList = propertyName;
                continue;
            }
            unsupportedPropertiesList = unsupportedPropertiesList + ", " + propertyName;
        }
        if (unsupportedPropertiesList != null) {
            String supportedPropertyNames = "";
            List<String> propertiesList = ClassUtils.getWriteablePropertyNamesForClass(destinationClass);
            if (propertiesList.size() > 0) {
                StringBuilder sb = new StringBuilder();
                boolean addComma = false;
                for (String propertyName : propertiesList) {
                    if ("id".equals(propertyName) || "name".equals(propertyName)) continue;
                    if (addComma) {
                        sb.append(", ");
                    }
                    sb.append(propertyName);
                    addComma = true;
                }
                supportedPropertyNames = sb.toString();
            }
            ec = null;
            String destinationID = destination.getDestinationId();
            if (supportedPropertyNames.isEmpty()) {
                ec = new EventConfigException("DMS-60004");
                ec.addToken(destinationID);
                ec.addToken(unsupportedPropertiesList);
            } else {
                ec = new EventConfigException("DMS-58071");
                ec.addToken(destinationID);
                ec.addToken(unsupportedPropertiesList);
                ec.addToken(supportedPropertyNames);
            }
            throw ec;
        }
        try {
            String destName = destination.getDestinationName();
            String destId = destination.getDestinationId();
            Object objectInstance = destinationClass.newInstance();
            LoadableDestination destinationInstance = (LoadableDestination)LoadableDestination.class.cast(objectInstance);
            destinationInstance.setName(destName);
            destinationInstance.setId(destId);
            ClassUtils.applyProperties(destinationInstance, destination.getProperties());
            destinationInstance.validate(sConfigValidationLevels);
        }
        catch (Exception e) {
            EventConfigException ec5 = new EventConfigException("DMS-58080", e);
            ec5.addToken(destination.getDestinationId());
            throw ec5;
        }
        if (failIfFilterProvider) {
            HashSet destinationInterfaces = new HashSet();
            for (Class<?> c = destinationClass; c != null; c = c.getSuperclass()) {
                if (c.getInterfaces() == null) continue;
                for (Class<?> i : c.getInterfaces()) {
                    destinationInterfaces.add(i);
                }
            }
            if (destinationInterfaces.contains(FilterProvider.class)) {
                ec = new EventConfigException("DMS-58063");
                ec.addToken(className);
                ec.addToken(destination.getDestinationId());
                throw ec;
            }
        }
    }

    private List<EventRouteTuple> getEventRoutesAsFlatList() {
        ArrayList<EventRouteTuple> retVal = new ArrayList<EventRouteTuple>();
        for (Map.Entry<String, Map<String, Boolean>> entry : this.m_eventRoute.entrySet()) {
            for (Map.Entry<String, Boolean> destEnableEntry : entry.getValue().entrySet()) {
                retVal.add(new EventRouteTuple(entry.getKey(), destEnableEntry.getKey(), destEnableEntry.getValue()));
            }
        }
        return retVal;
    }

    boolean isDestinationIdUsedInActiveEventRoute(String destinationId, boolean considerNonNullFilterIdsOnly) {
        boolean retVal = false;
        List<EventRouteTuple> eventRoutes = this.getEventRoutesAsFlatList();
        for (EventRouteTuple tuple : eventRoutes) {
            if (!tuple.mEnabled || !tuple.mDestinationId.equals(destinationId)) continue;
            if (considerNonNullFilterIdsOnly) {
                if (tuple.mFilterId == null) continue;
                retVal = true;
                break;
            }
            retVal = true;
            break;
        }
        return retVal;
    }

    @Override
    public Element buildElement(Document document) throws EventConfigException, ParserConfigurationException {
        Element xevent = document.createElementNS(SCHEMA_NAME_SPACE, EVENT_ELEMENT_NAME);
        Element xdestinations = document.createElementNS(SCHEMA_NAME_SPACE, DESTINATIONS_ELEMENT_NAME);
        xevent.appendChild(xdestinations);
        Collection<Destination> destinations = this.getAllDestinations();
        for (Destination dest : destinations) {
            String dclass = dest.getDestinationClassName();
            String name = dest.getDestinationName();
            String id = dest.getDestinationId();
            Element xdestination = document.createElementNS(SCHEMA_NAME_SPACE, DESTINATION_ELEMENT_NAME);
            xdestination.setAttribute("class", dclass);
            xdestination.setAttribute("name", name);
            xdestination.setAttribute("id", id);
            xdestinations.appendChild(xdestination);
            Element xproperties = document.createElementNS(SCHEMA_NAME_SPACE, PROPERTIES_ELEMENT_NAME);
            xdestination.appendChild(xproperties);
            Map<String, String> properties = dest.getProperties();
            if (properties == null) continue;
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String pname = entry.getKey().toString();
                String pvalue = entry.getValue().toString();
                Element xproperty = document.createElementNS(SCHEMA_NAME_SPACE, PROPERTY_ELEMENT_NAME);
                xproperties.appendChild(xproperty);
                xproperty.setAttribute("name", pname);
                xproperty.setAttribute("value", pvalue);
                xproperties.appendChild(xproperty);
            }
        }
        Element xFilters = document.createElementNS(SCHEMA_NAME_SPACE, FILTERS_ELEMENT_NAME);
        xevent.appendChild(xFilters);
        Collection<Filter> filters = null;
        filters = this.getAllFilters();
        for (Filter filter : filters) {
            String con;
            if (!(filter instanceof ConditionFilter)) continue;
            ConditionFilter conditionFilter = (ConditionFilter)filter;
            Element xconditionFilter = document.createElementNS(SCHEMA_NAME_SPACE, CONDITION_FILTER_ELEMENT_NAME);
            xconditionFilter.setAttribute("id", conditionFilter.getFilterId());
            xconditionFilter.setAttribute("name", conditionFilter.getFilterName());
            if (conditionFilter.getEventTypes() != null) {
                xconditionFilter.setAttribute("eventTypes", conditionFilter.getEventTypes());
            }
            if ((con = conditionFilter.getConditionAsString()) != null) {
                this.buildConditionElement(con, xconditionFilter, document);
            }
            xFilters.appendChild(xconditionFilter);
        }
        Element xeventRoutingTable = document.createElementNS(SCHEMA_NAME_SPACE, EVENTROUTINGTABLE_ELEMENT_NAME);
        xevent.appendChild(xeventRoutingTable);
        for (Filter filter : filters) {
            Map<String, Boolean> destinations2 = this.getEventRouteStatus(filter.getFilterId(), true);
            for (Map.Entry<String, Boolean> destEnableEntry : destinations2.entrySet()) {
                Element xeventRoute = document.createElementNS(SCHEMA_NAME_SPACE, EVENTROUTE_ELEMENT_NAME);
                xeventRoute.setAttribute("filterId", filter.getFilterId());
                xeventRoute.setAttribute("destinationId", destEnableEntry.getKey());
                xeventRoute.setAttribute("enabled", String.valueOf(destEnableEntry.getValue()));
                xeventRoutingTable.appendChild(xeventRoute);
            }
        }
        Map<String, Boolean> destinations2 = this.getEventRouteStatus(null, true);
        for (Map.Entry<String, Boolean> destEnableEntry : destinations2.entrySet()) {
            Element xeventRoute = document.createElementNS(SCHEMA_NAME_SPACE, EVENTROUTE_ELEMENT_NAME);
            xeventRoute.setAttribute("filterId", null);
            xeventRoute.setAttribute("destinationId", destEnableEntry.getKey());
            xeventRoute.setAttribute("enabled", String.valueOf(destEnableEntry.getValue()));
            xeventRoutingTable.appendChild(xeventRoute);
        }
        xevent.appendChild(xeventRoutingTable);
        return xevent;
    }

    @Override
    public synchronized void parseConfigDocument(Element xdms) throws DMSConfigurationException {
        if (xdms == null) {
            throw new IllegalArgumentException("xdms=null");
        }
        NodeList nodes = xdms.getElementsByTagName(EVENT_ELEMENT_NAME);
        Element xevent = (Element)nodes.item(0);
        try {
            this.buildEventConfig(xevent);
        }
        catch (Exception e) {
            String mesg = DMSUtil.errorMessage("50727", new Object[0]);
            throw new DMSConfigurationException(mesg, e);
        }
    }

    public void buildEventConfig(Element xevent) throws EventConfigException {
        String name;
        String METHOD_NAME = "buildEventConfig";
        int nodeLength = 0;
        int destinationNodeLength = 0;
        if (xevent == null) {
            this.m_logger.logp(Level.FINE, CLASS_NAME, "buildEventConfig", "DMS-58064");
            throw new EventConfigException("DMS-58064");
        }
        NodeList nodes = xevent.getElementsByTagName(DESTINATION_ELEMENT_NAME);
        nodeLength = nodes.getLength();
        ArrayList<String> badDestination = new ArrayList<String>();
        for (int destinationIterator = 0; destinationIterator < nodeLength; ++destinationIterator) {
            String id = null;
            String className = null;
            name = null;
            id = ((Element)nodes.item(destinationIterator)).getAttribute("id");
            className = ((Element)nodes.item(destinationIterator)).getAttribute("class");
            name = ((Element)nodes.item(destinationIterator)).getAttribute("name");
            if ("oracle.dms.jrockit.jfr.JFRDestination".equals(className)) {
                className = JFR_DESTINATION_CLASS;
            }
            Destination destination = new Destination(id, className);
            destination.setDestinationName(name);
            NodeList dnodes = ((Element)nodes.item(destinationIterator)).getElementsByTagName(PROPERTY_ELEMENT_NAME);
            destinationNodeLength = dnodes.getLength();
            for (int propertiesIterator = 0; propertiesIterator < destinationNodeLength; ++propertiesIterator) {
                String propertyName = ((Element)dnodes.item(propertiesIterator)).getAttribute("name");
                String propertyValue = ((Element)dnodes.item(propertiesIterator)).getAttribute("value");
                destination.setProperty(propertyName, propertyValue);
                this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "destination= " + destination.getDestinationId() + " propertyName=" + propertyName + " propertyValue=" + propertyValue + " propertiesIterator=" + propertiesIterator);
            }
            if (destination.getDestinationId().equals("LoggerDestination") && destination.getProperty(LOGGER_DESTINATION_LOGGERNAME) == null) {
                destination.setProperty(LOGGER_DESTINATION_LOGGERNAME, LOGGER_DESTINATION_LOGGERNAME_VALUE);
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "added missing required property 'loggerName' with value 'DMSEventTraceLoggerDestination' to destinationId '" + id + "'");
                }
            }
            try {
                this.validateDestination(destination, false);
                this.addDestination(destination);
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "built a destination with destinationId '" + id + "' from the config file");
                continue;
            }
            catch (Exception e) {
                String badId = destination.getDestinationId();
                badDestination.add(badId);
                if (e instanceof EventConfigException && ("DMS-58070".equals(((EventConfigException)e).getMessageID()) || "DMS-58081".equals(((EventConfigException)e).getMessageID()))) {
                    EventConfigException ece = (EventConfigException)e;
                    Level level = Level.INFO;
                    JFREnvironmentInspector.Availability availability = (JFREnvironmentInspector.Availability)((Object)ece.get("JFREnvironmentInspector.Availability"));
                    if (availability == JFREnvironmentInspector.Availability.NOT_SUPPORTED_BY_PLATFORM || availability == JFREnvironmentInspector.Availability.SUPPORTED_BY_PLATFORM_BUT_NOT_SUPPORTED_BY_JVM) {
                        level = Level.FINE;
                    }
                    this.m_logger.log(level, ece.getLocalizedMessage());
                    continue;
                }
                this.m_logger.logp(Level.WARNING, CLASS_NAME, "buildEventConfig", "DMS-58044", (Object[])new String[]{badId}, (Throwable)e);
            }
        }
        nodes = xevent.getElementsByTagName(CONDITION_FILTER_ELEMENT_NAME);
        nodeLength = nodes.getLength();
        for (int filterIterator = 0; filterIterator < nodeLength; ++filterIterator) {
            Condition con = null;
            String id = ((Element)nodes.item(filterIterator)).getAttribute("id");
            name = ((Element)nodes.item(filterIterator)).getAttribute("name");
            String eventTypes = ((Element)nodes.item(filterIterator)).getAttribute("eventTypes");
            if (eventTypes != null && eventTypes.length() > 0) {
                try {
                    eventTypes = EventType.v1TypeConversion(eventTypes.toUpperCase().replaceAll("\\s", ""));
                }
                catch (Exception e) {
                    if (this.m_logger.isLoggable(Level.WARNING)) {
                        this.m_logger.logp(Level.WARNING, CLASS_NAME, "buildEventConfig", "DMS-58079", (Object[])new String[]{id}, (Throwable)e);
                    }
                    eventTypes = null;
                }
            }
            List<Element> condition = this.getElements(nodes.item(filterIterator).getChildNodes());
            String conString = null;
            try {
                if (condition.size() > 0) {
                    con = this.buildCondition(condition.get(0));
                    List<Element> realConditionElements = this.getElements(condition.get(0).getChildNodes());
                    if (realConditionElements.size() > 0) {
                        Element realCondition = realConditionElements.get(0);
                        this.m_logger.logp(Level.FINE, CLASS_NAME, "buildEventConfig", "XML element name=" + realCondition.getNodeName());
                        if (realCondition.getNodeName().equals(TEXTCONDITION_ELEMENT_NAME)) {
                            NodeList textConditionNL = realCondition.getChildNodes();
                            conString = textConditionNL.item(0).getNodeValue();
                            this.m_logger.logp(Level.FINE, CLASS_NAME, "buildEventConfig", "textCondition : " + textConditionNL.item(0).getNodeValue() + "\n");
                        } else {
                            conString = ConditionFilter.getStringCondition(con);
                        }
                    }
                }
                ConditionFilter conditionFilter = new ConditionFilter(id, con, conString);
                conditionFilter.setFilterName(name);
                conditionFilter.setEventTypes(eventTypes);
                this.addFilter(conditionFilter);
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "built a filter with filterId '" + id + "' from the config file");
                continue;
            }
            catch (Exception e) {
                if (!this.m_logger.isLoggable(Level.WARNING)) continue;
                this.m_logger.logp(Level.WARNING, CLASS_NAME, "buildEventConfig", "DMS-58053", (Object[])new String[]{id}, (Throwable)e);
            }
        }
        nodes = xevent.getElementsByTagName(EVENTROUTE_ELEMENT_NAME);
        nodeLength = nodes.getLength();
        for (int destinationIterator = 0; destinationIterator < nodeLength; ++destinationIterator) {
            boolean enabled;
            String filterId = ((Element)nodes.item(destinationIterator)).getAttribute("filterId");
            if ("".equals(filterId)) {
                filterId = null;
            }
            String destinationId = ((Element)nodes.item(destinationIterator)).getAttribute("destinationId");
            String enabledString = ((Element)nodes.item(destinationIterator)).getAttribute("enabled");
            boolean bl = enabled = !enabledString.contains("false");
            if (badDestination.contains(destinationId)) continue;
            try {
                this.addEventRoute(filterId, destinationId, enabled);
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "built a route with filterId '" + filterId + "' and destinationId '" + destinationId + "' from the config file");
                continue;
            }
            catch (Exception e) {
                if (!this.m_logger.isLoggable(Level.WARNING)) continue;
                this.m_logger.logp(Level.WARNING, CLASS_NAME, "buildEventConfig", "DMS-58054", (Object[])new String[]{filterId, destinationId}, (Throwable)e);
            }
        }
    }

    private Condition buildCondition(Node rootNode) throws EventConfigException {
        List<Element> realConditionElements;
        Condition condition = null;
        NounTypeOpType nop = null;
        OpType op = null;
        boolean ignoreCase = true;
        String name = null;
        String value = null;
        String METHOD_NAME = "buildCondition";
        DataType dataType = null;
        if (rootNode != null && (realConditionElements = this.getElements(rootNode.getChildNodes())).size() > 0) {
            Element realCondition = realConditionElements.get(0);
            if (realCondition.getNodeName().equals("andCondition")) {
                List<Element> conditionParts = this.getElements(realCondition.getChildNodes());
                if (conditionParts.size() == 2) {
                    Condition lh = this.buildCondition(conditionParts.get(0));
                    Condition rh = this.buildCondition(conditionParts.get(1));
                    return new AndCondition(lh, rh);
                }
            } else if (realCondition.getNodeName().equals("orCondition")) {
                List<Element> conditionParts = this.getElements(realCondition.getChildNodes());
                if (conditionParts.size() == 2) {
                    Condition lh = this.buildCondition(conditionParts.get(0));
                    Condition rh = this.buildCondition(conditionParts.get(1));
                    return new OrCondition(lh, rh);
                }
            } else {
                if (realCondition.getNodeName().equals("nounTypeCondition")) {
                    name = realCondition.getAttribute("name");
                    String ntcs = realCondition.getAttribute("op");
                    nop = NounTypeOpType.getOpType(ntcs);
                    return new NounTypeCondition(name, nop);
                }
                if (realCondition.getNodeName().equals("contextCondition")) {
                    name = realCondition.getAttribute("name");
                    op = OpType.getOpType(realCondition.getAttribute("op"));
                    ContextCondition ContextCondition2 = null;
                    if (op == OpType.IS_NULL || op == OpType.IS_NOT_NULL || op == OpType.ISNULL || op == OpType.ISNOTNULL) {
                        ContextCondition2 = new ContextCondition(name, null, op);
                    } else {
                        value = realCondition.getAttribute("value");
                        String ignoreCaseString = realCondition.getAttribute("ignoreCase").toString();
                        if (ignoreCaseString.contains("false")) {
                            ignoreCase = false;
                        }
                        dataType = DataType.getDataType(realCondition.getAttribute("dataType"));
                        ContextCondition2 = new ContextCondition(name, value, op);
                        ContextCondition2.setIgnoreCase(ignoreCase);
                        ContextCondition2.setDataType(dataType);
                    }
                    return ContextCondition2;
                }
                if (realCondition.getNodeName().equals(TEXTCONDITION_ELEMENT_NAME)) {
                    String textCondition = null;
                    if (rootNode.getNodeType() == 1) {
                        Element element = (Element)rootNode;
                        NodeList textConditionNodeList = element.getElementsByTagName(TEXTCONDITION_ELEMENT_NAME);
                        Element element1 = (Element)textConditionNodeList.item(0);
                        NodeList textConditionNL = element1.getChildNodes();
                        this.m_logger.logp(Level.FINE, CLASS_NAME, METHOD_NAME, "textCondition : " + textConditionNL.item(0).getNodeValue() + "\n");
                        textCondition = textConditionNL.item(0).getNodeValue();
                    }
                    ConditionParser conditionParser = new ConditionParser();
                    return conditionParser.parse(textCondition);
                }
            }
        }
        return condition;
    }

    private List<Element> getElements(NodeList nodes) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (nodes != null) {
            int len = nodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = nodes.item(i);
                if (n.getNodeType() != 1) continue;
                elements.add((Element)n);
            }
        }
        return elements;
    }

    private void buildConditionElement(String con, Element elem, Document document) throws EventConfigException {
        String METHOD_NAME = "buildConditionElement";
        if (con == null || elem == null || document == null) {
            this.m_logger.logp(Level.FINE, CLASS_NAME, "buildConditionElement", "DMS-58065", (Object[])new String[]{con.toString(), elem.getTagName()});
            EventConfigException ec = new EventConfigException("DMS-58065");
            ec.addToken(con.toString());
            ec.addToken(elem.getTagName());
            throw ec;
        }
        Element xcon = document.createElementNS(SCHEMA_NAME_SPACE, "condition");
        elem.appendChild(xcon);
        Element xTextCondition = document.createElementNS(SCHEMA_NAME_SPACE, TEXTCONDITION_ELEMENT_NAME);
        xTextCondition.setTextContent(con);
        xcon.appendChild(xTextCondition);
    }

    @JSONUtils.JSONFormatToString
    public static class EventRouteTuple {
        String mFilterId;
        String mDestinationId;
        boolean mEnabled;

        public EventRouteTuple(String filterId, String destinationId, boolean enabled) {
            this.mFilterId = filterId;
            this.mDestinationId = destinationId;
            this.mEnabled = enabled;
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o instanceof EventRouteTuple) {
                EventRouteTuple that = (EventRouteTuple)o;
                retVal = (this.mFilterId == null ? that.mFilterId == null : this.mFilterId.equals(that.mFilterId)) && (this.mDestinationId == null ? that.mDestinationId == null : this.mDestinationId.equals(that.mDestinationId)) && this.mEnabled == that.mEnabled;
            }
            return retVal;
        }

        public int hashCode() {
            return (this.mFilterId == null ? 0 : this.mFilterId.hashCode()) ^ (this.mDestinationId == null ? 0 : this.mDestinationId.hashCode()) ^ (this.mEnabled ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            JSONUtils.appendNameValuePair(sb, "filterId", this.mFilterId);
            sb.append(',');
            JSONUtils.appendNameValuePair(sb, "enabled", this.mEnabled);
            sb.append(',');
            JSONUtils.appendNameValuePair(sb, "destinationId", this.mDestinationId);
            sb.append('}');
            String retVal = sb.toString();
            return retVal;
        }

        public String getDestinationId() {
            return this.mDestinationId;
        }

        public String getFilterId() {
            return this.mFilterId;
        }

        public boolean isEnabled() {
            return this.mEnabled;
        }
    }
}

