/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import oracle.dms.clock.SimpleClock;
import oracle.dms.clock.SimpleClockDescription;
import oracle.dms.util.Time;

public class HighResolutionClock
extends SimpleClock {
    private double _adjustment = 1.0;
    private static long sLastTime = Long.MIN_VALUE;

    public HighResolutionClock() {
        this("highres");
        this._desc = new SimpleClockDescription();
        this._reportedFrequency = 1000000000L;
        this._maxFrequency = 1000000000L;
        this._units = "nsecs";
        this._adjustment = (double)this._reportedFrequency / (double)this._maxFrequency;
        this.start();
    }

    private HighResolutionClock(String name) {
        super(name);
    }

    @Override
    public long getTime() {
        long hrtime = System.nanoTime();
        long retVal = (long)((double)hrtime * this._adjustment);
        if (Time.isEnforceNonDecresingTime()) {
            retVal = HighResolutionClock.getNonDecreasingTime(retVal);
        }
        return retVal;
    }

    private static synchronized long getNonDecreasingTime(long allegedTime) {
        if (allegedTime > sLastTime) {
            sLastTime = allegedTime;
        }
        return sLastTime;
    }

    @Override
    public long adjustTime(long time) {
        return 0L;
    }
}

