/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal.wls;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.RID;
import oracle.dms.context.internal.AbstractContextManager;
import oracle.dms.context.internal.ActivationException;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.WrapUtils;
import oracle.dms.context.internal.wls.WLSContextFamily;
import oracle.dms.context.internal.wls.WLSExecutionContext;
import oracle.dms.util.WeakReferenceWithKey;
import oracle.dms.wls.DMSServletFilter;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextHelper;
import weblogic.diagnostics.integration.DiagnosticIntegrationManager;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PrimitiveContextFactory;
import weblogic.workarea.SerializableWorkContext;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public class WLSContextManager
extends AbstractContextManager<WLSContextFamily, WLSExecutionContext>
implements DomainContextManager<WLSContextFamily, WLSExecutionContext> {
    private DiagnosticIntegrationManager mDiagnosticIntegrationManager;
    private ThreadLocal<ThreadLocalTuple> tPrivateContext;
    static final String UNUSED_XEXECUTION_CONTEXT_NAME_IN_MAP = "oracle.dms.context.internal.wls.WLSExecutionContext";
    static final String DMS_ENTRY_NAME_IN_MAP = "oracle.dms.context.internal.wls.WLSContextFamily";
    static final String CLASS_NAME = WLSContextManager.class.getName();
    static final int INHERITABLE_PROPAGATION_MODE = 334;
    private static final int UNUSED_INHERITABLE_PROPAGATION_MODE = 257;
    private static final int NOT_INHERITABLE_PROPAGATION_MODE = 1;
    private static final int UNUSED_NOT_INHERITABLE_CONTEXT_PROPAGATION_MODE = 1;
    private static Logger sLogger = DMSContextManager.getLogger();
    static WLSContextManager sWLSContextManager;
    private boolean mDiagClassAvailable;

    @Override
    protected synchronized void initNoLogging2() {
        this.initLocalVars();
        this.initStaticVars();
    }

    private void initLocalVars() {
        try {
            DiagnosticContextHelper.getContextId();
            this.mDiagClassAvailable = true;
            this.mDiagnosticIntegrationManager = DiagnosticIntegrationManager.Factory.getInstance();
        }
        catch (Throwable t) {
            this.mDiagClassAvailable = false;
        }
    }

    private void initStaticVars() {
        sWLSContextManager = this;
        this.tPrivateContext = new ThreadLocal();
    }

    @Override
    public WLSExecutionContext getContext(boolean inheritable) throws ActivationException {
        WLSExecutionContext ctx = this.getContext(inheritable, null, null, true);
        return ctx;
    }

    private WLSExecutionContext getContext(boolean inheritable, WorkContextMap map, SerializableWorkContext inSerWkCtx, boolean allowLazyContextCreation) throws ActivationException {
        String METHOD_NAME = "getContext";
        WLSExecutionContext ctx = null;
        if (map == null) {
            map = WLSContextManager.getWorkContextMap();
        }
        if (map != null) {
            SerializableWorkContext swc = inSerWkCtx;
            WLSContextFamily.SerializableImpl ctfSerImpl = null;
            if (swc == null) {
                swc = (SerializableWorkContext)map.get(DMS_ENTRY_NAME_IN_MAP);
            }
            if (swc != null) {
                try {
                    ctfSerImpl = (WLSContextFamily.SerializableImpl)swc.getSerializable();
                }
                catch (Exception e) {
                    sLogger.logp(Level.WARNING, CLASS_NAME, "getContext", "DMS-57001", e);
                }
            }
            if (ctfSerImpl == null || ctfSerImpl.getWLSExecutionContext() == null) {
                if (allowLazyContextCreation) {
                    ctx = this.createAndActivateNewContext(map, null, inheritable, true);
                }
            } else if (ctfSerImpl.isPropagatedToHere()) {
                if (ctfSerImpl.isPropagationSuccess()) {
                    ctx = ctfSerImpl.getWLSExecutionContext();
                    if (!ctx.isActive()) {
                        WLSExecutionContext privateContext = this.getPrivateContext();
                        ctx.activate(map, false, false, true);
                        if (privateContext != null) {
                            DMSServletFilter.RequestInspectorForWLS.transferHttpRequest(privateContext, ctx);
                        }
                    }
                } else if (allowLazyContextCreation) {
                    ctx = this.createAndActivateNewContext(map, RID.createRIDWithUnknownLineage(), true, true);
                }
            } else {
                WLSExecutionContext privateContext = this.getPrivateContext();
                WLSExecutionContext workCtxContext = ctfSerImpl.getWLSExecutionContext();
                if (workCtxContext != null) {
                    if (privateContext == workCtxContext) {
                        ctx = workCtxContext;
                    } else if (workCtxContext.isInheritable()) {
                        ctx = this.createAndActivateChildContext(map, workCtxContext);
                    } else if (allowLazyContextCreation) {
                        ctx = this.createAndActivateNewContext(map, new RID(), inheritable, false);
                    }
                } else {
                    sLogger.logp(Level.WARNING, CLASS_NAME, "getContext", "DMS-57011", new String[]{"WorkContext entry has no reference to WLSExecutionContext."});
                }
            }
        }
        return ctx;
    }

    @Override
    public WLSExecutionContext findContext(String ecid, String ridStr) {
        return null;
    }

    @Override
    protected Logger getLogger() {
        return sLogger;
    }

    @Override
    public WLSExecutionContext getActiveContext() {
        String METHOD_NAME = "getActiveContext";
        WorkContextMap map = WLSContextManager.getWorkContextMap();
        WLSExecutionContext ctx = null;
        if (map != null) {
            try {
                SerializableWorkContext swc = (SerializableWorkContext)map.get(DMS_ENTRY_NAME_IN_MAP);
                if (swc != null) {
                    ctx = this.getContext(true, map, swc, false);
                }
            }
            catch (Throwable t) {
                sLogger.logp(Level.WARNING, CLASS_NAME, "getActiveContext", "DMS-57001", t);
            }
        }
        return ctx;
    }

    @Override
    public void postInit() {
    }

    @Override
    public WLSExecutionContext getContext(long threadId) {
        WLSExecutionContext retVal = null;
        for (WeakReferenceWithKey familyRef : this.mFamilyMap.values()) {
            WLSContextFamily family = (WLSContextFamily)familyRef.get();
            if (family == null) continue;
            for (WLSExecutionContext ctx : ((HashMap)family.getContexts()).values()) {
                long[] threadDetails = ctx.getThreadDetails();
                if (threadDetails[0] != threadId) continue;
                if (retVal == null) {
                    retVal = ctx;
                    continue;
                }
                if (threadDetails[1] <= retVal.getThreadDetails()[1]) continue;
                retVal = ctx;
            }
        }
        return retVal;
    }

    @Override
    public int getActiveCount(String ecid) {
        return 0;
    }

    @Override
    public WLSExecutionContext newFamily(String ecid, RID rid) {
        return this.newFamily(ecid, rid, true);
    }

    private WLSExecutionContext newFamily(String ecid, RID rid, boolean inheritable) {
        if (ecid == null || rid == null) {
            throw new IllegalArgumentException("ecid (" + ecid + ") and rid (" + rid + ") must not be null.");
        }
        WLSContextFamily ctf = new WLSContextFamily(this, ecid);
        this.registerFamily(ctf);
        WLSExecutionContext ctx = new WLSExecutionContext(this, ctf, rid, inheritable);
        ctf.addContext(ctx);
        return ctx;
    }

    @Override
    public WLSContextFamily newFamily(String ecid) {
        if (ecid == null) {
            throw new IllegalArgumentException("ecid must not be null");
        }
        WLSContextFamily ctf = new WLSContextFamily(this, ecid);
        this.registerFamily(ctf);
        return ctf;
    }

    @Override
    public WLSExecutionContext createContextForUnwrap(WLSContextFamily ctf, RID rid) {
        if (ctf == null) {
            throw new IllegalArgumentException("ContextFamily ctf must not be null");
        }
        if (rid == null) {
            throw new IllegalArgumentException("RID rid must not be null");
        }
        WLSExecutionContext ctx = new WLSExecutionContext(this, ctf, rid, true);
        return ctx;
    }

    @Override
    protected void shutdown2() {
        this.mDiagClassAvailable = false;
        this.mDiagnosticIntegrationManager = null;
    }

    @Override
    protected String getPrettyInstanceStateSummary(Level level) {
        StringBuffer sb = new StringBuffer();
        sb.append("WLSContextManager Class: ").append("\n      mFamilyMap:").append(this.mFamilyMap.size()).append("\n    mCtxStashMap:").append(this.mCtxStashMap.size()).append("\n  mCtxSuspendMap:").append(this.mCtxSuspendMap.size()).append("\n");
        return sb.toString();
    }

    void associateWithThread(WorkContextMap workContextMap, WLSExecutionContext ctx, boolean updatePrimaryWorkContextMapEntry, boolean updatePrivateThreadReference) throws ActivationException {
        String METHOD_NAME = "associateWithThread";
        ActivationException activationException = null;
        if (updatePrimaryWorkContextMapEntry) {
            WorkContextMap wcMap = workContextMap;
            if (wcMap == null) {
                wcMap = WLSContextManager.getWorkContextMap();
            }
            WorkContext prevWorkContext = null;
            if (wcMap != null) {
                try {
                    prevWorkContext = ctx.isInheritable() ? wcMap.put(DMS_ENTRY_NAME_IN_MAP, (WorkContext)WLSContextManager.getWorkContext(ctx), 334) : wcMap.put(DMS_ENTRY_NAME_IN_MAP, (WorkContext)WLSContextManager.getWorkContext(ctx), 1);
                }
                catch (Exception e) {
                    activationException = new ActivationException("DMS-57012", (Throwable)e, new String[]{ctx.getIDasString()});
                    try {
                        prevWorkContext = wcMap.remove(DMS_ENTRY_NAME_IN_MAP);
                    }
                    catch (NoWorkContextException nwce) {
                    }
                    catch (Exception e2) {
                        sLogger.logp(Level.WARNING, CLASS_NAME, "associateWithThread", "DMS-57002", e2);
                    }
                }
                if (prevWorkContext != null) {
                    SerializableWorkContext prevAllegedSerWkCtx = (SerializableWorkContext)prevWorkContext;
                    try {
                        WLSContextFamily.SerializableImpl prevSerImpl = (WLSContextFamily.SerializableImpl)prevAllegedSerWkCtx.getSerializable();
                        WLSExecutionContext prevCtx = prevSerImpl.getWLSExecutionContext();
                        if (prevCtx != null) {
                            if (prevCtx == ctx) {
                                sLogger.logp(Level.WARNING, CLASS_NAME, "associateWithThread", "DMS-57011", new String[]{"Context replaced itself in WorkContextMap:" + ctx.getIDasString()});
                            } else if (this.getPrivateContext() == prevCtx) {
                                prevCtx.deactivate(false);
                                if (!updatePrivateThreadReference) {
                                    this.updatePrivateContextReference(null);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        sLogger.logp(Level.WARNING, CLASS_NAME, "associateWithThread", "", e);
                        updatePrivateThreadReference = false;
                    }
                }
            } else {
                activationException = new ActivationException("DMS-57013", new String[]{ctx.getIDasString()});
            }
        }
        if (updatePrivateThreadReference) {
            this.updatePrivateContextReference(ctx);
        }
        if (activationException != null) {
            throw activationException;
        }
    }

    void disassociateFromThread(WorkContextMap workContextMap, WLSExecutionContext ctx) {
        String METHOD_NAME = "disassociateFromThread";
        WorkContextMap wcMap = workContextMap;
        if (wcMap == null) {
            wcMap = WLSContextManager.getWorkContextMap();
        }
        if (wcMap != null) {
            WLSExecutionContext prevAllegedCtx = null;
            try {
                try {
                    SerializableWorkContext swctx = (SerializableWorkContext)wcMap.remove(DMS_ENTRY_NAME_IN_MAP);
                    if (swctx != null) {
                        WLSContextFamily.SerializableImpl serImpl = (WLSContextFamily.SerializableImpl)swctx.getSerializable();
                        if (serImpl != null) {
                            prevAllegedCtx = serImpl.getWLSExecutionContext();
                        }
                        this.updatePrivateContextReference(null);
                    }
                }
                catch (NoWorkContextException e) {}
            }
            catch (Throwable t) {
                sLogger.logp(Level.WARNING, CLASS_NAME, "disassociateFromThread", "DMS-57001", t);
            }
            if (ctx != null) {
                if (prevAllegedCtx == null) {
                    sLogger.logp(Level.FINE, CLASS_NAME, "disassociateFromThread", "Instructed to disassociate context " + ctx.getIDasString() + " from thread but no context object was associated with thread" + " via the WorkContextMap.");
                } else if (ctx != prevAllegedCtx) {
                    sLogger.logp(Level.FINE, CLASS_NAME, "disassociateFromThread", "Instructed to disassociate context " + ctx.getIDasString() + ". The context found, and removed, from the WorkContextMap was " + " not the same instance, but was " + prevAllegedCtx.getIDasString());
                }
            }
        }
    }

    public static SerializableWorkContext getWorkContext(WLSExecutionContext ctx) throws IOException {
        WLSContextFamily.SerializableImpl serImpl = new WLSContextFamily.SerializableImpl(ctx);
        SerializableWorkContext retVal = (SerializableWorkContext)PrimitiveContextFactory.createMutable((Serializable)serImpl);
        return retVal;
    }

    DiagnosticIntegrationManager getDiagnosticIntegrationManager() {
        return this.mDiagnosticIntegrationManager;
    }

    void updateWorkContextMap(WLSExecutionContext ctx) {
        String METHOD_NAME = "updateWorkContextMap";
        WorkContextMap wcMap = WLSContextManager.getWorkContextMap();
        if (wcMap != null) {
            try {
                SerializableWorkContext serWkCtx = (SerializableWorkContext)wcMap.get(DMS_ENTRY_NAME_IN_MAP);
                if (serWkCtx != null && serWkCtx.getSerializable() != null && ((WLSContextFamily.SerializableImpl)serWkCtx.getSerializable()).getWLSExecutionContext() == ctx) {
                    if (ctx.isInheritable()) {
                        wcMap.put(DMS_ENTRY_NAME_IN_MAP, (WorkContext)serWkCtx, 334);
                    } else {
                        wcMap.put(DMS_ENTRY_NAME_IN_MAP, (WorkContext)serWkCtx, 1);
                    }
                }
            }
            catch (Throwable t) {
                sLogger.logp(Level.WARNING, CLASS_NAME, "updateWorkContextMap", "DMS-57001", t);
            }
        }
    }

    private static WorkContextMap getWorkContextMap() {
        WorkContextMap map = null;
        map = WorkContextHelper.getWorkContextHelper().getPriviledgedWorkContextMap();
        return map;
    }

    @Override
    protected void cleanup2(long timeNow) {
    }

    private void updatePrivateContextReference(WLSExecutionContext ctx) {
        ThreadLocalTuple tlt = this.tPrivateContext.get();
        if (tlt == null) {
            tlt = new ThreadLocalTuple();
            this.tPrivateContext.set(tlt);
        }
        if (ctx == null) {
            tlt.clear();
        } else {
            tlt.set(ctx);
        }
    }

    private WLSExecutionContext getPrivateContext() {
        WLSExecutionContext retVal = null;
        ThreadLocalTuple tlt = this.tPrivateContext.get();
        if (tlt != null) {
            retVal = tlt.getCtx();
        }
        return retVal;
    }

    private WLSExecutionContext createAndActivateNewContext(WorkContextMap wcMap, RID rid, boolean inheritable, boolean useIncumbantDiagnosticContext) throws ActivationException {
        WLSExecutionContext retVal = null;
        String ecid = null;
        boolean updateDiagnosticContext = false;
        if (useIncumbantDiagnosticContext) {
            DiagnosticIntegrationManager dcim = this.getDiagnosticIntegrationManager();
            DiagnosticContext dc = null;
            if (dcim != null) {
                dc = dcim.findOrCreateDiagnosticContext(true);
            }
            if (dc != null) {
                ecid = dc.getContextId();
                if (rid == null) {
                    rid = dc.isUnmarshalled() ? RID.createRIDWithUnknownLineage() : new RID();
                }
                dcim.setRID(rid.toString());
            }
        }
        if (ecid == null) {
            ecid = WrapUtils.createECID();
            updateDiagnosticContext = true;
            rid = new RID();
        }
        WLSExecutionContext ctx = this.newFamily(ecid, rid, inheritable);
        ctx.activate(wcMap, updateDiagnosticContext, true, true);
        retVal = ctx;
        return retVal;
    }

    private WLSExecutionContext createAndActivateChildContext(WorkContextMap wcMap, WLSExecutionContext parentCtx) throws ActivationException {
        WLSExecutionContext ctx = new WLSExecutionContext(this, parentCtx);
        WLSContextFamily family = (WLSContextFamily)ctx.getContextFamily();
        family.addContext(ctx);
        ctx.activate(wcMap, true, true, true);
        return ctx;
    }

    static class ThreadLocalTuple {
        WLSExecutionContext mWLSExecutionContext;
        long mSetCounter = -9223372036854775807L;
        long mThreadId = Thread.currentThread().getId();

        ThreadLocalTuple() {
        }

        void set(WLSExecutionContext ctx) {
            ++this.mSetCounter;
            if (this.mSetCounter == Long.MIN_VALUE) {
                this.mSetCounter = -9223372036854775807L;
            }
            this.mWLSExecutionContext = ctx;
            if (ctx != null) {
                ctx.setThreadDetails(this.mThreadId, this.mSetCounter);
            }
        }

        void clear() {
            if (this.mWLSExecutionContext != null) {
                this.mWLSExecutionContext.setThreadDetails(Long.MIN_VALUE, Long.MIN_VALUE);
                this.mWLSExecutionContext = null;
            }
        }

        WLSExecutionContext getCtx() {
            return this.mWLSExecutionContext;
        }
    }
}

