/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventType;
import oracle.dms.event.config.AndCondition;
import oracle.dms.event.config.Condition;
import oracle.dms.event.config.ContextCondition;
import oracle.dms.event.config.DataType;
import oracle.dms.event.config.Filter;
import oracle.dms.event.config.JMXHelper;
import oracle.dms.event.config.NounTypeCondition;
import oracle.dms.event.config.OpType;
import oracle.dms.event.config.OrCondition;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.Time;

@JSONUtils.JSONFormatToString
public class ConditionFilter
implements Filter,
Serializable {
    private static final String FILTER_ID_KEY = "filterId";
    private static final String FILTER_NAME_KEY = "filterName";
    private static final String EVENT_TYPES_KEY = "eventTypes";
    private static final String CONDITION_STRING = "conditionString";
    private int m_hashCode;
    private Condition m_condition;
    private String m_conditionString;
    private String m_filterId;
    private String m_filterName;
    private String m_eventTypes;
    private static final int SEED = 200;
    private static final long serialVersionUID = 0L;
    private AtomicLong mLastModified;

    public static ConditionFilter from(CompositeData cd) {
        Condition cdx = null;
        if (cd.containsKey("condition")) {
            CompositeData conData = (CompositeData)cd.get("condition");
            cdx = JMXHelper.toCondition(conData);
        }
        String conditionString = null;
        if (cd.containsKey(CONDITION_STRING)) {
            conditionString = (String)cd.get(CONDITION_STRING);
        }
        ConditionFilter filter = new ConditionFilter((String)cd.get(FILTER_ID_KEY), cdx, conditionString);
        filter.setFilterName((String)cd.get(FILTER_NAME_KEY));
        if (cd.containsKey(EVENT_TYPES_KEY)) {
            String eventTypes = (String)cd.get(EVENT_TYPES_KEY);
            filter.setEventTypes(eventTypes);
        }
        return filter;
    }

    public ConditionFilter(String filterId, Condition condition, String conditionString) {
        this.ConditionFilterInit(filterId, condition, conditionString);
    }

    @Deprecated
    public ConditionFilter(String filterId, Condition condition) {
        this.ConditionFilterInit(filterId, condition, null);
    }

    private void ConditionFilterInit(String filterId, Condition condition, String conditionString) {
        if (!DMSUtil.isLegalIdentifier(filterId)) {
            throw new IllegalArgumentException("invalid argument to ConditionFilter; filterId=" + filterId + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        if (conditionString == null) {
            conditionString = this.getConditionAsString();
        }
        this.m_filterId = filterId;
        this.m_condition = condition;
        this.m_conditionString = conditionString;
        this.mLastModified = new AtomicLong();
        this.setLastModified();
        this.setHashCode();
    }

    @Override
    public String getFilterId() {
        return this.m_filterId;
    }

    @Override
    public String getFilterName() {
        return this.m_filterName;
    }

    public void setFilterName(String filterName) {
        this.m_filterName = filterName;
        this.setLastModified();
        this.setHashCode();
    }

    public String getEventTypes() {
        return this.m_eventTypes;
    }

    public void setEventTypes(String eventTypesString) {
        if (eventTypesString != null && !eventTypesString.isEmpty()) {
            eventTypesString = eventTypesString.toUpperCase().replaceAll("\\s", "");
            this.validateEventTypeString(eventTypesString);
            this.m_eventTypes = eventTypesString;
        } else {
            this.m_eventTypes = null;
        }
        this.setLastModified();
        this.setHashCode();
    }

    private void validateEventTypeString(String eventTypesString) throws IllegalArgumentException {
        EventType[] eventTypesOfInterest = eventTypesString == null ? EventType.getAllEventTypes() : EventType.parseList(eventTypesString);
        boolean instrumentationEventsExpected = false;
        for (EventType eventType : eventTypesOfInterest) {
            if (!eventType.getSourceType().isTypeOf(EventSourceType.INSTRUMENTATION_NODE)) continue;
            instrumentationEventsExpected = true;
        }
        if (!instrumentationEventsExpected && ConditionFilter.getAnyNounTypeCondition(this.m_condition) != null) {
            throw new IllegalArgumentException("NounType conditions are not permitted in a ConditionFilter if the eventType setting excludes all events relating to either nouns or sensors or both.");
        }
    }

    private static NounTypeCondition getAnyNounTypeCondition(Condition condition) {
        NounTypeCondition retVal = null;
        if (condition instanceof NounTypeCondition) {
            retVal = (NounTypeCondition)condition;
        } else {
            Condition lhCondition = null;
            Condition rhCondition = null;
            if (condition instanceof AndCondition) {
                AndCondition andCondition = (AndCondition)condition;
                lhCondition = andCondition.getLHCondition();
                rhCondition = andCondition.getRHCondition();
            } else if (condition instanceof OrCondition) {
                OrCondition orCondition = (OrCondition)condition;
                lhCondition = orCondition.getLHCondition();
                rhCondition = orCondition.getRHCondition();
            }
            if (lhCondition != null) {
                retVal = ConditionFilter.getAnyNounTypeCondition(lhCondition);
            }
            if (retVal == null && rhCondition != null) {
                retVal = ConditionFilter.getAnyNounTypeCondition(rhCondition);
            }
        }
        return retVal;
    }

    public void setCondition(Condition condition) {
        this.validateEventTypeString(this.m_eventTypes);
        this.m_condition = condition;
        this.setLastModified();
        this.setHashCode();
    }

    public void removeCondition() {
        this.m_condition = null;
        this.setLastModified();
        this.setHashCode();
    }

    public Condition _getCondition() {
        return this.m_condition;
    }

    public String getConditionAsString() {
        if (this.m_conditionString == null) {
            Condition condition = this._getCondition();
            return ConditionFilter.getStringCondition(condition);
        }
        return this.m_conditionString;
    }

    static String getStringCondition(Condition c1) {
        String stringCondition = null;
        if (c1 instanceof AndCondition) {
            AndCondition and1 = (AndCondition)c1;
            stringCondition = ConditionFilter.getStringCondition(and1.getLHCondition()) + " and " + ConditionFilter.getStringCondition(and1.getRHCondition());
        } else if (c1 instanceof OrCondition) {
            OrCondition or1 = (OrCondition)c1;
            stringCondition = ConditionFilter.getStringCondition(or1.getLHCondition()) + " or " + ConditionFilter.getStringCondition(or1.getRHCondition());
        } else if (c1 instanceof ContextCondition) {
            ContextCondition con = (ContextCondition)c1;
            StringBuilder sb = new StringBuilder();
            sb = sb.append("context " + con.getName() + " " + (Object)((Object)con.getOpType()));
            String value = con.getValue();
            if (value != null) {
                DataType deducedDataType = null;
                deducedDataType = con.getDataType() == null ? DataType.getDataType((DataType)null, value) : DataType.getDataType(con.getDataType(), value);
                if (deducedDataType == DataType.STRING) {
                    if (con.getOpType() != OpType.IS_NOT_NULL && con.getOpType() != OpType.ISNOTNULL && con.getOpType() != OpType.IS_NULL && con.getOpType() != OpType.ISNULL) {
                        sb.append(" \"" + value + "\"");
                    }
                } else {
                    sb.append(" " + value);
                }
                if (con.getIgnoreCase() && deducedDataType == DataType.STRING) {
                    sb.append(" ignoreCase");
                }
            }
            stringCondition = sb.toString();
        } else if (c1 instanceof NounTypeCondition) {
            NounTypeCondition Noun2 = (NounTypeCondition)c1;
            stringCondition = "nounType " + Noun2.getOpType() + " " + Noun2.getNounType();
        }
        return stringCondition;
    }

    public CompositeData toCompositeData(CompositeType ct) {
        if (ct == null) {
            ct = ConditionFilter.toCompositeType();
        }
        try {
            ArrayList<Object> objectsList = new ArrayList<Object>(5);
            ArrayList<String> itemNames = new ArrayList<String>(ct.keySet());
            ArrayList<String> itemDescriptions = new ArrayList<String>();
            ArrayList<OpenType<Object>> itemTypes = new ArrayList<OpenType<Object>>();
            for (String item : itemNames) {
                itemDescriptions.add(ct.getDescription(item));
                itemTypes.add(ct.getType(item));
            }
            objectsList.add(this.m_filterId);
            objectsList.add(this.m_filterName);
            itemNames.add(EVENT_TYPES_KEY);
            itemDescriptions.add("Event types of interest");
            itemTypes.add(SimpleType.STRING);
            objectsList.add(this.m_eventTypes);
            if (this.m_condition != null) {
                itemNames.add("condition");
                itemDescriptions.add("Structured Filter condition");
                itemTypes.add(JMXHelper.toCompositeType(this.m_condition));
                objectsList.add(JMXHelper.toCompositeData(this.m_condition));
            }
            if (this.m_conditionString != null) {
                itemNames.add(CONDITION_STRING);
                itemDescriptions.add("Filter condition");
                itemTypes.add(SimpleType.STRING);
                objectsList.add(this.m_conditionString);
            }
            CompositeType xct = new CompositeType(ct.getTypeName(), ct.getDescription(), itemNames.toArray(new String[0]), itemDescriptions.toArray(new String[0]), itemTypes.toArray(new OpenType[0]));
            CompositeDataSupport cd = new CompositeDataSupport(xct, itemNames.toArray(new String[0]), objectsList.toArray(new Object[0]));
            return cd;
        }
        catch (Exception e) {
            throw new RuntimeException("failure converting filter \"" + this.m_filterId + "\" to composite data", e);
        }
    }

    @Override
    public long getLastModified() {
        return this.mLastModified.get();
    }

    public static CompositeType toCompositeType() {
        try {
            return new CompositeType("oracle.dms.event.config.ConditionFilter", "oracle.dms.event.config.ConditionFilter", new String[]{FILTER_ID_KEY, FILTER_NAME_KEY}, new String[]{FILTER_ID_KEY, FILTER_NAME_KEY}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    private void setLastModified() {
        this.mLastModified.set(Time.currentTimeMillis());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConditionFilter)) {
            return false;
        }
        ConditionFilter conditionFilter = (ConditionFilter)obj;
        boolean getFilterId = this.getFilterId() == null && conditionFilter.getFilterId() == null ? true : (this.getFilterId() == null && conditionFilter.getFilterId() != null ? false : (this.getFilterId() != null && conditionFilter.getFilterId() == null ? false : this.getFilterId().equals(conditionFilter.getFilterId())));
        boolean getFilterName = this.getFilterName() == null && conditionFilter.getFilterName() == null ? true : (this.getFilterName() == null && conditionFilter.getFilterName() != null ? false : (this.getFilterName() != null && conditionFilter.getFilterName() == null ? false : this.getFilterName().equals(conditionFilter.getFilterName())));
        boolean getEventTypes = this.getEventTypes() == null && conditionFilter.getEventTypes() == null ? true : (this.getEventTypes() == null && conditionFilter.getEventTypes() != null ? false : (this.getEventTypes() != null && conditionFilter.getEventTypes() == null ? false : this.getEventTypes().equals(conditionFilter.getEventTypes())));
        boolean getCondition = this._getCondition() == null && conditionFilter._getCondition() == null ? true : (this._getCondition() == null && conditionFilter._getCondition() != null ? false : (this._getCondition() != null && conditionFilter._getCondition() == null ? false : this._getCondition().equals(conditionFilter._getCondition())));
        return getFilterId && getFilterName && getEventTypes && getCondition;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    private void setHashCode() {
        int retVal = 200;
        if (this.getFilterId() != null) {
            retVal = retVal * 200 + this.getFilterId().hashCode();
        }
        if (this.getFilterName() != null) {
            retVal = retVal * 200 + this.getFilterName().hashCode();
        }
        if (this._getCondition() != null) {
            retVal = retVal * 200 + this._getCondition().hashCode();
        }
        if (this.getEventTypes() != null) {
            retVal = retVal * 200 + this.getEventTypes().hashCode();
        }
        this.m_hashCode = retVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        JSONUtils.appendNameValuePair(sb, FILTER_ID_KEY, this.m_filterId);
        if (this.m_conditionString != null) {
            sb.append(',');
            JSONUtils.appendNameValuePair(sb, "condition", this.m_conditionString);
        }
        sb.append('}');
        return sb.toString();
    }
}

